/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.HttpKeepaliveConnection;
import com.adventnet.wms.nioclient.http.KeepaliveTimeOutListener;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class HttpProxyKeepaliveConnection {
    private String proxyhost;
    private String proxyUsername;
    private String proxyPassword;
    private int keepaliveThreshold;
    private Hashtable<String, ConcurrentLinkedQueue<HttpKeepaliveConnection>> connection = new Hashtable();
    private Logger logger = Logger.getLogger(HttpProxyKeepaliveConnection.class.getName());

    public HttpProxyKeepaliveConnection(String proxyhost, String proxyUsername, String proxyPassword, int keepaliveThreshold) {
        this.proxyhost = proxyhost;
        this.proxyUsername = proxyUsername;
        this.proxyPassword = proxyPassword;
        this.keepaliveThreshold = keepaliveThreshold;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addConnection(String host, SocketChannel sc, SelectionKey key, SSLEngine engine, long connectionExpireTime) {
        try {
            if (this.connection.containsKey(host)) {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = this.connection.get(host);
                if (!queue.isEmpty()) {
                    if (queue.size() >= this.keepaliveThreshold) return;
                    HttpKeepaliveConnection obj = new HttpKeepaliveConnection(host, sc, key, engine, connectionExpireTime);
                    queue.add(obj);
                    this.connection.put(host, queue);
                    Hashtable<String, Object> ht = new Hashtable<String, Object>();
                    ht.put("proxyinfo", this);
                    ht.put("connectioninfo", obj);
                    KeepaliveTimeOutListener.TRACKER.touch(connectionExpireTime, ht);
                    return;
                } else {
                    this.addNewConnection(host, sc, key, engine, connectionExpireTime);
                }
                return;
            } else {
                this.addNewConnection(host, sc, key, engine, connectionExpireTime);
            }
            return;
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Exception in add Proxy Connection : ", e);
        }
    }

    private void addNewConnection(String host, SocketChannel sc, SelectionKey key, SSLEngine engine, long connectionExpireTime) {
        try {
            HttpKeepaliveConnection obj = new HttpKeepaliveConnection(host, sc, key, engine, connectionExpireTime);
            ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = new ConcurrentLinkedQueue<HttpKeepaliveConnection>();
            queue.add(obj);
            this.connection.put(host, queue);
            Hashtable<String, Object> ht = new Hashtable<String, Object>();
            ht.put("proxyinfo", this);
            ht.put("connectioninfo", obj);
            KeepaliveTimeOutListener.TRACKER.touch(connectionExpireTime, ht);
        }
        catch (Exception e) {
            this.logger.log(Level.INFO, "Exception in add New Proxy Connection : ", e);
        }
    }

    public HttpKeepaliveConnection getConnection(String host, String username, String password) {
        try {
            if (this.isValidCredentials(username, password) && this.connection.containsKey(host)) {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = this.connection.get(host);
                if (!queue.isEmpty()) {
                    HttpKeepaliveConnection obj = queue.poll();
                    Hashtable<String, Object> ht = new Hashtable<String, Object>();
                    ht.put("proxyinfo", this);
                    ht.put("connectioninfo", obj);
                    KeepaliveTimeOutListener.TRACKER.remove(obj.getConnectionExpireTime(), ht);
                    return obj;
                }
                this.connection.remove(host);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public void handleExpired(HttpKeepaliveConnection obj) {
        try {
            String host = obj.getHost();
            if (this.connection.containsKey(host)) {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = this.connection.get(host);
                if (queue.contains(obj)) {
                    queue.remove(obj);
                }
                if (queue.isEmpty() || queue.size() == 0) {
                    this.connection.remove(host);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isConnectedHost(String host, String username, String password) {
        try {
            if (this.isValidCredentials(username, password)) {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = this.connection.get(host);
                if (!queue.isEmpty()) {
                    return true;
                }
                this.connection.remove(host);
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isEmpty() {
        try {
            if (!this.connection.isEmpty() || this.connection.size() > 0) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public String getProxyHostName() {
        return this.proxyhost;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    private boolean isValidCredentials(String username, String password) {
        try {
            if (this.proxyUsername.equals(username) && this.proxyPassword.equals(password)) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }
}

