/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.apns;

import com.adventnet.wms.nioclient.apns.APNSEventDispatcher;
import com.adventnet.wms.nioclient.apns.APNSRequest;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

public class APNSNetworkEventProcessor {
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(APNSRequest request, int eventcode) {
        if (!initialized) {
            APNSNetworkEventProcessor.initialize(2);
        }
        executor.execute(new APNSNetEventProcessor(request, eventcode));
    }

    static {
        initialized = false;
    }

    static class APNSNetEventProcessor
    implements Runnable {
        private APNSRequest request;
        private int eventcode;

        public APNSNetEventProcessor(APNSRequest request, int eventcode) {
            this.request = request;
            this.eventcode = eventcode;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public void run() {
            try {
                switch (this.eventcode) {
                    case 1: {
                        try {
                            APNSEventDispatcher.process(this.request, 2);
                            return;
                        }
                        catch (Exception ex) {
                            ex.printStackTrace();
                            if (this.request.isClosed()) return;
                            APNSEventDispatcher.process(this.request, -3);
                            try {
                                this.request.close();
                                return;
                            }
                            catch (Exception exception) {}
                        }
                        return;
                    }
                    case -5: {
                        if (this.request.isClosed()) return;
                        APNSEventDispatcher.process(this.request, -5);
                        try {
                            this.request.close();
                            return;
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                }
                return;
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

