/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.apns;

import com.adventnet.wms.nioclient.SSLWrapper;
import com.adventnet.wms.nioclient.apns.APNSDevice;
import com.adventnet.wms.nioclient.apns.APNSEventDispatcher;
import com.adventnet.wms.nioclient.apns.APNSFeedbackListener;
import com.adventnet.wms.nioclient.apns.APNSFeedbackResponse;
import com.adventnet.wms.nioclient.apns.APNSRequest;
import com.adventnet.wms.nioclient.apns.APNSSelectorPoolFactory;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;

public class APNSFeedbackRequest
extends APNSRequest {
    protected APNSFeedbackResponse response = null;
    protected APNSFeedbackListener listener = null;
    private APNSDevice failedDevice = null;
    protected long readexpiretime = -1L;
    private long timestamp = -1L;

    public APNSFeedbackRequest(String host, int port, String provider, String setup) {
        super(host, port, provider, setup);
    }

    public void setListener(APNSFeedbackListener listener) {
        this.listener = listener;
    }

    @Override
    public void connect() throws IOException {
        this.response = new APNSFeedbackResponse();
        APNSSelectorPoolFactory.getInstance(this.port).connect(this.host, this.port, this);
        this.byteBuffer = ByteBuffer.allocate(3072);
    }

    @Override
    public void setSocketChannel(SocketChannel sc) {
        try {
            this.sc = sc;
            if (this.isSSL) {
                String contxtkey = this.host + "_" + this.provider + "_" + this.setup;
                this.ssl = new SSLWrapper(sc, this.host);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void setHSDone() {
        this.hsdone = true;
    }

    @Override
    public boolean isHSDone() {
        return this.hsdone;
    }

    @Override
    public boolean isSSL() {
        return this.isSSL;
    }

    @Override
    public boolean doHandshake(SelectionKey key) throws IOException {
        if (this.key == null) {
            this.key = key;
        }
        return this.ssl.doHandshake(key);
    }

    @Override
    public void readData(SelectionKey key) throws IOException, CancelledKeyException {
        try {
            if (this.key == null) {
                this.key = key;
            }
            int count = -1;
            if (this.isSSL) {
                if (this.ssl.doHandshake(key)) {
                    count = this.ssl.read();
                    this.byteBuffer = this.ssl.getDataBuffer();
                }
            } else {
                count = ((SocketChannel)key.channel()).read(this.byteBuffer);
            }
            if (count > 0) {
                this.pendingcount = count;
                if (this.failedDevice == null) {
                    this.failedDevice = new APNSDevice();
                }
                switch (this.failedDevice.getStage()) {
                    case 0: {
                        long time = this.readTimestamp(this.byteBuffer);
                        if (time == -1L) {
                            this.copyPending(this.byteBuffer);
                            break;
                        }
                        this.failedDevice.setTimestamp(this.timestamp);
                    }
                    case 1: {
                        int tokenlength = this.readTokenLength(this.byteBuffer);
                        if (tokenlength == -1) {
                            this.copyPending(this.byteBuffer);
                            break;
                        }
                        this.failedDevice.setTokenLength(tokenlength);
                    }
                    case 2: {
                        String token = this.readDeviceToken(this.byteBuffer, this.failedDevice.getTokenLength());
                        if (token == null) {
                            this.copyPending(this.byteBuffer);
                            break;
                        }
                        this.failedDevice.setToken(token);
                    }
                    case 3: {
                        this.response.addDevice(this.failedDevice);
                        this.failedDevice = null;
                    }
                }
                this.key.interestOps(1);
            } else {
                if (count < 0) {
                    throw new IOException("Read -1");
                }
                if (count == 0) {
                    ++this.zeroReadCount;
                    key.interestOps(1);
                    if (this.zeroReadCount > this.maxZeroReadCount) {
                        throw new IOException("Key Read Count = 0 : Max Crossed");
                    }
                }
            }
        }
        catch (IOException ex) {
            if (this.response.getFailedDevices().size() > 0) {
                APNSEventDispatcher.process(this, 3);
            }
            throw ex;
        }
        catch (Exception ex) {
            if (this.response.getFailedDevices().size() > 0) {
                APNSEventDispatcher.process(this, 3);
            }
            throw new IOException(ex.getMessage());
        }
    }

    private void copyPending(ByteBuffer bb) {
        int rem = bb.remaining();
        if (rem == 0) {
            bb.clear();
            return;
        }
        byte[] remdata = new byte[rem];
        bb.get(remdata);
        bb.clear();
        bb.put(remdata);
        remdata = null;
    }

    protected void clearBuffer(ByteBuffer bb) {
        if (this.isSSL) {
            this.ssl.clearDataBuffer();
        }
        bb.clear();
    }

    private long readTimestamp(ByteBuffer bb) {
        bb.position(0);
        if (this.pendingcount < 4) {
            return -1L;
        }
        long ts = (bb.get(0) & 0xFF) << 24 | (bb.get(1) & 0xFF) << 16 | (bb.get(2) & 0xFF) << 8 | bb.get(3) & 0xFF;
        this.pendingcount -= 4;
        bb.position(bb.position() + 4);
        return ts;
    }

    private int readTokenLength(ByteBuffer bb) {
        if (this.pendingcount < 2) {
            return -1;
        }
        int tokenlength = (bb.get(0) & 0xFF) << 8 | bb.get(1) & 0xFF;
        this.pendingcount -= 2;
        bb.position(bb.position() + 2);
        return tokenlength;
    }

    private String readDeviceToken(ByteBuffer bb, int tokenlength) {
        if (this.pendingcount < tokenlength) {
            return null;
        }
        StringBuilder token = new StringBuilder();
        for (int i = bb.position(); i < tokenlength; ++i) {
            int cint = bb.get(i) & 0xFF;
            token.append(Integer.toString(cint, 16));
        }
        this.pendingcount -= tokenlength;
        bb.position(bb.position() + tokenlength);
        return token.toString();
    }

    @Override
    public void close() {
        try {
            if (this.response.getFailedDevices().size() > 0) {
                APNSEventDispatcher.process(this, 3);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.isSSL) {
                this.ssl.close();
            } else {
                this.sc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.channel().close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.key.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.closed = true;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void notifyListener(int event) throws Exception {
        switch (event) {
            case -1: {
                this.listener.onConnectError();
                return;
            }
            case -2: {
                this.listener.onReadTimeout();
                return;
            }
            case 3: {
                this.listener.onResponse(this.response);
                return;
            }
            case -5: {
                this.listener.onDisconnect();
                return;
            }
        }
    }
}

