/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient;

import com.adventnet.wms.nioclient.SSLTrustManager;
import com.adventnet.wms.nioclient.util.NIOCommonUtil;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.conscrypt.Conscrypt;
import org.conscrypt.OpenSSLContextImpl;

public class SSLManager {
    private static Hashtable<String, SSLContext> sslClientCntxMap = new Hashtable();
    private static Hashtable<String, OpenSSLContextImpl> conscryptCntxMap = new Hashtable();
    private static ArrayList ignoreSSLVerDomains = new ArrayList();
    private static ArrayList sslVersionIgnoreList = new ArrayList();
    private static boolean conscrypt = false;
    private static boolean conscryptticketresumption = false;
    private static ArrayList validdomains = new ArrayList();

    public static void initializeClientManager() throws Exception {
        String domain2;
        ArrayList domains = SSLManager.getExternalDomains();
        for (String domain2 : domains) {
            SSLManager.initClientCntx(domain2, null, null, null);
        }
        domain2 = "default";
        SSLManager.initClientCntx(domain2, null, null, null);
    }

    public static void initializeClientManager(String domain, String fileNameWithPath, String password) throws Exception {
        SSLManager.initClientCntx(domain, fileNameWithPath, password, null);
    }

    public static void initializeClientManager(String domain, String fileNameWithPath, String password, String keystoreType) throws Exception {
        SSLManager.initClientCntx(domain, fileNameWithPath, password, keystoreType);
    }

    private static void initClientCntx(String domain, String fileNameWithPath, String password, String keystoreType) throws Exception {
        if (!conscrypt) {
            SSLContext sslClientCntx = SSLContext.getInstance("TLSv1.2");
            SSLTrustManager tm = new SSLTrustManager(domain, fileNameWithPath, password, keystoreType);
            sslClientCntx.init(tm.getKeyManagers(), new TrustManager[]{tm}, null);
            sslClientCntx.getClientSessionContext().setSessionCacheSize(1);
            if (!sslClientCntxMap.containsKey(domain)) {
                sslClientCntxMap.put(domain, sslClientCntx);
            }
        } else {
            OpenSSLContextImpl sslClientCntx = (OpenSSLContextImpl)Conscrypt.newPreferredSSLContextSpi();
            SSLTrustManager tm = new SSLTrustManager(domain, fileNameWithPath, password, keystoreType);
            sslClientCntx.engineInit(tm.getKeyManagers(), new TrustManager[]{tm}, null);
            sslClientCntx.engineGetClientSessionContext().setSessionCacheSize(1);
            if (!conscryptCntxMap.containsKey(domain)) {
                conscryptCntxMap.put(domain, sslClientCntx);
            }
        }
    }

    public static void addToIgnoreSSLVerDomainList(ArrayList domainList) {
        if (domainList != null && domainList.size() > 0) {
            ignoreSSLVerDomains.addAll(domainList);
        }
    }

    public static void addToIgnoreSSLVerDomainList(String domainList) {
        if (domainList != null && !ignoreSSLVerDomains.contains(domainList)) {
            ignoreSSLVerDomains.add(domainList);
        }
    }

    public static void addSSLVersionIgnoreList(ArrayList sslverignoreList) {
        if (sslverignoreList != null && sslverignoreList.size() > 0) {
            sslVersionIgnoreList.addAll(sslverignoreList);
        }
    }

    public static void initializeClientManager(String provider, String setup, String domain, String keystorefile, String keystoretype, String password) throws Exception {
        SSLManager.initializeClientManager(provider, setup, domain, new FileInputStream(keystorefile), keystoretype, password);
    }

    public static void initializeClientManager(String provider, String setup, String domain, InputStream keystorestream, String keystoretype, String password) throws Exception {
        KeyStore km = KeyStore.getInstance(keystoretype);
        km.load(keystorestream, password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("sunx509");
        kmf.init(km, password.toCharArray());
        if (!conscrypt) {
            SSLContext sslClientCntx = SSLContext.getInstance("TLSv1.2");
            sslClientCntx.init(kmf.getKeyManagers(), new TrustManager[]{new SSLTrustManager(domain)}, null);
            sslClientCntxMap.put(domain + "_" + provider + "_" + setup, sslClientCntx);
        } else {
            OpenSSLContextImpl sslClientCntx = (OpenSSLContextImpl)Conscrypt.newPreferredSSLContextSpi();
            sslClientCntx.engineInit(kmf.getKeyManagers(), new TrustManager[]{new SSLTrustManager(domain)}, null);
            conscryptCntxMap.put(domain + "_" + provider + "_" + setup, sslClientCntx);
        }
    }

    public static SSLContext getSSLClientContext(String indomain) {
        if (sslClientCntxMap.get(indomain) != null) {
            return sslClientCntxMap.get(indomain);
        }
        return sslClientCntxMap.get("default");
    }

    public static OpenSSLContextImpl getConscryptContext(String indomain) {
        if (conscryptCntxMap.get(indomain) != null) {
            return conscryptCntxMap.get(indomain);
        }
        return conscryptCntxMap.get("default");
    }

    public static SSLEngine getSSLEngine(String host) {
        if (!conscrypt) {
            return SSLManager.getSSLClientContext(host).createSSLEngine();
        }
        SSLEngine eng = SSLManager.getConscryptContext(host).engineCreateSSLEngine();
        if (conscryptticketresumption) {
            Conscrypt.setUseSessionTickets((SSLEngine)eng, (boolean)true);
        }
        return eng;
    }

    public static boolean isConscryptEnabled() {
        return conscrypt;
    }

    public static void setConscrypt(boolean status) {
        conscrypt = status;
    }

    public static void setConscryptTicketResumption(boolean status) {
        conscryptticketresumption = status;
    }

    public static void setJREHome(String path) {
        System.setProperty("jre.home", path);
    }

    public static void setValidDomains(String domains) {
        validdomains = NIOCommonUtil.getList(domains);
    }

    public static ArrayList getExternalDomains() {
        return validdomains;
    }

    public static void updateExternalDomains(String domain) {
        String orgvaliddomains = NIOCommonUtil.getString(SSLManager.getExternalDomains());
        SSLManager.setValidDomains(domain + "," + orgvaliddomains);
    }

    public static boolean ignoreSSLVersion(String host) {
        return ignoreSSLVerDomains.contains(host);
    }

    public static ArrayList getSSLVersionIgnoreList() {
        return sslVersionIgnoreList;
    }
}

