/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.zvp.recording;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.zvp.recording.MediaConverter;
import com.adventnet.wms.common.zvp.recording.MediaFileMeta;
import com.adventnet.wms.common.zvp.recording.MediaFormat;
import com.adventnet.wms.common.zvp.recording.MediaRecording;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;

public class MediaUtil {
    private static final String RECORDING_ID = "recording_id";
    private static final String MEDIA_FORMATS = "media_formats";
    private static final String FILE_DETAILS = "file_details";
    private static final String START_TIME = "start_time";
    private static final String END_TIME = "end_time";
    private static final String SERVICENAME = "serviceName";
    private static final String ORGID = "orgId";
    private static final String EARTOKEN = "earToken";
    private static final String CONTAINER = "container";
    private static final String VIDEO_CODEC = "video_codec";
    private static final String AUDIO_CODEC = "audio_codec";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String VIDEO_BITRATE = "video_bitrate";
    private static final String AUDIO_BITRATE = "audio_bitrate";
    private static final String STORAGEID = "storageID";
    private static final String FOLDERNAME = "folderName";
    private static final String ENTITYID = "entityID";
    private static final String SOURCEPATH = "sourcePath";
    private static final String DFSFILEPATH = "dfsFilePath";
    private static final String BLOCKID = "blockID";
    private static final String SIZE = "size";
    private static final String TUUID = "tuuid";
    private static final String SCOPEID = "scopeID";
    private static final String ISENCRYPT = "isEncrypt";
    private static final String CONVERSIONID = "CONVERSIONID";
    private static final String INPUT_FORMAT = "input_format";
    private static final String INPUT_FILE = "input_file";
    private static final String OUTPUT_DETAILS = "output_details";

    public static MediaRecording convertToMediaRecording(Hashtable dataHash) {
        Hashtable fileDetails;
        List<MediaFormat> mediaFormats;
        MediaRecording mediarecording = new MediaRecording((String)dataHash.get(RECORDING_ID));
        if (dataHash.containsKey(MEDIA_FORMATS) && (mediaFormats = MediaUtil.parseMediaFormatsList(dataHash.get(MEDIA_FORMATS))) != null) {
            mediarecording.addMediaFormats(mediaFormats);
        }
        if (dataHash.containsKey(FILE_DETAILS) && (fileDetails = MediaUtil.parseFileDetails(dataHash.get(FILE_DETAILS))) != null) {
            mediarecording.addFileDetails(fileDetails);
        }
        if (dataHash.containsKey(START_TIME)) {
            mediarecording.setStartTime(Long.parseLong((String)dataHash.get(START_TIME)));
        }
        if (dataHash.containsKey(END_TIME)) {
            mediarecording.setEndTime(Long.parseLong((String)dataHash.get(END_TIME)));
        }
        if (dataHash.containsKey(SERVICENAME)) {
            mediarecording.setServiceName((String)dataHash.get(SERVICENAME));
        }
        if (dataHash.containsKey(ORGID)) {
            mediarecording.setOrgId((String)dataHash.get(ORGID));
        }
        if (dataHash.containsKey(EARTOKEN)) {
            mediarecording.setEarToken((String)dataHash.get(EARTOKEN));
        }
        return mediarecording;
    }

    public static MediaFormat convertToMediaFormat(Hashtable dataHash) {
        MediaFormat mediaFormat = new MediaFormat((String)dataHash.get(CONTAINER));
        if (dataHash.containsKey(VIDEO_CODEC)) {
            mediaFormat.setVideoCodec((String)dataHash.get(VIDEO_CODEC));
        }
        if (dataHash.containsKey(AUDIO_CODEC)) {
            mediaFormat.setAudioCodec((String)dataHash.get(AUDIO_CODEC));
        }
        if (dataHash.containsKey(WIDTH)) {
            mediaFormat.setWidth(Integer.parseInt((String)dataHash.get(WIDTH)));
        }
        if (dataHash.containsKey(HEIGHT)) {
            mediaFormat.setHeight(Integer.parseInt((String)dataHash.get(HEIGHT)));
        }
        if (dataHash.containsKey(VIDEO_BITRATE)) {
            mediaFormat.setVideoBitRate(Long.parseLong((String)dataHash.get(VIDEO_BITRATE)));
        }
        if (dataHash.containsKey(AUDIO_BITRATE)) {
            mediaFormat.setAudioBitRate(Long.parseLong((String)dataHash.get(AUDIO_BITRATE)));
        }
        if (dataHash.containsKey("storage_type")) {
            mediaFormat.setStorages(Integer.parseInt((String)dataHash.get("storage_type")));
        }
        return mediaFormat;
    }

    public static void convert(Hashtable dataHash, MediaFileMeta mediaFileMeta) {
        String storageType = (String)dataHash.get("storage_type");
        if (storageType.equals("WFS")) {
            if (dataHash.containsKey(STORAGEID)) {
                mediaFileMeta.setStorage((String)dataHash.get(STORAGEID));
            }
            if (dataHash.containsKey(FOLDERNAME)) {
                mediaFileMeta.setFolderName((String)dataHash.get(FOLDERNAME));
            }
            if (dataHash.containsKey(ENTITYID)) {
                mediaFileMeta.setEntityID((String)dataHash.get(ENTITYID));
            }
            if (dataHash.containsKey(SOURCEPATH)) {
                mediaFileMeta.setSourcePath((String)dataHash.get(SOURCEPATH));
            }
            if (dataHash.containsKey(DFSFILEPATH)) {
                mediaFileMeta.setDfsFilePath((String)dataHash.get(DFSFILEPATH));
            }
            if (dataHash.containsKey(SIZE)) {
                mediaFileMeta.setSize(Long.parseLong((String)dataHash.get(SIZE)));
            }
            if (dataHash.containsKey(TUUID)) {
                mediaFileMeta.setTuuid((String)dataHash.get(TUUID));
            }
            if (dataHash.containsKey(SCOPEID)) {
                mediaFileMeta.setScopeID((String)dataHash.get(SCOPEID));
            }
            if (dataHash.containsKey(BLOCKID)) {
                mediaFileMeta.setBlockID((String)dataHash.get(BLOCKID));
            }
            if (dataHash.containsKey(ISENCRYPT)) {
                mediaFileMeta.setEncrypt(Boolean.parseBoolean((String)dataHash.get(ISENCRYPT)));
            }
        } else if (storageType.equals("DFS")) {
            if (dataHash.containsKey("STORAGE_SCOPE")) {
                mediaFileMeta.setStorageScope(Integer.parseInt((String)dataHash.get("STORAGE_SCOPE")));
            }
            if (dataHash.containsKey("DFS_COMPRESSION")) {
                mediaFileMeta.setDFSCompression(Boolean.parseBoolean((String)dataHash.get("DFS_COMPRESSION")));
            }
            if (dataHash.containsKey("EAR_COMPRESSION")) {
                mediaFileMeta.setEARCompression(Boolean.parseBoolean((String)dataHash.get("EAR_COMPRESSION")));
            }
            if (dataHash.containsKey("AMSARCHIVE_SERVICENAME")) {
                mediaFileMeta.setServiceName((String)dataHash.get("AMSARCHIVE_SERVICENAME"));
            }
            if (dataHash.containsKey("ORGID")) {
                mediaFileMeta.setOrgId((String)dataHash.get("ORGID"));
            }
            if (dataHash.containsKey("ZUID")) {
                mediaFileMeta.setHostZuid((String)dataHash.get("ZUID"));
            }
            if (dataHash.containsKey("SAVED_DFS_BLOCKID")) {
                mediaFileMeta.setDFSBlockId((String)dataHash.get("SAVED_DFS_BLOCKID"));
            }
            if (dataHash.containsKey("FILE_FORMAT")) {
                mediaFileMeta.setFileFormat((String)dataHash.get("FILE_FORMAT"));
            }
        }
        if (dataHash.containsKey("AMSARCHIVE_FILENAME")) {
            mediaFileMeta.setFilePath((String)dataHash.get("AMSARCHIVE_FILENAME"));
        }
        if (dataHash.containsKey("AMSARCHIVE_FILESIZE")) {
            mediaFileMeta.setFileSize(Long.parseLong((String)dataHash.get("AMSARCHIVE_FILESIZE")));
        }
        if (dataHash.containsKey("AMSARCHIVE_DURATION")) {
            mediaFileMeta.setFileDuration(Long.parseLong((String)dataHash.get("AMSARCHIVE_DURATION")));
        }
        if (dataHash.containsKey("addinfo")) {
            mediaFileMeta.addAdditionalInfo(dataHash.get("addinfo"));
        }
    }

    public static void convert(MediaFileMeta mediaFileMeta, Hashtable dataHash) {
        String storageType = mediaFileMeta.getStorageType();
        if (storageType.equals("WFS")) {
            if (mediaFileMeta.getStorage() != null) {
                dataHash.put(STORAGEID, mediaFileMeta.getStorage());
            }
            if (mediaFileMeta.getFolderName() != null) {
                dataHash.put(FOLDERNAME, mediaFileMeta.getFolderName());
            }
            if (mediaFileMeta.getEntityID() != null) {
                dataHash.put(ENTITYID, mediaFileMeta.getEntityID());
            }
            if (mediaFileMeta.getSourcePath() != null) {
                dataHash.put(SOURCEPATH, mediaFileMeta.getSourcePath());
            }
            if (mediaFileMeta.getDfsFilePath() != null) {
                dataHash.put(DFSFILEPATH, mediaFileMeta.getDfsFilePath());
            }
            if (mediaFileMeta.getTuuid() != null) {
                dataHash.put(TUUID, mediaFileMeta.getTuuid());
            }
            if (mediaFileMeta.getScopeID() != null) {
                dataHash.put(SCOPEID, mediaFileMeta.getScopeID());
            }
            if (mediaFileMeta.getBlockID() != null) {
                dataHash.put(BLOCKID, mediaFileMeta.getBlockID());
            }
            dataHash.put(SIZE, "" + mediaFileMeta.getSize());
            dataHash.put(ISENCRYPT, "" + mediaFileMeta.isEncrypt());
        } else if (storageType.equals("DFS")) {
            if (mediaFileMeta.getServiceName() != null) {
                dataHash.put("AMSARCHIVE_SERVICENAME", mediaFileMeta.getServiceName());
            }
            if (mediaFileMeta.getOrgId() != null) {
                dataHash.put("ORGID", mediaFileMeta.getOrgId());
            }
            if (mediaFileMeta.getHostZuid() != null) {
                dataHash.put("ZUID", mediaFileMeta.getHostZuid());
            }
            if (mediaFileMeta.getDFSBlockId() != null) {
                dataHash.put("SAVED_DFS_BLOCKID", mediaFileMeta.getDFSBlockId());
            }
            if (mediaFileMeta.getFileFormat() != null) {
                dataHash.put("FILE_FORMAT", mediaFileMeta.getFileFormat());
            }
            dataHash.put("STORAGE_SCOPE", "" + mediaFileMeta.getStorageScope());
            dataHash.put("DFS_COMPRESSION", "" + mediaFileMeta.isDFSCompression());
            dataHash.put("EAR_COMPRESSION", "" + mediaFileMeta.isEARCompression());
        }
        if (mediaFileMeta.getFilePath() != null) {
            dataHash.put("AMSARCHIVE_FILENAME", mediaFileMeta.getFilePath());
        }
        if (mediaFileMeta.getAdditionalInfo() != null) {
            dataHash.put("addinfo", mediaFileMeta.getAdditionalInfo());
        }
        dataHash.put("AMSARCHIVE_FILESIZE", "" + mediaFileMeta.getFileSize());
        dataHash.put("AMSARCHIVE_DURATION", "" + mediaFileMeta.getFileDuration());
    }

    public static MediaFileMeta convertToMediaFileMeta(Hashtable dataHash) {
        String storageType = (String)dataHash.get("storage_type");
        MediaFileMeta mediaFileMeta = new MediaFileMeta(storageType);
        MediaUtil.convert(dataHash, mediaFileMeta);
        return mediaFileMeta;
    }

    public static Hashtable convertToHashtable(MediaFileMeta mediaFileMeta) {
        Hashtable<String, String> dataHash = new Hashtable<String, String>();
        dataHash.put("storage_type", mediaFileMeta.getStorageType());
        MediaUtil.convert(mediaFileMeta, dataHash);
        return dataHash;
    }

    public static MediaConverter convertToMediaConverter(Hashtable mediaConverterHash) {
        String conversionid = (String)mediaConverterHash.get(CONVERSIONID);
        String orgid = (String)mediaConverterHash.get(ORGID);
        String servicename = (String)mediaConverterHash.get(SERVICENAME);
        String eartoken = null;
        MediaFormat inputFormat = null;
        MediaFileMeta inputFile = null;
        Hashtable<MediaFormat, MediaFileMeta> outputDetails = null;
        if (mediaConverterHash.containsKey(EARTOKEN)) {
            eartoken = (String)mediaConverterHash.get(EARTOKEN);
        }
        if (mediaConverterHash.containsKey(INPUT_FORMAT)) {
            inputFormat = MediaUtil.parseMediaFormat(mediaConverterHash.get(INPUT_FORMAT));
        }
        if (mediaConverterHash.containsKey(INPUT_FILE)) {
            inputFile = MediaUtil.parseMediaFileMeta(mediaConverterHash.get(INPUT_FILE));
        }
        if (mediaConverterHash.containsKey(OUTPUT_DETAILS)) {
            outputDetails = new Hashtable<MediaFormat, MediaFileMeta>();
            Hashtable outputDetails_str = (Hashtable)mediaConverterHash.get(OUTPUT_DETAILS);
            for (Map.Entry entry : outputDetails_str.entrySet()) {
                MediaFormat outputformat = MediaUtil.parseMediaFormat(HttpDataWraper.getString(entry.getKey()));
                MediaFileMeta outputfile = MediaUtil.parseMediaFileMeta(HttpDataWraper.getString(entry.getValue()));
                outputDetails.put(outputformat, outputfile);
            }
        }
        MediaConverter mediaConverter = new MediaConverter(conversionid, orgid, servicename, eartoken, inputFormat, inputFile, outputDetails);
        return mediaConverter;
    }

    public static MediaRecording parseMediaRecording(Object dataObj) {
        MediaRecording mediarecording = null;
        Hashtable dataHash = null;
        if (dataObj instanceof String) {
            String dataString = (String)dataObj;
            if (HttpDataWraper.getObject(dataString) != null && HttpDataWraper.getObject(dataString) instanceof Hashtable) {
                dataHash = (Hashtable)HttpDataWraper.getObject(dataString);
            }
        } else if (dataObj instanceof Hashtable) {
            dataHash = (Hashtable)dataObj;
        }
        if (dataHash != null) {
            mediarecording = MediaUtil.convertToMediaRecording(dataHash);
        }
        return mediarecording;
    }

    public static List<MediaFormat> parseMediaFormatsList(Object formatsObj) {
        ArrayList<MediaFormat> mediaFormats = null;
        ArrayList mediaFormatsList = null;
        if (formatsObj instanceof String) {
            String mediaFormatsStr = (String)formatsObj;
            if (HttpDataWraper.getObject(mediaFormatsStr) != null && HttpDataWraper.getObject(mediaFormatsStr) instanceof ArrayList) {
                mediaFormatsList = (ArrayList)HttpDataWraper.getObject(mediaFormatsStr);
            }
        } else if (formatsObj instanceof ArrayList) {
            mediaFormatsList = (ArrayList)formatsObj;
        }
        if (mediaFormatsList != null) {
            mediaFormats = new ArrayList<MediaFormat>();
            for (Object format : mediaFormatsList) {
                MediaFormat mediaFormat = MediaUtil.parseMediaFormat(format);
                if (mediaFormat == null) continue;
                mediaFormats.add(mediaFormat);
            }
        }
        return mediaFormats;
    }

    public static MediaFormat parseMediaFormat(Object format) {
        MediaFormat mediaFormat = null;
        Hashtable formatHash = null;
        if (format instanceof String) {
            String formatStr = (String)format;
            if (HttpDataWraper.getObject(formatStr) != null && HttpDataWraper.getObject(formatStr) instanceof Hashtable) {
                formatHash = (Hashtable)HttpDataWraper.getObject(formatStr);
            }
        } else if (format instanceof Hashtable) {
            formatHash = (Hashtable)format;
        } else if (format instanceof MediaFormat) {
            mediaFormat = (MediaFormat)format;
        }
        if (formatHash != null) {
            mediaFormat = MediaUtil.convertToMediaFormat(formatHash);
        }
        return mediaFormat;
    }

    public static Hashtable parseFileDetails(Object fileDetailsObj) {
        Hashtable<MediaFormat, Hashtable> fileDetails = null;
        Hashtable fileDetailsHash = null;
        if (fileDetailsObj instanceof String) {
            String fileDetailsStr = (String)fileDetailsObj;
            if (HttpDataWraper.getObject(fileDetailsStr) != null && HttpDataWraper.getObject(fileDetailsStr) instanceof Hashtable) {
                fileDetailsHash = (Hashtable)HttpDataWraper.getObject(fileDetailsStr);
            }
        } else if (fileDetailsObj instanceof Hashtable) {
            fileDetailsHash = (Hashtable)fileDetailsObj;
        }
        if (fileDetailsHash != null) {
            fileDetails = new Hashtable<MediaFormat, Hashtable>();
            for (Object mediaFormatObj : fileDetailsHash.keySet()) {
                Object storageDetailsObj = fileDetailsHash.get(mediaFormatObj);
                MediaFormat mediaFormat = MediaUtil.parseMediaFormat(mediaFormatObj);
                Hashtable storageDetails = MediaUtil.parseStorageDetails(storageDetailsObj);
                if (mediaFormat == null || storageDetails == null) continue;
                fileDetails.put(mediaFormat, storageDetails);
            }
        }
        return fileDetails;
    }

    public static Hashtable parseStorageDetails(Object storageDetailsObj) {
        Hashtable<String, MediaFileMeta> storageDetails = null;
        Hashtable storageDetailsHash = null;
        if (storageDetailsObj instanceof String) {
            String storageDetailsStr = (String)storageDetailsObj;
            if (HttpDataWraper.getObject(storageDetailsStr) != null && HttpDataWraper.getObject(storageDetailsStr) instanceof Hashtable) {
                storageDetailsHash = (Hashtable)HttpDataWraper.getObject(storageDetailsStr);
            }
        } else if (storageDetailsObj instanceof Hashtable) {
            storageDetailsHash = (Hashtable)storageDetailsObj;
        }
        if (storageDetailsHash != null) {
            storageDetails = new Hashtable<String, MediaFileMeta>();
            for (Object storage_key : storageDetailsHash.keySet()) {
                Object storage_value = storageDetailsHash.get(storage_key);
                MediaFileMeta fileMeta = MediaUtil.parseMediaFileMeta(storage_value);
                if (fileMeta == null) continue;
                storageDetails.put((String)storage_key, fileMeta);
            }
        }
        return storageDetails;
    }

    public static MediaFileMeta parseMediaFileMeta(Object fileMeta) {
        MediaFileMeta mediaFileMeta = null;
        Hashtable fileMetaHash = null;
        if (fileMeta instanceof String) {
            String fileMetaStr = (String)fileMeta;
            if (HttpDataWraper.getObject(fileMetaStr) != null && HttpDataWraper.getObject(fileMetaStr) instanceof Hashtable) {
                fileMetaHash = (Hashtable)HttpDataWraper.getObject(fileMetaStr);
            }
        } else if (fileMeta instanceof Hashtable) {
            fileMetaHash = (Hashtable)fileMeta;
        } else if (fileMeta instanceof MediaFileMeta) {
            mediaFileMeta = (MediaFileMeta)fileMeta;
        }
        if (fileMetaHash != null) {
            mediaFileMeta = MediaUtil.convertToMediaFileMeta(fileMetaHash);
        }
        return mediaFileMeta;
    }

    public static MediaConverter parseMediaConverter(Object mediaConverterObj) {
        MediaConverter mediaConverter = null;
        Hashtable mediaConverterHash = null;
        if (mediaConverterObj instanceof String) {
            String mediaConverterStr = (String)mediaConverterObj;
            if (HttpDataWraper.getObject(mediaConverterStr) != null && HttpDataWraper.getObject(mediaConverterStr) instanceof Hashtable) {
                mediaConverterHash = (Hashtable)HttpDataWraper.getObject(mediaConverterStr);
            }
        } else if (mediaConverterObj instanceof Hashtable) {
            mediaConverterHash = (Hashtable)mediaConverterObj;
        } else if (mediaConverterObj instanceof MediaConverter) {
            mediaConverter = (MediaConverter)mediaConverterObj;
        }
        if (mediaConverterHash != null) {
            mediaConverter = MediaUtil.convertToMediaConverter(mediaConverterHash);
        }
        return mediaConverter;
    }
}

