/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.zvp.recording;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.zvp.recording.MediaFileMeta;
import com.adventnet.wms.common.zvp.recording.MediaFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class MediaRecording {
    private static final String RECORDING_ID = "recording_id";
    private static final String MEDIA_FORMATS = "media_formats";
    private static final String FILE_DETAILS = "file_details";
    private static final String START_TIME = "start_time";
    private static final String END_TIME = "end_time";
    private static final String SERVICENAME = "serviceName";
    private static final String ORGID = "orgId";
    private static final String EARTOKEN = "earToken";
    private Hashtable data = new Hashtable();

    public MediaRecording(String recId) {
        this.data.put(RECORDING_ID, recId);
    }

    public String toString() {
        return HttpDataWraper.getString(this.data);
    }

    public String getRecordingId() {
        return (String)this.data.get(RECORDING_ID);
    }

    public void addFileDetails(Hashtable fileDetails) {
        this.data.put(FILE_DETAILS, fileDetails);
    }

    public void addFileDetail(MediaFormat mediaFormat, MediaFileMeta mediaFileMeta) {
        Hashtable mediadetails = null;
        if (!this.data.containsKey(FILE_DETAILS)) {
            mediadetails = new Hashtable();
            this.data.put(FILE_DETAILS, mediadetails);
        } else {
            mediadetails = (Hashtable)this.data.get(FILE_DETAILS);
        }
        Hashtable storagedetails = null;
        if (!mediadetails.containsKey(mediaFormat)) {
            storagedetails = new Hashtable();
            mediadetails.put(mediaFormat, storagedetails);
        } else {
            storagedetails = (Hashtable)mediadetails.get(mediaFormat);
        }
        mediaFormat.setStorageType(mediaFileMeta.getStorageType());
        storagedetails.put(mediaFileMeta.getStorageType(), mediaFileMeta);
    }

    public Hashtable getFileDetails() {
        return (Hashtable)this.data.get(FILE_DETAILS);
    }

    public Hashtable getFileDetail(MediaFormat mediaFormat) {
        Hashtable filedetails = (Hashtable)this.data.get(FILE_DETAILS);
        return (Hashtable)filedetails.get(mediaFormat);
    }

    public Hashtable getFileDetail(String format) {
        Hashtable storagedetails = null;
        Hashtable filedetails = (Hashtable)this.data.get(FILE_DETAILS);
        for (Object formatObj : filedetails.keySet()) {
            MediaFormat mediaFormat = (MediaFormat)formatObj;
            if (!mediaFormat.getContainer().equals(format)) continue;
            storagedetails = (Hashtable)filedetails.get(formatObj);
            break;
        }
        return storagedetails;
    }

    public void addMediaFormats(List<MediaFormat> mediaFormats) {
        this.data.put(MEDIA_FORMATS, mediaFormats);
    }

    public void addMediaFormat(MediaFormat mediaFormat) {
        List<MediaFormat> mediaFormats = null;
        if (!this.data.containsKey(MEDIA_FORMATS)) {
            mediaFormats = new ArrayList();
            this.data.put(MEDIA_FORMATS, mediaFormats);
        } else {
            mediaFormats = (List)this.data.get(MEDIA_FORMATS);
        }
        mediaFormats.add(mediaFormat);
    }

    public List<MediaFormat> getMediaFormats() {
        return (List)this.data.get(MEDIA_FORMATS);
    }

    public MediaFormat getMediaFormat(String container) {
        Hashtable fileDetails = null;
        MediaFormat mediaFormat = null;
        if (this.data.containsKey(FILE_DETAILS)) {
            fileDetails = (Hashtable)this.data.get(FILE_DETAILS);
            for (Object formatObj : fileDetails.keySet()) {
                MediaFormat format = (MediaFormat)formatObj;
                if (!format.getContainer().equals(container)) continue;
                mediaFormat = format;
                break;
            }
        }
        return mediaFormat;
    }

    public void setStartTime(long starttime) {
        this.data.put(START_TIME, "" + starttime);
    }

    public void setEndTime(long endtime) {
        this.data.put(END_TIME, "" + endtime);
    }

    public void setServiceName(String serviceName) {
        this.data.put(SERVICENAME, serviceName);
    }

    public void setOrgId(String orgId) {
        this.data.put(ORGID, orgId);
    }

    public void setEarToken(String earToken) {
        this.data.put(EARTOKEN, earToken);
    }

    public long getStartTime() {
        return Long.parseLong((String)this.data.get(START_TIME));
    }

    public long getEndTime() {
        return Long.parseLong((String)this.data.get(END_TIME));
    }

    public String getServiceName() {
        return (String)this.data.get(SERVICENAME);
    }

    public String getOrgId() {
        return (String)this.data.get(ORGID);
    }

    public String getEarToken() {
        return (String)this.data.get(EARTOKEN);
    }
}

