/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.zvp.recording;

import com.adventnet.wms.common.HttpDataWraper;
import java.lang.reflect.Field;
import java.util.Hashtable;

public class MediaFormat {
    private static final String CONTAINER = "container";
    private static final String VIDEO_CODEC = "video_codec";
    private static final String AUDIO_CODEC = "audio_codec";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final String VIDEO_BITRATE = "video_bitrate";
    private static final String AUDIO_BITRATE = "audio_bitrate";
    private static final String STORAGE_TYPE = "storage_type";
    private static final int DFS = 1;
    private static final int WFS = 2;
    private Hashtable data = new Hashtable();

    public MediaFormat(String container) {
        this(container, null, null, -1, -1, -1L, -1L);
    }

    public MediaFormat(String container, String video_codec, String audio_codec, int width, int height, long video_bitrate, long audio_bitrate) {
        video_codec = MediaFormat.getVideoCodecForContainer(container, video_codec);
        audio_codec = MediaFormat.getAudioCodecForContainer(container, audio_codec);
        width = MediaFormat.getWidthForCodec(video_codec, width);
        height = MediaFormat.getHeightForCodec(video_codec, height);
        video_bitrate = MediaFormat.getVideoBitrateForCodec(video_codec, video_bitrate);
        audio_bitrate = MediaFormat.getAudioBitrateForCodec(audio_codec, audio_bitrate);
        this.data.put(CONTAINER, container);
        this.data.put(VIDEO_CODEC, video_codec);
        this.data.put(AUDIO_CODEC, audio_codec);
        this.data.put(WIDTH, "" + width);
        this.data.put(HEIGHT, "" + height);
        this.data.put(VIDEO_BITRATE, "" + video_bitrate);
        this.data.put(AUDIO_BITRATE, "" + audio_bitrate);
    }

    public String toString() {
        return HttpDataWraper.getString(this.data);
    }

    public String getContainer() {
        return (String)this.data.get(CONTAINER);
    }

    public String getVideoCodec() {
        return (String)this.data.get(VIDEO_CODEC);
    }

    public void setVideoCodec(String video_codec) {
        this.data.put(VIDEO_CODEC, video_codec);
    }

    public String getAudioCodec() {
        return (String)this.data.get(AUDIO_CODEC);
    }

    public void setAudioCodec(String audio_codec) {
        this.data.put(AUDIO_CODEC, audio_codec);
    }

    public int getWidth() {
        return Integer.parseInt((String)this.data.get(WIDTH));
    }

    public void setWidth(int width) {
        this.data.put(WIDTH, "" + width);
    }

    public int getHeight() {
        return Integer.parseInt((String)this.data.get(HEIGHT));
    }

    public void setHeight(int height) {
        this.data.put(HEIGHT, "" + height);
    }

    public long getVideoBitRate() {
        return Long.parseLong((String)this.data.get(VIDEO_BITRATE));
    }

    public void setVideoBitRate(long video_bitrate) {
        this.data.put(VIDEO_BITRATE, "" + video_bitrate);
    }

    public long getAudioBitRate() {
        return Long.parseLong((String)this.data.get(AUDIO_BITRATE));
    }

    public void setAudioBitRate(long audio_bitrate) {
        this.data.put(AUDIO_BITRATE, "" + audio_bitrate);
    }

    public void setStorageType(String storageType) {
        int storageTypeInt = 0;
        if (this.data.containsKey(STORAGE_TYPE)) {
            storageTypeInt = Integer.parseInt((String)this.data.get(STORAGE_TYPE));
        }
        switch (storageType) {
            case "DFS": {
                ++storageTypeInt;
                break;
            }
            case "WFS": {
                storageTypeInt += 2;
            }
        }
        this.data.put(STORAGE_TYPE, "" + storageTypeInt);
    }

    public void setStorages(int storageTypeInt) {
        this.data.put(STORAGE_TYPE, "" + storageTypeInt);
    }

    public String getStorages() {
        return (String)this.data.get(STORAGE_TYPE);
    }

    public boolean containsStorageType(String storageType) {
        boolean status = false;
        int storageTypeInt = 0;
        if (this.data.containsKey(STORAGE_TYPE)) {
            storageTypeInt = Integer.parseInt((String)this.data.get(STORAGE_TYPE));
        }
        switch (storageType) {
            case "DFS": {
                status = (storageTypeInt & 1) == 1;
                break;
            }
            case "WFS": {
                status = (storageTypeInt & 2) == 2;
            }
        }
        return status;
    }

    private static String getVideoCodecForContainer(String container) {
        String video_codec = "";
        switch (container) {
            case "mp4": {
                video_codec = "H264";
                break;
            }
            case "webm": {
                video_codec = "VP8";
                break;
            }
            case "hlsvod": 
            case "hlsvod_video": {
                video_codec = "H264";
            }
        }
        return video_codec;
    }

    private static String getAudioCodecForContainer(String container) {
        String audio_codec = "";
        switch (container) {
            case "mp4": 
            case "m4a": {
                audio_codec = "AAC";
                break;
            }
            case "webm": {
                audio_codec = "OPUS";
                break;
            }
            case "mp3": {
                audio_codec = "MP3";
                break;
            }
            case "hlsvod": 
            case "hlsvod_audio": {
                audio_codec = "AAC";
            }
        }
        return audio_codec;
    }

    private static String getVideoCodecForContainer(String container, String codec) {
        String video_codec = "";
        if (codec != null) {
            for (Field field : Codec.Video.class.getDeclaredFields()) {
                if (!field.getName().equals(codec)) continue;
                video_codec = codec;
            }
        }
        if (video_codec.length() == 0) {
            video_codec = MediaFormat.getVideoCodecForContainer(container);
        }
        return video_codec;
    }

    private static String getAudioCodecForContainer(String container, String codec) {
        String audio_codec = "";
        if (codec != null) {
            for (Field field : Codec.Audio.class.getDeclaredFields()) {
                if (!field.getName().equals(codec)) continue;
                audio_codec = codec;
            }
        }
        if (audio_codec.length() == 0) {
            audio_codec = MediaFormat.getAudioCodecForContainer(container);
        }
        return audio_codec;
    }

    private static int getWidthForCodec(String video_codec, int width) {
        int video_width = -1;
        if (video_codec.length() > 0) {
            video_width = width > 0 ? width : 1080;
        }
        return video_width;
    }

    private static int getHeightForCodec(String video_codec, int height) {
        int video_height = -1;
        if (video_codec.length() > 0) {
            video_height = height > 0 ? height : 720;
        }
        return video_height;
    }

    private static long getVideoBitrateForCodec(String video_codec, long bitrate) {
        long video_bitrate = -1L;
        if (video_codec.length() > 0) {
            video_bitrate = bitrate > 0L ? bitrate : 500000L;
        }
        return video_bitrate;
    }

    private static long getAudioBitrateForCodec(String audio_codec, long bitrate) {
        long audio_bitrate = -1L;
        if (audio_codec.length() > 0) {
            audio_bitrate = bitrate > 0L ? bitrate : 25000L;
        }
        return audio_bitrate;
    }

    public static class Codec {

        public static class Audio {
            public static final String MP3 = "MP3";
            public static final String AAC = "AAC";
            public static final String OPUS = "OPUS";
        }

        public static class Video {
            public static final String H264 = "H264";
            public static final String VP8 = "VP8";
        }
    }

    public static class Container {
        public static final String HLS_VOD = "hlsvod";

        public static class Audio {
            public static final String MP3 = "mp3";
            public static final String M4A = "m4a";
            public static final String HLS_VOD = "hlsvod_audio";
        }

        public static class Video {
            public static final String MP4 = "mp4";
            public static final String WEBM = "webm";
            public static final String HLS_VOD = "hlsvod_video";
        }
    }
}

