/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.zvp.recording;

import com.adventnet.wms.common.HttpDataWraper;
import java.util.Hashtable;

public class MediaFileMeta {
    private static final String ADDITIONAL_INFO = "addinfo";
    private static final String STORAGE_TYPE = "storage_type";
    private static final String STORAGEID = "storageID";
    private static final String FOLDERNAME = "folderName";
    private static final String ENTITYID = "entityID";
    private static final String SOURCEPATH = "sourcePath";
    private static final String DFSFILEPATH = "dfsFilePath";
    private static final String BLOCKID = "blockID";
    private static final String SIZE = "size";
    private static final String TUUID = "tuuid";
    private static final String SCOPEID = "scopeID";
    private static final String ISENCRYPT = "isEncrypt";
    private Hashtable data = new Hashtable();

    public MediaFileMeta() {
    }

    public MediaFileMeta(String storageType) {
        this.data.put(STORAGE_TYPE, storageType);
    }

    public MediaFileMeta(int storageScope, String filepath) {
        this(storageScope, filepath, false, true);
    }

    public MediaFileMeta(int storageScope, String filepath, boolean dfsCompression, boolean earCompression) {
        this.data.put(STORAGE_TYPE, "DFS");
        this.data.put("STORAGE_SCOPE", "" + storageScope);
        if (filepath != null) {
            this.data.put("AMSARCHIVE_FILENAME", filepath);
        }
        this.data.put("DFS_COMPRESSION", "" + dfsCompression);
        this.data.put("EAR_COMPRESSION", "" + earCompression);
    }

    public MediaFileMeta(int storageScope, String filepath, String dfsBlockId, boolean dfsCompression, boolean earCompression) {
        this(storageScope, filepath, dfsCompression, earCompression);
        this.data.put("SAVED_DFS_BLOCKID", dfsBlockId);
    }

    public MediaFileMeta(String storage, String foldername, String entityid) {
        this(storage, foldername, entityid, null);
    }

    public MediaFileMeta(String storage, String foldername, String entityid, String filename) {
        this.data.put(STORAGE_TYPE, "WFS");
        this.data.put(STORAGEID, storage);
        this.data.put(FOLDERNAME, foldername);
        this.data.put(ENTITYID, entityid);
        if (filename != null) {
            this.data.put("AMSARCHIVE_FILENAME", filename);
        }
    }

    public String toString() {
        return HttpDataWraper.getString(this.data);
    }

    public void addAdditionalInfo(Object additional_info) {
        this.data.put(ADDITIONAL_INFO, additional_info);
    }

    public Object getAdditionalInfo() {
        return this.data.get(ADDITIONAL_INFO);
    }

    public void setStorageType(String storageType) {
        this.data.put(STORAGE_TYPE, storageType);
    }

    public String getStorageType() {
        return (String)this.data.get(STORAGE_TYPE);
    }

    public void setServiceName(String serviceName) {
        this.data.put("AMSARCHIVE_SERVICENAME", serviceName);
    }

    public String getServiceName() {
        return (String)this.data.get("AMSARCHIVE_SERVICENAME");
    }

    public void setOrgId(String orgId) {
        this.data.put("ORGID", orgId);
    }

    public String getOrgId() {
        return (String)this.data.get("ORGID");
    }

    public void setHostZuid(String hostZuid) {
        this.data.put("ZUID", hostZuid);
    }

    public String getHostZuid() {
        return (String)this.data.get("ZUID");
    }

    public void setDFSBlockId(String dfsBlockId) {
        this.data.put("SAVED_DFS_BLOCKID", dfsBlockId);
    }

    public String getDFSBlockId() {
        return (String)this.data.get("SAVED_DFS_BLOCKID");
    }

    public void setStorageScope(int storageScope) {
        this.data.put("STORAGE_SCOPE", "" + storageScope);
    }

    public int getStorageScope() {
        return Integer.parseInt(this.data.containsKey("STORAGE_SCOPE") ? (String)this.data.get("STORAGE_SCOPE") : "" + 2);
    }

    public void setFilePath(String fileName) {
        this.data.put("AMSARCHIVE_FILENAME", fileName);
    }

    public String getFilePath() {
        return (String)this.data.get("AMSARCHIVE_FILENAME");
    }

    public void setDFSCompression(boolean dfsCompression) {
        this.data.put("DFS_COMPRESSION", "" + dfsCompression);
    }

    public boolean isDFSCompression() {
        return Boolean.parseBoolean(this.data.containsKey("DFS_COMPRESSION") ? (String)this.data.get("DFS_COMPRESSION") : "false");
    }

    public void setEARCompression(boolean earCompression) {
        this.data.put("EAR_COMPRESSION", "" + earCompression);
    }

    public boolean isEARCompression() {
        return Boolean.parseBoolean(this.data.containsKey("EAR_COMPRESSION") ? (String)this.data.get("EAR_COMPRESSION") : "false");
    }

    public void setFileSize(long filesize) {
        this.data.put("AMSARCHIVE_FILESIZE", "" + filesize);
    }

    public long getFileSize() {
        return Long.parseLong(this.data.containsKey("AMSARCHIVE_FILESIZE") ? (String)this.data.get("AMSARCHIVE_FILESIZE") : "0");
    }

    public void setFileDuration(long fileduration) {
        this.data.put("AMSARCHIVE_DURATION", "" + fileduration);
    }

    public long getFileDuration() {
        return Long.parseLong(this.data.containsKey("AMSARCHIVE_DURATION") ? (String)this.data.get("AMSARCHIVE_DURATION") : "0");
    }

    public void setFileFormat(String fileformat) {
        this.data.put("FILE_FORMAT", fileformat);
    }

    public String getFileFormat() {
        return (String)this.data.get("FILE_FORMAT");
    }

    public void setStorage(String storageId) {
        this.data.put(STORAGEID, storageId);
    }

    public String getStorage() {
        return (String)this.data.get(STORAGEID);
    }

    public void setFolderName(String folderName) {
        this.data.put(FOLDERNAME, folderName);
    }

    public String getFolderName() {
        return (String)this.data.get(FOLDERNAME);
    }

    public void setEntityID(String entityId) {
        this.data.put(ENTITYID, entityId);
    }

    public String getEntityID() {
        return (String)this.data.get(ENTITYID);
    }

    public void setSourcePath(String sourcePath) {
        this.data.put(SOURCEPATH, sourcePath);
    }

    public String getSourcePath() {
        return (String)this.data.get(SOURCEPATH);
    }

    public void setDfsFilePath(String dfsFilePath) {
        this.data.put(DFSFILEPATH, dfsFilePath);
    }

    public String getDfsFilePath() {
        return (String)this.data.get(DFSFILEPATH);
    }

    public void setTuuid(String tuuid) {
        this.data.put(TUUID, tuuid);
    }

    public String getTuuid() {
        return (String)this.data.get(TUUID);
    }

    public void setScopeID(String scopeId) {
        this.data.put(SCOPEID, scopeId);
    }

    public String getScopeID() {
        return (String)this.data.get(SCOPEID);
    }

    public void setBlockID(String blockId) {
        this.data.put(BLOCKID, blockId);
    }

    public String getBlockID() {
        return (String)this.data.get(BLOCKID);
    }

    public void setSize(long size) {
        this.data.put(SIZE, "" + size);
    }

    public long getSize() {
        return Long.parseLong(this.data.containsKey(SIZE) ? (String)this.data.get(SIZE) : "0");
    }

    public void setEncrypt(boolean encrypt) {
        this.data.put(ISENCRYPT, "" + encrypt);
    }

    public boolean isEncrypt() {
        return Boolean.parseBoolean(this.data.containsKey(ISENCRYPT) ? (String)this.data.get(ISENCRYPT) : "false");
    }
}

