/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.transcript;

import com.adventnet.wms.common.transcript.WMSAddlData;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReactionsAddlData
implements WMSAddlData {
    private static final Logger LOGGER = Logger.getLogger(ReactionsAddlData.class.getName());

    @Override
    public JSONObject performOperation(String operation, JSONObject operationalData, JSONObject data) {
        try {
            if (operations.add.name().equalsIgnoreCase(operation)) {
                data = this.addOperation(data, operationalData);
            } else if (operations.delete.name().equalsIgnoreCase(operation)) {
                data = this.deleteOperation(data, operationalData);
            } else {
                LOGGER.info("Un allowed operation " + operation);
            }
        }
        catch (JSONException jsone) {
            LOGGER.log(Level.SEVERE, "Error while performOperation ", jsone);
        }
        return data;
    }

    private int getUserIndex(JSONArray al, String userZuid) throws JSONException {
        int size = al.length();
        for (int i = 0; i < size; ++i) {
            String dat = (String)al.get(i);
            if (dat.indexOf(":" + userZuid + ":") == -1) continue;
            return i;
        }
        return -1;
    }

    private JSONObject addOperation(JSONObject data, JSONObject operationalData) throws JSONException {
        if (data == null || data.length() == 0) {
            data = new JSONObject();
        }
        Iterator iteratorObj = operationalData.keys();
        while (iteratorObj.hasNext()) {
            JSONArray usersReacted;
            String reactionKey = (String)iteratorObj.next();
            String currentReactionValue = (String)operationalData.get(reactionKey);
            if (data.has(reactionKey)) {
                usersReacted = (JSONArray)data.get(reactionKey);
                if (this.getUserIndex(usersReacted, currentReactionValue.split(":")[1]) != -1) continue;
                usersReacted.put((Object)currentReactionValue);
                data.put(reactionKey, (Object)usersReacted);
                continue;
            }
            usersReacted = new JSONArray();
            usersReacted.put((Object)currentReactionValue);
            data.put(reactionKey, (Object)usersReacted);
        }
        return data;
    }

    private JSONObject deleteOperation(JSONObject data, JSONObject operationalData) throws JSONException {
        if (data.length() == 0) {
            return data;
        }
        Iterator iteratorObj = operationalData.keys();
        while (iteratorObj.hasNext()) {
            JSONArray usersReacted;
            int userReactedIndex;
            String key = (String)iteratorObj.next();
            String userZuid = (String)operationalData.get(key);
            if (!data.has(key) || (userReactedIndex = this.getUserIndex(usersReacted = (JSONArray)data.get(key), userZuid)) == -1) continue;
            if ((usersReacted = this.removeReaction(usersReacted, userReactedIndex)).length() == 0) {
                data.remove(key);
                continue;
            }
            data.put(key, (Object)usersReacted);
        }
        return data;
    }

    private JSONArray removeReaction(JSONArray usersReacted, int indexPos) throws JSONException {
        JSONArray dat = new JSONArray();
        int len = usersReacted.length();
        for (int i = 0; i < len; ++i) {
            if (i == indexPos) continue;
            dat.put(usersReacted.get(i));
        }
        return dat;
    }

    @Override
    public int getAllocatedSize() {
        return 2048;
    }

    private static enum operations {
        add,
        delete;

    }
}

