/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.stats.influx;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.common.stats.influx.LBQWithoutDuplicates;
import com.adventnet.wms.common.stats.influx.StatsDB;
import com.adventnet.wms.common.stats.influx.StatsDBQueue;
import com.adventnet.wms.common.stats.influx.conf.StatsConf;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.util.Hashtable;

class StatsDispatcher
extends Thread {
    private final String statType;
    private final Hashtable<String, StatsDBQueue> statsDBQueueMap = new Hashtable();
    private final LBQWithoutDuplicates<StatsDBQueue> lbqwd = new LBQWithoutDuplicates();
    private static Hashtable<String, Long> connectionTimeoutMap = new Hashtable();

    public StatsDispatcher(String statType) {
        this.setName("StatsDispatcher_" + statType);
        this.statType = statType;
    }

    protected void add(String db, String rp, byte[] data) {
        String key = db;
        if (rp != null && !rp.isEmpty()) {
            key = db + "_" + rp;
        }
        try {
            StatsDBQueue queue = this.statsDBQueueMap.get(key);
            if (queue == null) {
                queue = new StatsDBQueue(key, db, rp);
                this.statsDBQueueMap.put(key, queue);
            }
            this.lbqwd.add(queue);
            queue.add(data);
            queue.add("\n".getBytes());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void run() {
        int streamSize = 32768;
        while (true) {
            String wnet = null;
            try {
                StatsDBQueue sq;
                wnet = this.getIpFromSeedList();
                if (CommonUtil.isEmpty(wnet) || (sq = this.lbqwd.take()).size() <= 0 || CommonUtil.isEmpty(wnet) || wnet.split(":").length != 2) continue;
                byte[] data = sq.remove();
                HttpConnection con = new HttpConnection("http://" + wnet + "/api/stats", 60000, 5000);
                con.addHeader("x-streammode", "1");
                con.addHeader("stattype", this.statType);
                con.addHeader("database", sq.database());
                con.addHeader("rp", sq.rp());
                ByteArrayInputStream is = new ByteArrayInputStream(data);
                HttpURLConnection urlConn = (HttpURLConnection)con.getConnection();
                OutputStream os = urlConn.getOutputStream();
                try {
                    StatsDispatcher.streamData(is, os, streamSize);
                    int responseCode = urlConn.getResponseCode();
                    if (responseCode == 200) continue;
                    StatsDB.addData("statsdberror", sq.key(), responseCode, StatsDB.getPrd(), "influx_http_error", 1);
                }
                catch (Exception exception) {}
                continue;
            }
            catch (Exception e) {
                connectionTimeoutMap.put(wnet, System.currentTimeMillis() + 120000L);
                continue;
            }
            break;
        }
    }

    private String getIpFromSeedList() {
        String wnet = StatsConf.getServer();
        if (connectionTimeoutMap.containsKey(wnet)) {
            if (connectionTimeoutMap.get(wnet) < System.currentTimeMillis()) {
                connectionTimeoutMap.remove(wnet);
                return wnet;
            }
            if (connectionTimeoutMap.size() == StatsConf.getSeedList().size()) {
                for (String ipList : connectionTimeoutMap.keySet()) {
                    if (connectionTimeoutMap.get(ipList) >= System.currentTimeMillis()) continue;
                    connectionTimeoutMap.remove(ipList);
                    return ipList;
                }
                return StatsConf.getServer();
            }
            return this.getIpFromSeedList();
        }
        return wnet;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void streamData(InputStream is, OutputStream os, int streamSize) throws Exception {
        if (is == null || os == null) {
            throw new NullPointerException();
        }
        if (streamSize < 1) {
            throw new Exception("invalid streamSize");
        }
        byte[] buffer = new byte[streamSize];
        try {
            int length;
            while ((length = is.read(buffer)) > -1) {
                os.write(buffer, 0, length);
                os.flush();
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
            try {
                os.close();
            }
            catch (Exception exception) {}
        }
    }
}

