/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.stats.influx;

import com.adventnet.wms.common.components.constants.ComponentConstants;
import com.adventnet.wms.common.stats.influx.StatRecord;
import com.adventnet.wms.common.stats.influx.StatsByteArrayUploader;
import com.adventnet.wms.common.stats.influx.StatsCollector;
import com.adventnet.wms.common.stats.influx.conf.StatsConf;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class StatsDB {
    private static final Logger LOGGER = Logger.getLogger(StatsDB.class.getName());
    private static String prd;
    private static boolean initialized;
    private static final Hashtable<String, StatRecord> STAT_MAP;
    public static final String STATS_ERROR = "stats_error";
    public static final String INFLUX_ERROR = "influx_http_error";

    public static boolean initialize() {
        return StatsDB.initialize("Unknown");
    }

    public static boolean initialize(String prd) {
        StatsDB.prd = prd;
        StatsConf.initErrorMonitoring();
        try {
            ConcurrentHashMap<String, String> statsDefs = StatsConf.getStatDefs();
            Enumeration<String> enuKey = statsDefs.keys();
            while (enuKey.hasMoreElements()) {
                String statKey = enuKey.nextElement();
                try {
                    String statDef = statsDefs.get(statKey);
                    StatRecord stat = new StatRecord(statKey, statDef);
                    STAT_MAP.put(statKey, stat);
                }
                catch (Exception e) {
                    StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_MALFORMED.getErrorCode(), 1L);
                    StatsDB.addData("statsdberror", statKey, "StatsKey_NotInitialized", StatsDB.getPrd(), STATS_ERROR, 1);
                }
            }
            ArrayList seedList = (ArrayList)StatsConf.getSeedList();
            if (seedList == null || seedList.isEmpty()) {
                LOGGER.severe("PS-> Seed List is not initialised");
                initialized = false;
                return false;
            }
            if (initialized) {
                return true;
            }
            new Thread(new StatsCollector()).start();
            new Thread(new StatsByteArrayUploader()).start();
            initialized = true;
        }
        catch (Exception e) {
            LOGGER.log(Level.INFO, "PS --> Cannot initialised StatsDB", e);
        }
        return initialized;
    }

    public static void addData(Object ... values) {
        if (!initialized) {
            return;
        }
        String statKey = "" + values[0];
        StatRecord record = STAT_MAP.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", StatsDB.getPrd(), STATS_ERROR, 1);
            return;
        }
        if (record.isRangeData()) {
            record.addRangeData(values);
        } else if (record.isInstantDispatch()) {
            record.dispatchData(System.currentTimeMillis(), values);
        } else if (record.isSampleTimeAvailable()) {
            values = StatsDB.addPos(values, System.currentTimeMillis() / record.getSampleTimeInMills());
            record.addData(values);
        } else {
            record.addData(values);
        }
    }

    public static void addDataInstant(long timems, Object ... values) {
        if (!initialized) {
            return;
        }
        String statKey = "" + values[0];
        StatRecord record = STAT_MAP.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", StatsDB.getPrd(), STATS_ERROR, 1);
            return;
        }
        if (record.isInstantDispatch()) {
            record.dispatchData(timems, values);
        } else {
            StatsDB.addData("statsdberror", values[0], "statKey_not_instant_dispatch", StatsDB.getPrd(), STATS_ERROR, 1);
        }
    }

    public static void updateDataInstantly(long timems, Object ... values) {
        if (!initialized) {
            return;
        }
        String statKey = "" + values[0];
        StatRecord record = STAT_MAP.get(statKey);
        if (record == null) {
            StatsDB.recordError(ComponentConstants.StatsDB.getModuleCode(), ComponentConstants.StatsDB.STATRECORD_NOT_INITIALIZED.getErrorCode(), 1L);
            StatsDB.addData("statsdberror", values[0], "statKey_not_defined", StatsDB.getPrd(), STATS_ERROR, 1);
            return;
        }
        record.dispatchUpdatedData(timems, values);
    }

    private static Object[] addPos(Object[] src, long num) {
        Object[] temp = new Object[src.length + 1];
        System.arraycopy(src, 0, temp, 0, 1);
        System.arraycopy(src, 1, temp, 2, src.length - 1);
        temp[1] = num;
        return temp;
    }

    protected static Hashtable getStatsMap() {
        return STAT_MAP;
    }

    public static ArrayList<String> getStatKeys() {
        return new ArrayList<String>(STAT_MAP.keySet());
    }

    public static ConcurrentHashMap getStats(String statkey) {
        return STAT_MAP.get(statkey).getStats();
    }

    public static boolean isInitialized() {
        return initialized;
    }

    public static String getPrd() {
        return prd;
    }

    public static void recordError(int moduleCode, int errorCode, long count) {
        StatsDB.recordFailure(moduleCode, count);
        StatsDB.addData("moduleerror", moduleCode, errorCode, count);
    }

    private static void recordFailure(int moduleCode, long count) {
        StatsDB.addData("modulefailure", StatsDB.getPrd(), moduleCode, count);
    }

    static {
        initialized = false;
        STAT_MAP = new Hashtable();
    }
}

