/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.pns;

import com.adventnet.wms.common.pns.PushNotificationHandler;
import java.util.Hashtable;

public class CTPushNotificationHandler
implements PushNotificationHandler {
    @Override
    public Hashtable<String, Boolean> isEligible(String wmsid, long mask, Hashtable msg) {
        int type = CTPushNotificationHandler.getType(wmsid, msg);
        Hashtable<String, Boolean> resp = new Hashtable<String, Boolean>();
        resp.put("PNSEligible", CTPushNotificationHandler.isAllowed(mask, type));
        resp.put("UnreadEligible", CTPushNotificationHandler.isUnreadEligible(mask, type));
        return resp;
    }

    private static boolean isUnreadEligible(long permission, int action) {
        return action == Notifications.MT.getValue() ? CTPushNotificationHandler.isAllowed(permission, action) : true;
    }

    private static boolean isAllowed(long permission, int action) {
        return permission == -1L || action == 0 || (permission & (long)(1 << action)) != 0L;
    }

    private static Hashtable<String, String> parseAddinfoString(String addinfo) {
        String[] data = addinfo.split(":");
        Hashtable<String, String> addInfo = new Hashtable<String, String>();
        for (int i = 0; i < data.length / 2; ++i) {
            String key = data[i * 2];
            addInfo.put(key, data[i * 2 + 1]);
        }
        return addInfo;
    }

    private static int getType(String zuid, Hashtable msg) {
        Hashtable mentionsdetails;
        Hashtable meta;
        boolean isMentions = Boolean.parseBoolean(String.valueOf(msg.get("mentions")));
        if (isMentions && (meta = (Hashtable)msg.get("meta")) != null && (mentionsdetails = (Hashtable)meta.get("mentions")) != null && mentionsdetails.containsKey(zuid)) {
            return Notifications.AT_MENTIONS.getValue();
        }
        int ctype = Integer.parseInt((String)msg.get("ctype"));
        if (ctype == 1 || ctype == 10) {
            if (ctype == 10) {
                String product_id;
                String entityid = null;
                if (msg.containsKey("entityid")) {
                    entityid = (String)msg.get("entityid");
                } else {
                    String addinfo = (String)msg.get("addinfo");
                    if (addinfo != null) {
                        entityid = CTPushNotificationHandler.parseAddinfoString(addinfo).get("ENTITYID");
                    }
                }
                if (entityid != null && "MT".equals(product_id = entityid.split("[.]")[0])) {
                    return Notifications.MT.getValue();
                }
            }
            int pcount = Integer.parseInt((String)msg.get("pcount"));
            boolean customgroup = Boolean.parseBoolean(String.valueOf(msg.get("customgroup")));
            String title = (String)msg.get("title");
            if (pcount == 2 && !customgroup && (title == null || title.isEmpty())) {
                return Notifications.DIRECT_MESSAGE.getValue();
            }
            return Notifications.GROUP.getValue();
        }
        if (ctype == 8 || ctype == 11) {
            return Notifications.CHANNEL.getValue();
        }
        if (ctype == 9) {
            return Notifications.BOT.getValue();
        }
        return 0;
    }

    public static enum Notifications {
        DIRECT_MESSAGE("1"),
        AT_MENTIONS("2"),
        GROUP("3"),
        CHANNEL("4"),
        BOT("5"),
        MT("6");

        private String value;

        private Notifications(String value) {
            this.value = value;
        }

        public int getValue() {
            return Integer.parseInt(this.value);
        }
    }
}

