/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio.tcp;

import com.adventnet.wms.common.nio.tcp.TCPSSLTrustManager;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class TCPSSLManager {
    private static Hashtable<String, SSLContext> sslClientCntxMap = new Hashtable();

    public static void initializeClientManager(ArrayList domains) throws Exception {
        SSLContext sslClientCntx;
        String domain2;
        for (String domain2 : domains) {
            sslClientCntx = SSLContext.getInstance("TLS");
            sslClientCntx.init(null, new TrustManager[]{new TCPSSLTrustManager(domain2)}, null);
            sslClientCntxMap.put(domain2, sslClientCntx);
        }
        domain2 = "default";
        sslClientCntx = SSLContext.getInstance("TLS");
        sslClientCntx.init(null, new TrustManager[]{new TCPSSLTrustManager(domain2)}, null);
        sslClientCntxMap.put(domain2, sslClientCntx);
    }

    public static SSLContext getSSLClientContext(String indomain) {
        return TCPSSLManager.getSSLClientContext(indomain, false, false);
    }

    public static SSLContext getSSLClientContext(String indomain, boolean ignorecertificatevalidation, boolean ignorechainverification) {
        try {
            if (!ignorecertificatevalidation && !ignorechainverification && sslClientCntxMap.get(indomain) != null) {
                return sslClientCntxMap.get(indomain);
            }
            SSLContext sslClientCntx = SSLContext.getInstance("TLS");
            if (!ignorecertificatevalidation && !ignorechainverification) {
                sslClientCntx.init(null, new TrustManager[]{new TCPSSLTrustManager(indomain)}, null);
                sslClientCntxMap.put(indomain, sslClientCntx);
            } else {
                TCPSSLTrustManager manager = new TCPSSLTrustManager(indomain);
                if (ignorecertificatevalidation) {
                    manager.ignoreCertificateValidation();
                }
                if (ignorechainverification) {
                    manager.ignoreChainVerification();
                }
                sslClientCntx.init(null, new TrustManager[]{manager}, null);
            }
            return sslClientCntx;
        }
        catch (Exception ex) {
            return sslClientCntxMap.get("default");
        }
    }
}

