/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio.tcp;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.common.exception.WMSSSLCertificateException;
import com.adventnet.wms.common.nio.tcp.NioSelector;
import com.adventnet.wms.common.nio.tcp.TCPSSLWrapper;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import javax.net.ssl.SSLContext;

public abstract class PacketAssembler {
    private static Logger logger = Logger.getLogger(PacketAssembler.class.getName());
    private SocketChannel sc;
    private TCPSSLWrapper ssl;
    private SSLContext sslCntx;
    private int connectionType;
    private boolean hsdone = false;
    private int zeroReadCount = 0;
    private int maxZeroReadCount = 100;
    private SelectionKey key = null;
    private int connectretrycount = 0;
    private int connectretryMaxCount = 10;
    private NioSelector selector = null;
    private Object niolock = new Object();
    private boolean hsstarted = false;
    private int writebuffersize = 8192;
    private int readbuffersize = 8192;
    private int maxwritebuffersize = 40960;
    private boolean highpriority = false;
    private ByteBuffer writeBB = ByteBuffer.allocate(this.writebuffersize);
    private ArrayList<String> sslversions = new ArrayList();
    private ArrayList<String> ciphersuites = new ArrayList();
    private ArrayList<String> ignoredsslversions = new ArrayList();
    private ArrayList<String> ignoredciphersuites = new ArrayList();
    private boolean ignorecertificatevalidation = false;
    private boolean ignorechainverification = false;
    private long initConnectTime;

    public void setSSLVersions(String versions) {
        if (versions != null) {
            this.sslversions.addAll(CommonUtil.getList(versions));
        }
    }

    public void setCipherSuites(String suites) {
        if (suites != null) {
            this.ciphersuites.addAll(CommonUtil.getList(suites));
        }
    }

    public void setIgnoredSSLVersions(String versions) {
        if (versions != null) {
            this.ignoredsslversions.addAll(CommonUtil.getList(versions));
        }
    }

    public void setIgnoredCipherSuites(String suites) {
        if (suites != null) {
            this.ignoredciphersuites.addAll(CommonUtil.getList(suites));
        }
    }

    public void ignoreCertificateValidation() {
        this.ignorecertificatevalidation = true;
    }

    public void ignoreChainVerification() {
        this.ignorechainverification = true;
    }

    public void setConnectionType(int connectionType) {
        this.connectionType = connectionType;
    }

    public void setSelector(NioSelector selector) {
        this.selector = selector;
    }

    public void setSSLContext(SSLContext sslCntx) {
        this.sslCntx = sslCntx;
    }

    public void setHighPriority() {
        this.highpriority = true;
    }

    public void setSocketChannel(SocketChannel sc) {
        this.sc = sc;
        this.initConnectTime = System.currentTimeMillis();
        try {
            if (this.isSSL()) {
                this.ssl = new TCPSSLWrapper(sc, this.sslCntx, this.sslversions, this.ciphersuites, this.ignoredsslversions, this.ignoredciphersuites);
                this.ssl.setWriteBufferSize(this.writebuffersize, this.maxwritebuffersize);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void switchTLS() {
        try {
            this.ssl = new TCPSSLWrapper(this.sc, this.sslCntx, this.sslversions, this.ciphersuites, this.ignoredsslversions, this.ignoredciphersuites);
            this.ssl.setWriteBufferSize(this.writebuffersize, this.maxwritebuffersize);
            this.hsstarted = true;
            this.setInterestOps(5);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void switchTLS(SSLContext sslcontxt) {
        this.sslCntx = sslcontxt;
        this.switchTLS();
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
    }

    public void setInterestOps(int ops) {
        this.key.interestOps(ops);
    }

    public void setWriteModeForKey() {
        this.selector.setWriteModeForKey(this.sc);
    }

    public SocketChannel getSocketChannel() {
        return this.sc;
    }

    public Object getLockObject() {
        return this.niolock;
    }

    public boolean isSSL() {
        return this.connectionType == 2;
    }

    public boolean isTLS() {
        return this.connectionType == 1;
    }

    public boolean isPlain() {
        return this.connectionType == 0;
    }

    public void setHSDone() {
        this.hsdone = true;
    }

    public boolean isHSDone() {
        return this.hsdone;
    }

    public boolean isHSStarted() {
        return this.hsstarted;
    }

    public int getInterestOps() {
        try {
            if (this.ssl != null) {
                return this.ssl.getInterestOps();
            }
            return this.key.interestOps();
        }
        catch (Exception ex) {
            return -1;
        }
    }

    public void setWriteBufferSize(int size, int maxsize) {
        this.writebuffersize = size;
        this.maxwritebuffersize = maxsize;
    }

    public void setReadBufferSize(int size) {
        this.readbuffersize = size;
    }

    public List<Throwable> getThrowableList(Exception e) {
        ArrayList<Throwable> tList = new ArrayList<Throwable>();
        try {
            for (Throwable cause = e.getCause(); cause != null && !tList.contains(cause); cause = cause.getCause()) {
                tList.add(cause);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return tList;
    }

    public boolean doHandshake() throws Exception {
        return this.doHandshake(this.key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean doHandshake(SelectionKey key) throws Exception {
        if (this.connectionType == 0) {
            return true;
        }
        this.hsstarted = true;
        Object object = this.niolock;
        synchronized (object) {
            try {
                this.hsdone = this.ssl.doHandshake(key);
                return this.hsdone;
            }
            catch (IOException e) {
                List<Throwable> throwables = this.getThrowableList(e);
                for (int traceCount = 0; traceCount < throwables.size(); ++traceCount) {
                    try {
                        Throwable t = throwables.get(traceCount);
                        if (!(t instanceof WMSSSLCertificateException)) continue;
                        WMSSSLCertificateException excep = (WMSSSLCertificateException)t;
                        this.onSSLExceptions(excep.getErrorCode(), excep.getErrorMsg());
                        this.close();
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readData(SelectionKey key) throws Exception {
        Object object = this.niolock;
        synchronized (object) {
            ByteBuffer byteBuffer = ByteBuffer.allocate(this.readbuffersize);
            int count = -1;
            if (this.isSSL() || this.isTLS() && (this.hsstarted || this.hsdone)) {
                if (this.ssl.doHandshake(key)) {
                    this.hsdone = true;
                    count = this.ssl.read();
                    if (count > 0) {
                        this.zeroReadCount = 0;
                        byteBuffer = this.ssl.getDataBuffer();
                        byteBuffer.flip();
                    }
                }
            } else {
                count = ((SocketChannel)key.channel()).read(byteBuffer);
                byteBuffer.flip();
            }
            if (count > 0) {
                byte[] arr = new byte[count];
                byteBuffer.get(arr, 0, arr.length);
                this.onData(arr);
                byteBuffer.clear();
            } else {
                if (count < 0) {
                    throw new WMSException("Key Read Count < 0");
                }
                if (count == 0) {
                    ++this.zeroReadCount;
                    if (this.zeroReadCount > this.maxZeroReadCount) {
                        throw new WMSException("Key Read Count = 0 : Max Crossed");
                    }
                }
            }
            byteBuffer.clear();
            byteBuffer = null;
            key.interestOps(1);
        }
    }

    public void writeData(ByteBuffer bb) throws Exception {
        this.writeData(new ByteBuffer[]{bb});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeData(ByteBuffer[] buffers) throws Exception {
        Object object = this.niolock;
        synchronized (object) {
            if (this.isSSL() || this.isTLS() && (this.hsstarted || this.hsdone)) {
                this.ssl.writeData(buffers);
                this.key.interestOps(4);
                return;
            }
            for (int i = 0; i < buffers.length; ++i) {
                ByteBuffer src = buffers[i];
                if (this.writeBB.position() == 0 && src.capacity() <= this.maxwritebuffersize) {
                    ByteBuffer bb = ByteBuffer.allocate(src.capacity());
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                    this.key.interestOps(4);
                    return;
                }
                if (this.writeBB.capacity() - this.writeBB.position() > src.capacity()) {
                    this.writeBB.put(src);
                } else if (src.capacity() + this.writeBB.position() < this.writebuffersize) {
                    ByteBuffer bb = ByteBuffer.allocate(this.writebuffersize);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                } else if (src.capacity() + this.writeBB.position() > this.writeBB.capacity() * 2) {
                    if (src.capacity() + this.writeBB.position() >= this.maxwritebuffersize) throw new IOException("Exceeded max allowed size " + (src.capacity() + this.writeBB.position()) + " Allowed " + this.maxwritebuffersize);
                    int en_size = src.capacity() + this.writeBB.position();
                    ByteBuffer bb = ByteBuffer.allocate(en_size);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                } else {
                    ByteBuffer bb = ByteBuffer.allocate(this.writeBB.capacity() * 2);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                }
                this.key.interestOps(4);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleWrite(SelectionKey key) throws IOException, CancelledKeyException {
        if (this.key == null) {
            this.key = key;
        }
        Object object = this.niolock;
        synchronized (object) {
            try {
                if (this.isSSL() || this.isTLS() && (this.hsdone || this.hsstarted)) {
                    this.ssl.handleWrite(key);
                    return;
                }
                this.writeBB.flip();
                SocketChannel sk = (SocketChannel)key.channel();
                boolean proceed = true;
                while (proceed) {
                    int written = sk.write(this.writeBB);
                    if (written <= 0) {
                        proceed = false;
                        continue;
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception ex) {
                        logger.fine(this + " Exception in sleep during write " + ex.getMessage());
                    }
                }
                this.writeBB.compact();
                if (this.writeBB.position() > 0) {
                    this.key.interestOps(4);
                } else {
                    this.key.interestOps(1);
                }
            }
            catch (CancelledKeyException cex) {
                throw cex;
            }
            catch (IOException ex) {
                throw ex;
            }
        }
    }

    protected void incrementConnectRetry() {
        ++this.connectretrycount;
    }

    public void setConnectRetryMaxCount(int maxcount) {
        this.connectretryMaxCount = maxcount;
    }

    public int getConnectRetryCount() {
        return this.connectretrycount;
    }

    public long getInitConnectTime() {
        return this.initConnectTime;
    }

    protected boolean isConnectRetryLimitExceeded() {
        return this.connectretrycount > this.connectretryMaxCount;
    }

    protected boolean isHighPriority() {
        return this.highpriority;
    }

    public void close() {
        try {
            if (this.sc != null) {
                this.sc.close();
                this.sc = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (this.ssl != null) {
                this.ssl.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.key != null) {
            try {
                this.key.channel().close();
                this.key.cancel();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.writeBB = null;
        this.onClose();
    }

    public abstract void onConnect();

    public abstract void onConnectFailure(long var1);

    public abstract void onDisconnect(int var1);

    public abstract void onHandshake();

    public abstract void onData(byte[] var1);

    public abstract void onClose();

    public boolean isValid() {
        return true;
    }

    public void onSSLExceptions(int code, String msg) {
    }
}

