/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio.tcp;

import com.adventnet.wms.common.exception.WMSException;
import com.adventnet.wms.common.nio.tcp.NioSelector;
import com.adventnet.wms.common.nio.tcp.PacketAssembler;

public class NioSelectorFactory {
    private static NioSelector[] selectors = null;
    private static int maxselectors = 0;
    private static int scnt = 0;
    private static int selecttimeout = 100;

    public static boolean initialize(int maxselectors) {
        return NioSelectorFactory.initialize(maxselectors, selecttimeout);
    }

    public static boolean initialize(int maxselectors, int selecttimeout) {
        try {
            selectors = new NioSelector[maxselectors];
            for (int i = 0; i < selectors.length; ++i) {
                NioSelector sel = new NioSelector(selecttimeout);
                sel.start();
                NioSelectorFactory.selectors[i] = sel;
            }
            return true;
        }
        catch (Exception ex) {
            return false;
        }
    }

    public static void connect(String host, int port, PacketAssembler pasm) throws WMSException {
        NioSelectorFactory.connect(host, port, pasm, -1);
    }

    public static void connect(String host, int port, PacketAssembler pasm, int sendbuffersize) throws WMSException {
        try {
            NioSelector sel = NioSelectorFactory.getSelector();
            pasm.setSelector(sel);
            sel.connect(host, port, pasm, sendbuffersize);
        }
        catch (Exception e) {
            throw new WMSException("Exception while trying to connect to host " + host);
        }
    }

    private static NioSelector getSelector() {
        try {
            NioSelector selector = selectors[scnt++];
            scnt %= maxselectors;
            return selector;
        }
        catch (Exception ex) {
            NioSelector selector = selectors[0];
            scnt = 0;
            return selector;
        }
    }
}

