/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.nio.SSLTrustManager;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;

public class SSLManager {
    private static Hashtable<String, SSLContext> sslClientCntxMap = new Hashtable();
    private static ArrayList ignoreSSLVerDomains = new ArrayList();
    private static ArrayList sslVersionIgnoreList = new ArrayList();
    private static ArrayList validdomains = new ArrayList();

    public static void initializeClientManager() throws Exception {
        SSLContext sslClientCntx;
        String domain2;
        ArrayList domains = SSLManager.getExternalDomains();
        for (String domain2 : domains) {
            sslClientCntx = SSLContext.getInstance("TLS");
            sslClientCntx.init(null, new TrustManager[]{new SSLTrustManager(domain2)}, null);
            sslClientCntx.getClientSessionContext().setSessionCacheSize(1);
            sslClientCntxMap.put(domain2, sslClientCntx);
        }
        domain2 = "default";
        sslClientCntx = SSLContext.getInstance("TLS");
        sslClientCntx.init(null, new TrustManager[]{new SSLTrustManager(domain2)}, null);
        sslClientCntx.getClientSessionContext().setSessionCacheSize(1);
        if (!sslClientCntxMap.containsKey(domain2)) {
            sslClientCntxMap.put(domain2, sslClientCntx);
        }
    }

    public static void addToIgnoreSSLVerDomainList(ArrayList domainList) {
        if (domainList != null && domainList.size() > 0) {
            ignoreSSLVerDomains.addAll(domainList);
        }
    }

    public static void addToIgnoreSSLVerDomainList(String domainList) {
        if (domainList != null && !ignoreSSLVerDomains.contains(domainList)) {
            ignoreSSLVerDomains.add(domainList);
        }
    }

    public static void addSSLVersionIgnoreList(ArrayList sslverignoreList) {
        if (sslverignoreList != null && sslverignoreList.size() > 0) {
            sslVersionIgnoreList.addAll(sslverignoreList);
        }
    }

    public static void initializeClientManager(String provider, String setup, String domain, String keystorefile, String keystoretype, String password) throws Exception {
        SSLManager.initializeClientManager(provider, setup, domain, new FileInputStream(keystorefile), keystoretype, password);
    }

    public static void initializeClientManager(String provider, String setup, String domain, InputStream keystorestream, String keystoretype, String password) throws Exception {
        KeyStore km = KeyStore.getInstance(keystoretype);
        km.load(keystorestream, password.toCharArray());
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("sunx509");
        kmf.init(km, password.toCharArray());
        SSLContext sslClientCntx = SSLContext.getInstance("TLS");
        sslClientCntx.init(kmf.getKeyManagers(), new TrustManager[]{new SSLTrustManager(domain)}, null);
        sslClientCntxMap.put(domain + "_" + provider + "_" + setup, sslClientCntx);
    }

    public static SSLContext getSSLClientContext(String indomain) {
        if (sslClientCntxMap.get(indomain) != null) {
            return sslClientCntxMap.get(indomain);
        }
        return sslClientCntxMap.get("default");
    }

    public static void setJREHome(String path) {
        System.setProperty("jre.home", path);
    }

    public static void setValidDomains(String domains) {
        validdomains = CommonUtil.getList(domains);
    }

    public static ArrayList getExternalDomains() {
        return validdomains;
    }

    public static boolean ignoreSSLVersion(String host) {
        return ignoreSSLVerDomains.contains(host);
    }

    public static ArrayList getSSLVersionIgnoreList() {
        return sslVersionIgnoreList;
    }
}

