/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.nio;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.zip.GZIPInputStream;

public class HttpResponse {
    private HashMap responseHeaders = new HashMap();
    private String body;
    private boolean chunked = false;
    private ConcurrentLinkedQueue responseChunkQueue = null;
    private int responsecode;
    private String responsemessage;
    private int chunkCounter;
    private int MAX_CHUNK_COUNT = 25;
    private boolean websocket = false;

    protected void setResponseChunkQueueLimit(int limit) {
        this.MAX_CHUNK_COUNT = limit;
    }

    protected void setResponseCode(String responsecode) {
        this.responsecode = Integer.parseInt(responsecode);
    }

    public int getResponseCode() {
        return this.responsecode;
    }

    protected void setResponseMessage(String responsemessage) {
        this.responsemessage = responsemessage;
    }

    protected void addHeader(String key, String value) {
        this.responseHeaders.put(key, value);
        if (key.trim().toLowerCase().equals("transfer-encoding") && value.trim().toLowerCase().equals("chunked")) {
            this.chunked = true;
            this.responseChunkQueue = new ConcurrentLinkedQueue();
        }
    }

    protected void prepareWSResponseQueue() {
        this.websocket = true;
        this.responseChunkQueue = new ConcurrentLinkedQueue();
    }

    public boolean isGZIPEncoded() {
        return this.responseHeaders.get("content-encoding") != null && ((String)this.responseHeaders.get("content-encoding")).toLowerCase().equals("gzip");
    }

    protected void setBody(char[] data) {
        this.body = new String(data);
    }

    public void setBody(byte[] data) {
        try {
            if (this.isGZIPEncoded()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                GZIPInputStream stream = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] arr = new byte[1024];
                int c = -1;
                while ((c = stream.read(arr)) != -1) {
                    baos.write(arr, 0, c);
                }
                data = baos.toByteArray();
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        try {
            this.body = new String(data, "UTF-8");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void addChunk(byte[] data) {
        int size = this.responseChunkQueue.size();
        if (this.MAX_CHUNK_COUNT != -1 && size > this.MAX_CHUNK_COUNT) {
            this.responseChunkQueue.poll();
            --this.chunkCounter;
        }
        this.responseChunkQueue.add(data);
        ++this.chunkCounter;
    }

    public HashMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseHeader(String key) {
        return (String)this.responseHeaders.get(key);
    }

    public String getResponseString() {
        try {
            byte[] data;
            if ((this.chunked || this.websocket) && (data = (byte[])this.responseChunkQueue.poll()) != null) {
                --this.chunkCounter;
                return new String(data, "UTF-8");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.body;
    }

    public String getResponseString(boolean removeResponse) {
        if (removeResponse) {
            return this.getResponseString();
        }
        try {
            byte[] data;
            if (this.chunked && (data = (byte[])this.responseChunkQueue.peek()) != null) {
                return new String(data, "UTF-8");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return this.body;
    }

    private String getResponseString(boolean removeResponse, boolean latestData) {
        try {
            if (!removeResponse && latestData && this.chunked) {
                Object[] dataArray = this.responseChunkQueue.toArray();
                byte[] databytes = (byte[])dataArray[this.chunkCounter - 1];
                if (databytes != null) {
                    return new String(databytes, "UTF-8");
                }
            } else {
                if (!removeResponse && !latestData) {
                    return this.getResponseString(false);
                }
                if (removeResponse) {
                    return this.getResponseString();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getRawResponseData() {
        byte[] data;
        if (this.chunked && (data = (byte[])this.responseChunkQueue.poll()) != null) {
            --this.chunkCounter;
            return data;
        }
        if (this.body != null) {
            return this.body.getBytes();
        }
        return null;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public byte[] getCompleteRawData() {
        byte[] data = (byte[])this.responseChunkQueue.poll();
        if (data != null) {
            --this.chunkCounter;
            return data;
        }
        return null;
    }
}

