/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.log4jarchive;

import com.adventnet.wms.common.log4jarchive.LogFileNameFilter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.List;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;

public class Log4jArchiver
extends Thread {
    private static Logger logger = Logger.getLogger("default");
    private static boolean monitor = true;
    int interval = 60;
    private int date;
    private int month;
    private int year;
    private String logDirHome;
    private String archiveDirHome = "/home/sas/archive/";
    private File logDir;
    private ArrayList<String> logFileNameList;
    private Hashtable fileNameMaxCount = new Hashtable();
    private boolean maxFileCountArchive = false;
    private int backupDays = 10;
    private long backupTimeMillis;

    public Log4jArchiver(String logDirPath, String archiveDirPath, int monitorInterval, String defloggername) {
        this.logDirHome = logDirPath;
        if (!this.logDirHome.endsWith(File.separator)) {
            this.logDirHome = this.logDirHome + File.separator;
        }
        this.logDir = new File(this.logDirHome);
        if (archiveDirPath != null && !archiveDirPath.equals("")) {
            this.archiveDirHome = archiveDirPath;
            if (!this.archiveDirHome.endsWith(File.separator)) {
                this.archiveDirHome = this.archiveDirHome + File.separator;
            }
            this.archiveDirHome = this.archiveDirHome + "archive" + File.separator;
        }
        this.createArchiveDirectory();
        if (defloggername != null && !defloggername.equals("")) {
            logger = Logger.getLogger(defloggername);
        }
        this.interval = monitorInterval;
        this.assignDay();
        this.loadLoggers();
        this.setBackupDays(this.backupDays);
        logger.info("Log4jArchiver :: starting log4j archive [LOGDIRPATH] " + this.logDirHome + " [ARCHIVEDIR] " + this.archiveDirHome + " [MONITORINTERVAL] " + monitorInterval);
    }

    public void enableMaxFileCountArchive() {
        this.maxFileCountArchive = true;
    }

    public void setBackupDays(int noofdays) {
        this.backupDays = noofdays;
        this.backupTimeMillis = System.currentTimeMillis() + (long)(24 * this.backupDays * 60 * 60) * 1000L;
        logger.info("Log4jArchiver setting log archive backuptime " + this.backupTimeMillis + " days " + this.backupDays);
    }

    @Override
    public void run() {
        while (monitor) {
            try {
                Thread.sleep(this.interval * 60 * 1000);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            if (System.currentTimeMillis() >= this.backupTimeMillis) {
                this.clearArchives();
                this.setBackupDays(this.backupDays);
            }
            for (int logcount = 0; logcount < this.logFileNameList.size(); ++logcount) {
                try {
                    String loggerfilename = this.logFileNameList.get(logcount);
                    if (!this.maxFileCountArchive) {
                        if (!this.isDayOver()) continue;
                        logger.info("Log4jArchiver :: rolling logs day over");
                        this.doArchive(loggerfilename);
                        this.assignDay();
                        continue;
                    }
                    if (!this.isMaxFileCountReached(loggerfilename)) continue;
                    this.doArchive(loggerfilename);
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private boolean isDayOver() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(1) > this.year || calendar.get(2) + 1 > this.month || calendar.get(5) > this.date;
    }

    private void assignDay() {
        Calendar calendar = Calendar.getInstance();
        this.date = calendar.get(5);
        this.month = calendar.get(2) + 1;
        this.year = calendar.get(1);
    }

    private void loadLoggers() {
    }

    private boolean isMaxFileCountReached(String loggerfileName) {
        try {
            int fileMaxCount;
            List<File> logFiles = this.getFiles(loggerfileName);
            int existingLogFileCount = logFiles.size();
            if (this.fileNameMaxCount.containsKey(loggerfileName) && existingLogFileCount >= (fileMaxCount = Integer.parseInt("" + this.fileNameMaxCount.get(loggerfileName)))) {
                logger.info("Log4jArchiver :: max file count reached " + loggerfileName);
                return true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doArchive(String loggerfilename) {
        block30: {
            FileOutputStream fos = null;
            ZipOutputStream zipOs = null;
            try {
                List<File> logFiles = this.getFiles(loggerfilename);
                if (logFiles == null || logFiles.size() <= 0) break block30;
                long archiveStartTime = System.currentTimeMillis();
                logger.info("Log4jArchiver :: starting archvie " + loggerfilename);
                fos = new FileOutputStream(this.archiveDirHome + this.getArchiveDirName(loggerfilename));
                zipOs = new ZipOutputStream(fos);
                for (File file : logFiles) {
                    boolean remove = false;
                    FileInputStream fis = null;
                    try {
                        int count;
                        fis = new FileInputStream(file);
                        ZipEntry zipEntry = new ZipEntry(file.getName());
                        zipOs.putNextEntry(zipEntry);
                        byte[] data = new byte[2048];
                        while ((count = fis.read(data, 0, 2048)) != -1) {
                            zipOs.write(data, 0, count);
                        }
                        remove = true;
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    finally {
                        try {
                            fis.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (!remove || file.getName().endsWith(".txt")) continue;
                    file.delete();
                }
                zipOs.close();
                long avgtime = System.currentTimeMillis() - archiveStartTime;
                logger.info("Log4jArchiver :: ending archive (TIME TAKEN)" + avgtime + "msec");
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            finally {
                try {
                    fos.close();
                }
                catch (Exception exception) {}
                try {
                    zipOs.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private List<File> getFiles(String loggerfileName) {
        ArrayList<File> fileList = new ArrayList<File>();
        try {
            File[] files;
            if (!this.logDir.exists()) {
                monitor = false;
            }
            for (File file : files = this.logDir.listFiles(new LogFileNameFilter(loggerfileName))) {
                fileList.add(file);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return fileList;
    }

    private String getLogFileName(String path) {
        try {
            if (path != null) {
                File file = new File(path);
                return file.getName();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return path;
    }

    private void createArchiveDirectory() {
        File archiveDir = new File(this.archiveDirHome);
        if (!archiveDir.exists()) {
            archiveDir.mkdirs();
        }
    }

    private String getArchiveDirName(String name) {
        name = name.replace(".txt", "");
        String standardName = name + "_archive_" + this.date + "_" + this.month + "_" + this.year;
        File archiveFile = new File(this.archiveDirHome + standardName + ".zip");
        if (archiveFile.exists()) {
            for (int nameCount = 1; nameCount <= 5; ++nameCount) {
                String uniquename = standardName + "_" + nameCount;
                archiveFile = new File(this.archiveDirHome + uniquename + ".zip");
                if (archiveFile.exists()) continue;
                return uniquename + ".zip";
            }
        }
        return standardName + ".zip";
    }

    private void clearArchives() {
        try {
            logger.warning("Log4jArchiver :: clearArchives");
            File archDir = new File(this.archiveDirHome);
            for (File file : archDir.listFiles()) {
                file.delete();
            }
            logger.warning("Log4jArchiver :: archives cleared");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

