/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.counters;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.MathContext;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class RangeCounter {
    private long rmin;
    private long rmax;
    private AtomicLong count;
    private long totalValue;
    private long maxValue;
    private long minValue = Long.MAX_VALUE;
    private ConcurrentHashMap<Long, RangeValue> range = new ConcurrentHashMap();
    private long hpRMin;
    private long hpRMax;
    private boolean hpEnabled = true;
    private ConcurrentHashMap<Long, RangeValue> hpRange = new ConcurrentHashMap();
    private double[] percentageRanges = new double[]{50.0, 75.0, 90.0, 92.5, 95.0, 96.0, 97.0, 98.0, 98.5, 99.0, 99.5, 100.0};

    public RangeCounter(long rmin, long rmax) {
        this.rmin = rmin > 0L ? this.floor(rmin) : 0L;
        this.rmax = rmax > 0L ? this.ceil(rmax) : 0L;
        this.count = new AtomicLong();
    }

    public RangeCounter(long rmin, long rmax, boolean hpEnabled) {
        if (hpEnabled) {
            this.hpRMin = 0L;
            this.hpRMax = rmax > 0L ? this.hpCeil(rmax) : 0L;
        }
        this.rmin = rmin > 0L ? this.floor(rmin) : 0L;
        this.rmax = rmax > 0L ? this.ceil(rmax) : 0L;
        this.count = new AtomicLong();
        this.hpEnabled = hpEnabled;
    }

    private RangeCounter(long rmin, long rmax, long count, long maxValue) {
        this.rmin = rmin;
        this.rmax = rmax;
        this.count = new AtomicLong();
        this.count.addAndGet(count);
        this.maxValue = maxValue;
    }

    public void reset() {
        this.count = new AtomicLong();
        this.maxValue = 0L;
        this.range = new ConcurrentHashMap();
        this.hpRange = new ConcurrentHashMap();
    }

    public long maxValue() {
        return this.maxValue;
    }

    public long minValue() {
        if (this.minValue == Long.MAX_VALUE) {
            return 0L;
        }
        return this.minValue;
    }

    public long totalValue() {
        return this.totalValue;
    }

    public long count() {
        return this.count.longValue();
    }

    public long add(long value) {
        this.count.incrementAndGet();
        this.totalValue += value;
        this.maxValue = value > this.maxValue ? value : this.maxValue;
        this.minValue = value < this.minValue ? value : this.minValue;
        long spread = this.floor(value);
        spread = spread < this.rmin ? 0L : (spread > this.rmax ? this.rmax : spread);
        RangeValue rv = this.range.get(spread);
        if (rv == null) {
            rv = spread < this.rmin ? new RangeValue(spread, this.rmin, new AtomicLong()) : (spread == this.rmax ? new RangeValue(spread, this.ceil(value), new AtomicLong()) : new RangeValue(spread, this.ceil(spread + 1L), new AtomicLong()));
            this.range.put(spread, rv);
        }
        if (spread == this.rmax && rv.rmax < this.ceil(value)) {
            rv.rmax = this.ceil(value);
        }
        rv.counter.incrementAndGet();
        if (this.hpEnabled) {
            long hpSpread = this.hpFloor(value);
            hpSpread = hpSpread < this.hpRMin ? 0L : (hpSpread > this.hpRMax ? this.hpRMax : hpSpread);
            RangeValue hpRV = this.hpRange.get(hpSpread);
            if (hpRV == null) {
                hpRV = hpSpread < this.hpRMin ? new RangeValue(hpSpread, this.hpRMin, new AtomicLong()) : (hpSpread == this.hpRMax ? new RangeValue(hpSpread, this.hpCeil(value), new AtomicLong()) : new RangeValue(hpSpread, this.hpCeil(hpSpread + 1L), new AtomicLong()));
                this.hpRange.put(hpSpread, hpRV);
            }
            if (hpSpread == this.hpRMax && hpRV.rmax < this.hpCeil(value)) {
                hpRV.rmax = this.hpCeil(value);
            }
            hpRV.counter.incrementAndGet();
        }
        return this.count.longValue();
    }

    public ArrayList getSpread() {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList<RangeValue> spreadList = Collections.list(this.range.elements());
        Collections.sort(spreadList, new Comparator<RangeValue>(){

            @Override
            public int compare(RangeValue o1, RangeValue o2) {
                if (o1 != null && o2 != null) {
                    if (o1.rmin < o2.rmin) {
                        return 1;
                    }
                    if (o1.rmin > o2.rmin) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        for (RangeValue rv : spreadList) {
            list.add(rv.getHash());
        }
        return list;
    }

    public ArrayList getHPSpread() {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList<RangeValue> spreadList = Collections.list(this.hpRange.elements());
        Collections.sort(spreadList, new Comparator<RangeValue>(){

            @Override
            public int compare(RangeValue o1, RangeValue o2) {
                if (o1 != null && o2 != null) {
                    if (o1.rmin < o2.rmin) {
                        return 1;
                    }
                    if (o1.rmin > o2.rmin) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        for (RangeValue rv : spreadList) {
            list.add(rv.getHash());
        }
        return list;
    }

    public LinkedHashMap<Double, Long> getPercentageRange() {
        long reValue = 0L;
        int position = 0;
        double percentage = 0.0;
        long totalCount = this.count.get();
        LinkedHashMap<Double, Long> percentageRange = new LinkedHashMap<Double, Long>();
        if (!this.hpEnabled) {
            return percentageRange;
        }
        ArrayList spreads = this.getHPSpread();
        Collections.reverse(spreads);
        int spreadsSize = spreads.size();
        for (int i = 0; i < spreadsSize; ++i) {
            Hashtable ht = (Hashtable)spreads.get(i);
            reValue = (Long)ht.get("re");
            percentage += (double)((Long)ht.get("count")).longValue() / (double)totalCount * 100.0;
            while (position < this.percentageRanges.length && percentage >= this.percentageRanges[position]) {
                percentageRange.put(this.percentageRanges[position], reValue);
                ++position;
            }
        }
        while (position < this.percentageRanges.length) {
            percentageRange.put(this.percentageRanges[position], reValue);
            ++position;
        }
        return percentageRange;
    }

    public Hashtable getHash() {
        Hashtable<String, Serializable> value = new Hashtable<String, Serializable>();
        value.put("rmin", Long.valueOf(this.rmin));
        value.put("rmax", Long.valueOf(this.rmax));
        value.put("count", Long.valueOf(this.count.longValue()));
        value.put("maxValue", Long.valueOf(this.maxValue));
        value.put("spread", this.getSpread());
        if (this.hpEnabled) {
            value.put("hpSpread", this.getHPSpread());
        }
        return value;
    }

    public static RangeCounter parse(Hashtable ht) {
        try {
            RangeCounter wrc = new RangeCounter((Long)ht.get("rmin"), (Long)ht.get("rmax"), (Long)ht.get("count"), (Long)ht.get("maxValue"));
            ArrayList spread = (ArrayList)ht.get("spread");
            for (Hashtable r : spread) {
                RangeValue rv = new RangeValue(r);
                wrc.range.put(rv.rmin, rv);
            }
            return wrc;
        }
        catch (Exception e) {
            return null;
        }
    }

    public ArrayList getSpread(int mx, int bcmin, int bcmax) {
        ArrayList<Hashtable> list = new ArrayList<Hashtable>();
        ArrayList<RangeValue> groupList = new ArrayList<RangeValue>();
        ArrayList<RangeValue> spreadList = Collections.list(this.range.elements());
        if (spreadList.size() == 0) {
            return list;
        }
        Collections.sort(spreadList, new Comparator<RangeValue>(){

            @Override
            public int compare(RangeValue o1, RangeValue o2) {
                if (o1 != null && o2 != null) {
                    if (o1.rmin < o2.rmin) {
                        return 1;
                    }
                    if (o1.rmin > o2.rmin) {
                        return -1;
                    }
                    return 0;
                }
                return 0;
            }
        });
        RangeValue prev = spreadList.get(0);
        groupList.add(prev);
        for (int i = 1; i < spreadList.size(); ++i) {
            RangeValue newVal = spreadList.get(i);
            if (prev.counter.get() > (long)bcmin || prev.counter.get() + newVal.counter.get() > (long)bcmax || (prev.rmin - newVal.rmax) * (long)mx > newVal.rmin) {
                prev = newVal;
                groupList.add(newVal);
                continue;
            }
            prev.counter.addAndGet(newVal.counter.get());
            prev.rmin = newVal.rmin;
        }
        for (RangeValue rv : groupList) {
            list.add(rv.getHash());
        }
        return list;
    }

    public boolean merge(Hashtable ht) {
        try {
            this.rmin = (Long)ht.get("rmin") < this.rmin ? (Long)ht.get("rmin") : this.rmin;
            this.rmax = (Long)ht.get("rmax") > this.rmax ? (Long)ht.get("rmax") : this.rmax;
            this.count.addAndGet((Long)ht.get("count"));
            this.maxValue = (Long)ht.get("maxValue") > this.maxValue ? (Long)ht.get("maxValue") : this.maxValue;
            ArrayList spread = (ArrayList)ht.get("spread");
            for (Hashtable r : spread) {
                RangeValue rv = new RangeValue(r);
                RangeValue base = this.range.get(rv.rmin);
                if (base == null) {
                    base = rv;
                    this.range.put(rv.rmin, rv);
                    continue;
                }
                base.merge(rv);
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private long hpCeil(long value) {
        try {
            return new BigDecimal(value, new MathContext(2, RoundingMode.CEILING)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long hpFloor(long value) {
        try {
            return new BigDecimal(value, new MathContext(2, RoundingMode.FLOOR)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long ceil(long value) {
        try {
            return new BigDecimal(value, new MathContext(1, RoundingMode.CEILING)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private long floor(long value) {
        try {
            return new BigDecimal(value, new MathContext(1, RoundingMode.FLOOR)).longValue();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    private static class RangeValue {
        public long rmin;
        public long rmax;
        public AtomicLong counter;

        private RangeValue(long rmin, long rmax, AtomicLong counter) {
            this.rmin = rmin;
            this.rmax = rmax;
            this.counter = counter;
        }

        private RangeValue(Hashtable<String, Long> ht) {
            this.rmin = ht.get("rs");
            this.rmax = ht.get("re");
            this.counter = new AtomicLong();
            this.counter.addAndGet(ht.get("count"));
        }

        private Hashtable getHash() {
            Hashtable<String, Long> v = new Hashtable<String, Long>();
            v.put("rs", this.rmin);
            v.put("re", this.rmax);
            v.put("count", this.counter.longValue());
            return v;
        }

        private void merge(RangeValue rv) {
            if (this.rmin == rv.rmin) {
                this.rmax = this.rmax < rv.rmax ? rv.rmax : this.rmax;
                this.counter.addAndGet(rv.counter.longValue());
            }
        }
    }
}

