/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.constants;

public class UserStatus {
    public static final UserStatus OFFLINE = new UserStatus(0, "Offline");
    public static final UserStatus ONLINE = new UserStatus(1, "Available");
    public static final UserStatus INVISIBLE = new UserStatus(2, "Invisible");
    public static final UserStatus BUSY = new UserStatus(3, "Busy");
    public static final UserStatus IDLE = new UserStatus(4, "Idle");
    public static final UserStatus DND = new UserStatus(5, "Do not disturb");
    public static final UserStatus ENGAGED = new UserStatus(6, "Engaged");
    public static final UserStatus AWAY = new UserStatus(7, "Away");
    private int scode;
    private String smsg;

    private UserStatus(int scode, String smsg) {
        this.scode = scode;
        this.smsg = smsg;
    }

    public UserStatus(int scode) {
        this.scode = scode;
        this.smsg = UserStatus.getStatusMessage(scode);
    }

    public int getScode() {
        return this.scode;
    }

    public String getStatusMsg() {
        return this.smsg;
    }

    public String toString() {
        return "" + this.scode;
    }

    private static String getStatusMessage(int scode) {
        switch (scode) {
            case 1: {
                return "Available";
            }
            case 0: {
                return "Offline";
            }
            case 3: {
                return "Busy";
            }
            case 4: {
                return "Idle";
            }
            case 2: {
                return "Invisible";
            }
            case 5: {
                return "Do not disturb";
            }
            case 6: {
                return "Engaged";
            }
            case 7: {
                return "Away";
            }
        }
        return "Unknown";
    }
}

