/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.util;

import com.adventnet.wms.common.HttpDataWraper;
import java.nio.ByteBuffer;
import java.util.Hashtable;

public class WCPPacket {
    long packetId = -1L;
    int packetType = -1;
    long fa = 0L;
    int payloadType = 0;
    byte[] payloadData = null;
    Hashtable<String, String> header = null;
    long bqInTime = 0L;
    int statusCode = -1;
    long qTime = -1L;
    long netInTime = -1L;

    public WCPPacket() {
        this.fa = 0L;
        this.packetId = -1L;
        this.packetType = -1;
        this.payloadType = 0;
        this.payloadData = null;
        this.header = new Hashtable();
    }

    public WCPPacket(long packetId, int packetType, long flg, Hashtable<String, String> header, int payloadType, byte[] payloadData) {
        this.fa = flg;
        this.header = header == null ? new Hashtable() : header;
        this.packetId = packetId;
        this.packetType = packetType;
        this.payloadType = payloadType;
        this.payloadData = payloadData;
    }

    public WCPPacket(long packetId, int packetType, long flg, Hashtable<String, String> header, int payloadType, byte[] payloadData, int statusCode) {
        this.fa = flg;
        this.header = header == null ? new Hashtable() : header;
        this.packetId = packetId;
        this.packetType = packetType;
        this.payloadType = payloadType;
        this.payloadData = payloadData;
        this.statusCode = statusCode;
    }

    public boolean addHeader(String key, String value) {
        if (key == null || value == null) {
            return false;
        }
        this.header.put(key, value);
        return true;
    }

    public void setPacketId(long packId) {
        this.packetId = packId;
    }

    public void setStatusCode(int statusCode) {
        this.statusCode = statusCode;
    }

    public void setQueueInTime(long time) {
        this.bqInTime = time;
    }

    public String getHeader(String key) {
        return this.header.get(key);
    }

    public int getPayloadDataLength() {
        if (this.payloadData != null) {
            return this.payloadData.length;
        }
        return 0;
    }

    public int getHeaderLength() {
        try {
            if (this.header != null) {
                return HttpDataWraper.getString(this.header).getBytes("UTF-8").length;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }

    public long getPacketId() {
        return this.packetId;
    }

    public int getPacketType() {
        return this.packetType;
    }

    public long getFA() {
        return this.fa;
    }

    public byte[] getPayLoadData() {
        return this.payloadData;
    }

    public byte[] getHeaderData() {
        try {
            return HttpDataWraper.getString(this.header).getBytes("UTF-8");
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getPayLoadType() {
        return this.payloadType;
    }

    public Hashtable<String, String> getHeaderAsTable() {
        return this.header;
    }

    public long getQueueInTime() {
        return this.bqInTime;
    }

    public int getStatusCode() {
        return this.statusCode;
    }

    public long getQTime() {
        return this.qTime;
    }

    public void setQTime(long qTime) {
        this.qTime = qTime;
    }

    public long getNetInTime() {
        return this.netInTime;
    }

    public void setNetInTime(long netInTime) {
        this.netInTime = netInTime;
    }

    public byte[] getCompletePacketData() throws Exception {
        ByteBuffer bb = null;
        if (1 == this.packetType || 6 == this.packetType) {
            int headerLen = this.getHeaderLength();
            int dataLen = this.getPayloadDataLength();
            int instrumentationValue = this.getNoOfInstValues();
            bb = ByteBuffer.allocate(29 + dataLen + headerLen + 1 + instrumentationValue * 8);
            bb.putLong(this.packetId);
            bb.put((byte)this.packetType);
            bb.putLong(this.fa);
            bb.putInt(headerLen);
            if (headerLen > 0) {
                bb.put(this.getHeaderData());
            }
            bb.putInt(this.payloadType);
            bb.putInt(dataLen);
            if (dataLen > 0) {
                bb.put(this.getPayLoadData());
            }
            if (this.qTime != -1L && this.netInTime != -1L) {
                bb.put((byte)instrumentationValue);
                bb.putLong(this.qTime);
                bb.putLong(this.netInTime);
            }
        } else if (2 == this.packetType) {
            int instrumentationValue = this.getNoOfInstValues();
            bb = ByteBuffer.allocate(15 + instrumentationValue * 8);
            bb.putLong(this.packetId);
            bb.put((byte)this.packetType);
            bb.put((byte)this.payloadType);
            if (this.statusCode != -1) {
                bb.putInt(this.statusCode);
            }
            if (this.qTime != -1L && this.netInTime != -1L) {
                bb.put((byte)instrumentationValue);
                bb.putLong(this.qTime);
                bb.putLong(this.netInTime);
            }
        } else if (4 == this.packetType) {
            int dataLen = this.getPayloadDataLength();
            bb = ByteBuffer.allocate(13 + dataLen);
            bb.putLong(this.packetId);
            bb.put((byte)this.packetType);
            bb.putInt(dataLen);
            if (dataLen > 0) {
                bb.put(this.getPayLoadData());
            }
        } else if (7 == this.packetType || 8 == this.packetType || 14 == this.packetType || 15 == this.packetType) {
            int headerLen = this.getHeaderLength();
            int dataLen = this.getPayloadDataLength();
            int instrumentationValue = this.getNoOfInstValues();
            bb = ByteBuffer.allocate(25 + dataLen + headerLen + 1 + instrumentationValue * 8);
            bb.putLong(this.packetId);
            bb.put((byte)this.packetType);
            bb.putLong(this.fa);
            bb.putInt(headerLen);
            if (headerLen > 0) {
                bb.put(this.getHeaderData());
            }
            bb.putInt(dataLen);
            if (dataLen > 0) {
                bb.put(this.getPayLoadData());
            }
            if (this.qTime != -1L && this.netInTime != -1L) {
                bb.put((byte)instrumentationValue);
                bb.putLong(this.qTime);
                bb.putLong(this.netInTime);
            }
        } else if (3 == this.packetType) {
            int headerLen = this.getHeaderLength();
            int dataLen = this.getPayloadDataLength();
            bb = ByteBuffer.allocate(29 + dataLen + headerLen);
            bb.putLong(this.packetId);
            bb.put((byte)this.packetType);
            bb.putLong(this.fa);
            bb.putInt(headerLen);
            if (headerLen > 0) {
                bb.put(this.getHeaderData());
            }
            bb.putInt(this.payloadType);
            bb.putInt(dataLen);
            if (dataLen > 0) {
                bb.put(this.getPayLoadData());
            }
        } else if (5 == this.packetType) {
            int headerLen = this.getHeaderLength();
            int dataLen = this.getPayloadDataLength();
            bb = ByteBuffer.allocate(29 + dataLen + headerLen);
            bb.putLong(this.packetId);
            bb.put((byte)this.packetType);
            bb.putLong(this.fa);
            bb.putInt(headerLen);
            if (headerLen > 0) {
                bb.put(this.getHeaderData());
            }
            bb.putInt(this.payloadType);
            bb.putInt(dataLen);
            if (dataLen > 0) {
                bb.put(this.getPayLoadData());
            }
        }
        return bb.array();
    }

    private int getNoOfInstValues() {
        int value = 0;
        if (this.qTime != -1L) {
            ++value;
        }
        if (this.netInTime != -1L) {
            ++value;
        }
        return value;
    }
}

