/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.util;

public class WCPConstants {
    public static final long WCP_FLAG_EMPTY = 0L;
    public static final int WCP_DEFAULT_PAYLOAD_TYPE = 0;
    public static final String WCP_DEFAULT_SERVING_MODE = "rw";
    public static final String WCP_DEFAULT_LB_TECHNIQUE = "df";
    public static final String WCP_ROUND_ROBIN_LB_TECHNIQUE = "rr";
    public static final String WCP_LEAST_LOADED_LB_TECHNIQUE = "ll";
    public static final String STATS_CONNECTION_SUCCESS = "success";
    public static final String STATS_CONNECTION_FAILURE = "failure";
    public static final String STATS_CONNECTION_LIFETIME = "lifetime";
    public static final String STATS_CONNECTION_ONCONNECT = "conn_onconnect";
    public static final String STATS_CONNECTION_ONCLOSE = "conn_onclose";
    public static final String STATS_MSG_DATA_SENT = "data_sent";
    public static final String STATS_MSG_ACK_RECEIVED = "ack_received";
    public static final String STATS_MSG_NTY_RECEIVED = "nyt_received";
    public static final String STATS_MSG_NTY_ACK_SENT = "nyt_ack_sent";
    public static final String STATS_MSG_META_RECEIVED = "meta_received";
    public static final String STATS_MSG_CTRL_RECEIVED = "ctrl_received";
    public static final String STATS_FRWD_DATA_SENT = "frwd_data_sent";
    public static final String STATS_FRWD_ACK_RECEIVED = "frwd_ack_received";
    public static final String STATS_PACKET_RESEND = "packet_resend";
    public static final String STATS_REQUEST_SENT = "req_sent";
    public static final String STATS_REQUEST_ACK_RECEIVED = "req_ack_received";
    public static final String STATS_RESPONCE_RECEIVED = "res_received";
    public static final String STATS_RESPONSE_ACK_SENT = "res_ack_sent";
    public static final String STATS_MSG_DATA_RECEIVED = "data_received";
    public static final String STATS_MSG_ACK_SENT = "ack_sent";
    public static final String STATS_MSG_NTY_SENT = "nyt_sent";
    public static final String STATS_MSG_NTY_ACK_RECEIVED = "nyt_ack_received";
    public static final String STATS_MSG_META_SENT = "meta_sent";
    public static final String STATS_MSG_CTRL_SENT = "ctrl_sent";
    public static final String STATS_FRWD_DATA_RECEIVED = "frwd_data_received";
    public static final String STATS_FRWD_ACK_SENT = "frwd_ack_sent";
    public static final String STATS_REQUEST_RECEIVED = "req_received";
    public static final String STATS_REQUEST_ACK_SENT = "req_ack_sent";
    public static final String STATS_RESPONSE_ACK_RECEIVED = "res_ack_received";
    public static final String STATS_MSG_RTT = "rtt";
    public static final String STATS_LISTENER_ONMESSAGE = "on_message";
    public static final String STATS_LISTENER_ONERROR = "on_error";
    public static final String STATS_LISTENER_ONNOTIFY = "on_notify";
    public static final String STATS_LISTENER_META = "meta";
    public static final String STATS_LISTENER_HANDLEFORWARD = "handle_forward";
    public static final String STATS_WCP_DATA_STATUS_SUCCESS = "success";
    public static final String STATS_WCP_DATA_STATUS_FAILURE = "failure";
    public static final String STATS_WCP_DATA_STATUS_DROP = "drop";
    public static final String SUCCESS_RESPONSE_CODE = "200";
    public static final String SUCCESS_RESPONSE_STRING = "OK";
    public static final String REQUEST_TIMEOUT_CODE = "408";
    public static final String REQUEST_TIMEOUT_STRING = "request_timeout";
    public static final String REDIRECT_RESPONSE_CODE = "307";
    public static final String WCP_THREAD_PREFIX = "WCP/";
    public static final String WCP_READ_THREAD = "read_thread";
    public static final String WCP_WRITE_THREAD = "write_thread";
    public static final String REQUEST_ID = "x-wcp-reqid";

    public static final class Security {

        public static final class ConnectionFailedStatusCode {
            public static final int ACCESS_TOKEN_VERIFICATION_FAILED = 503;
            public static final int ACCESS_TOKEN_EXPIRED = 504;
            public static final int API_NOT_ALLOWED = 505;
        }

        public static final class AccessTokenStatus {
            public static final int SUCCESS = 0;
            public static final int FAILED = 1;
            public static final int EXPIRED = 2;
        }

        public static final class HeaderKeys {
            public static final String ACCESS_TOKEN = "x-wcp-api-accesstoken";
            public static final String FAILED_STATUS = "x-wcp-failed-status";
            public static final String ACCESS_TOKEN_VERIFICATION_STATUS = "x-wcp-accesstoken-verification-status";
        }
    }

    public static class META {
        public static final int SEED_CHANGE = 1;
    }

    public static class CONTROL {
        public static final int PAUSE = 1;
        public static final int RESUME = 2;
        public static final int START = 3;
        public static final int CLOSE = 4;
        public static final int REDIRECT = 5;
        public static final int ADD_CONNECTION = 6;
    }

    public static class ConnectionPool {
        public static final int CREATED = 1;
        public static final int ALREADY_EXISTS = 2;
    }

    public static class CommunicationType {
        public static final String MSG_SENT = "msg_sent";
        public static final String MSG_RECEIVED = "msg_received";
        public static final String ACK_SENT = "ack_sent";
        public static final String ACK_RECEIVED = "ack_received";
    }

    public static class PacketHeader {
        public static final String QUEUE_TIME = "x-bq-intime";
        public static final String SERVLET_IN_TIME = "x-servlet-intime";
    }

    public static class PacketType {
        public static final String DATA = "data";
        public static final String META = "meta";
        public static final String NOTIFY = "notify";
        public static final String CONTROL = "control";
        public static final String FORWARD = "forward";
        public static final String REQUEST = "request";
        public static final String RESPONSE = "response";
        public static final String CB_REQUEST = "cb-request";
        public static final String CB_RESPONSE = "cb-response";

        public static String getPacketTypeString(int packtype) {
            switch (packtype) {
                case 1: {
                    return DATA;
                }
                case 3: {
                    return "meta";
                }
                case 4: {
                    return NOTIFY;
                }
                case 5: {
                    return CONTROL;
                }
                case 7: {
                    return REQUEST;
                }
                case 8: {
                    return RESPONSE;
                }
                case 14: {
                    return CB_REQUEST;
                }
                case 15: {
                    return CB_RESPONSE;
                }
            }
            return null;
        }
    }
}

