/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.stats;

import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.stats.influx.StatsDB;
import com.adventnet.wms.common.stats.influx.conf.StatsConf;
import java.util.logging.Logger;

public class WCPStats {
    private static Logger logger = Logger.getLogger(WCPStats.class.getName());
    private static boolean disableStats = false;

    public static void disable() {
        disableStats = true;
    }

    public static void addWCPConnection(String prd, String apiName, String poolName, String remoteIp, String tagName, String connStatus, String reason, long connLife) {
        if (!disableStats) {
            try {
                switch (tagName) {
                    case "conn_onconnect": {
                        StatsDB.addData("wcp_clientconn", prd, apiName, poolName, remoteIp, connStatus, reason, StatsConf.getServerIp(), connLife, 1, 0, 0);
                        break;
                    }
                    case "conn_onclose": {
                        StatsDB.addData("wcp_clientconn", prd, apiName, poolName, remoteIp, connStatus, reason, StatsConf.getServerIp(), 0, 0, 1, connLife);
                        break;
                    }
                }
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPConnection][wcp_clientconn][" + e.getMessage() + "]");
            }
        }
    }

    public static void updateLiveStats(String prd, String apiName, String poolName, String remoteIp, long liveConnCount, long optimalConnCount, long bqRatePerMin, long liveBqSize, long notifyQueueSize, long metaQueueSize) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientlivestats", prd, apiName, poolName, remoteIp, StatsConf.getServerIp(), liveConnCount, optimalConnCount, bqRatePerMin, liveBqSize, notifyQueueSize, metaQueueSize);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - updateLiveStats][wcp_clientlivestats][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPClientData(String prd, String apiName, String poolName, String remoteIp, String packetType, String communication) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientdata", prd, apiName, poolName, remoteIp, packetType, communication, StatsConf.getServerIp(), 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPClientData][wcp_clientdata][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPListenerStats(String tname, String source, long millis) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_listnr_time", tname, source, millis);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPListenerStats][wcp_listnr_time][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPConnReconnect(String prd, String apiName, String poolName, String remoteIp, String sid) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_reconnect", prd, apiName, poolName, remoteIp, sid, StatsConf.getServerIp(), 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPConnReconnect][wcp_reconnect][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPDataSizeStats(String prd, String apiName, String poolName, String remoteip, String status, long dataSize) {
        try {
            StatsDB.addData("wcp_clientdatasize", prd, apiName, poolName, remoteip, status, StatsConf.getServerIp(), dataSize, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPDataSizeStats][" + e.getMessage() + "]");
        }
    }

    public static void servletNotFound(String apiName, String prd, String remoteServerType, String servlet, String remoteIp) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_servlet_notfound", apiName, prd, remoteServerType, servlet, remoteIp, StatsConf.getServerIp(), 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - servletNotFound][" + e.getMessage() + "]");
        }
    }

    public static void addWCPCBRequestHits(String apiName, String prd, String remoteServerType, String remoteIp, String servletName, String status, long time) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_srv_hits", apiName, prd, remoteServerType, remoteIp, servletName, status, StatsConf.getServerIp(), 1, time);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPSrvHits][wcp_srv_hits][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWSCloseStats(String threadName, String apiName, String prd, String poolName, String remoteIp, String errorMsg, String threadInfo, long threadLife) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_thread_close", threadName, apiName, prd, poolName, remoteIp, errorMsg, StatsConf.getServerIp(), threadInfo, threadLife, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWSCloseStats][wcp_thread_close][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPErrorStats(String errorType, String apiName, String prd, String poolName, String reason) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_error", errorType, apiName, prd, poolName, reason, StatsConf.getServerIp(), 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPErrorStats][wcp_error][" + e.getMessage() + "]");
            }
        }
    }

    public static void addWCPRequestTimeout(String poolName, String prd, String apiName, String remoteIp, String uri) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_req_timeout", poolName, prd, apiName, remoteIp, uri, StatsConf.getServerIp(), 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPRequestTimeout][wcp_req_timeout][" + e.getMessage() + "]");
        }
    }

    public static void addWCPRequestTakenTime(String poolName, String servlet, String resCode, long takenTime) {
        if (disableStats) {
            return;
        }
        try {
            StatsDB.addData("wcp_request_time", WCPAPIDispatcher.getApiName(poolName), WCPAPIDispatcher.getPrd(poolName), poolName, servlet, resCode, StatsConf.getServerIp(), takenTime, 1);
        }
        catch (Exception e) {
            logger.info("[Exception][WCPStats - addWCPRequestTakenTime][" + e.getMessage() + "]");
        }
    }

    public static void addWCPClientRTT(String serverType, String remoteServerType, String poolName, String remoteIp, String packetTpye, long millis) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_clientrtt", serverType, remoteServerType, poolName, remoteIp, packetTpye, StatsConf.getServerIp(), millis, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addWCPClientData][wcp_clientrtt][" + e.getMessage() + "]");
            }
        }
    }

    public static void addExecutionTime(String handlerType, String apiName, String prd, String poolName, long exeTime) {
        if (!disableStats) {
            try {
                StatsDB.addData("wcp_execution_time", handlerType, apiName, prd, poolName, StatsConf.getServerIp(), exeTime, 1);
            }
            catch (Exception e) {
                logger.info("[Exception][WCPStats - addExecutionTime][wcp_execution_time][" + e.getMessage() + "]");
            }
        }
    }
}

