/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.servlet;

import com.adventnet.wms.common.components.net.servlet.DefaultServlet;
import com.adventnet.wms.common.components.net.servlet.WCPServlet;
import java.util.HashMap;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPServletMapper {
    private static Logger logger = Logger.getLogger(WCPServletMapper.class.getName());
    private static HashMap<String, WCPServlet> servletMap = new HashMap();
    private static WCPServlet defaultServlet = new DefaultServlet();

    public static boolean loadServlets(Properties servletMapping) {
        return WCPServletMapper.loadServlets(servletMap, servletMapping);
    }

    private static boolean loadServlets(HashMap<String, WCPServlet> servletMap, Properties classMap) {
        if (classMap != null) {
            for (String servletName : classMap.stringPropertyNames()) {
                String servletClass = (String)classMap.get(servletName);
                try {
                    logger.log(Level.INFO, "HB--> servletName={0} class={1}", new Object[]{servletName, servletClass});
                    servletMap.put(servletName, (WCPServlet)Class.forName(servletClass).newInstance());
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "[WCP][Exception - WCPServletMapper][loadServlets][" + servletName + "][" + servletClass + "]", ex);
                }
            }
        } else {
            logger.log(Level.INFO, "HB--> cbRequest-servlets properties is null");
            return false;
        }
        return true;
    }

    public static WCPServlet getServlet(String reqUrl) throws Exception {
        WCPServlet servlet = servletMap.get(reqUrl);
        if (servlet == null) {
            return defaultServlet;
        }
        return servlet;
    }

    public static DefaultServlet getDefaultServlet() {
        return (DefaultServlet)defaultServlet;
    }
}

