/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.servlet;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.components.net.WCPConfManager;
import java.util.Hashtable;

public class WCPRequest {
    private String uri = "";
    private String reqId = "-1";
    private String rkey = null;
    private long time = 0L;
    private long timeOutInMillis = WCPConfManager.getWCPRequestTimeOut();
    private long expiryTimeInMillis = -1L;
    private String data = null;
    private Hashtable<String, String> header = null;
    private Hashtable<String, String> params = null;
    private String remoteIp = "null";

    public WCPRequest(String uri) {
        this.uri = uri;
        this.data = "";
        this.header = new Hashtable();
        this.params = new Hashtable();
    }

    public WCPRequest(String uri, Hashtable<String, String> header, Hashtable<String, String> params, String data) {
        this.uri = uri;
        this.header = header;
        this.params = params;
        this.data = data;
        if (header == null) {
            this.header = new Hashtable();
        }
        if (params == null) {
            this.params = new Hashtable();
        }
    }

    public WCPRequest(Hashtable<String, String> ht) {
        this.uri = ht.get("uri");
        this.header = ht.get("header") != null ? (Hashtable)HttpDataWraper.getObject(ht.get("header")) : new Hashtable();
        this.params = ht.get("param") != null ? (Hashtable)HttpDataWraper.getObject(ht.get("param")) : new Hashtable();
        this.data = ht.get("data");
    }

    public void addHeader(String key, String value) {
        this.header.put(key, value);
    }

    public void addParam(String key, String value) {
        this.params.put(key, value);
    }

    public void setURI(String uri) {
        this.uri = uri;
    }

    public void setRKey(String rkey) {
        this.rkey = rkey;
    }

    public void setData(String data) {
        this.data = data;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public void setRemoteIp(String ip) {
        this.remoteIp = ip;
    }

    public void setTime(long time) {
        this.time = time;
    }

    public String getData() {
        return this.data;
    }

    public Hashtable<String, String> getHeaders() {
        return this.header;
    }

    public Hashtable<String, String> getParameters() {
        return this.params;
    }

    public String getURI() {
        return this.uri;
    }

    public String getRKey() {
        return this.rkey;
    }

    public String getReqId() {
        return this.reqId;
    }

    public String getParam(String key) {
        return this.params.get(key);
    }

    public String getHeader(String key) {
        return this.header.get(key);
    }

    public String getRemoteIp() {
        return this.remoteIp;
    }

    public long getTime() {
        return this.time;
    }

    public String getReqAsData() {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("uri", this.uri);
        this.header.put("timeoutinmillis", Long.toString(this.timeOutInMillis));
        if (this.header != null) {
            ht.put("header", HttpDataWraper.getString(this.header));
        }
        if (this.params != null) {
            ht.put("param", HttpDataWraper.getString(this.params));
        }
        if (this.data != null) {
            ht.put("data", this.data);
        }
        return HttpDataWraper.getString(ht);
    }

    public void setTimeOut(int timeInSeconds) {
        this.timeOutInMillis = timeInSeconds * 1000;
    }

    public long getTimeOutInMillis() {
        return this.timeOutInMillis;
    }

    public long getExpiryTime() {
        if (this.expiryTimeInMillis == -1L) {
            this.expiryTimeInMillis = System.currentTimeMillis() + this.timeOutInMillis;
        }
        return this.expiryTimeInMillis;
    }
}

