/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.connection;

import com.adventnet.wms.common.Base64;
import com.adventnet.wms.common.components.net.WCPConfManager;
import com.adventnet.wms.common.components.net.connection.WCPBIOClientConn;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.websocket.WebSocket;
import com.adventnet.wms.common.websocket.WebSocketHandler;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import javax.net.ssl.SSLContext;

public class WCPWebSocketV13
extends WebSocket {
    private static Logger logger = Logger.getLogger(WCPWebSocketV13.class.getName());
    private URI uri = null;
    private CharBuffer headerBuffer = CharBuffer.allocate(1024);
    private String cookie = null;
    private String host = null;
    private int port = -1;
    private boolean isSSL = false;
    private int conStatus = 0;
    private boolean isConnectException = false;
    private Socket socket = null;
    private InputStream in = null;
    private OutputStream out = null;
    private ReadThread readThread;
    private WriteThread writeThread;
    private Random random = new Random(System.currentTimeMillis());
    private static String newline = "\r\n";
    private static int version = 13;
    private static long pingInterval = 15L;
    private boolean isCompressionEnabled = false;
    private boolean tryCompression = true;
    private Inflater inflater;
    private Deflater deflater;
    private boolean hold_set = false;
    private boolean resume_set = false;
    private boolean close_set = false;
    private WCPBIOClientConn wcpConn;
    private boolean closed = false;
    private int maxdataperread = 1024;
    private byte[] readData = new byte[this.maxdataperread];

    public WCPWebSocketV13(String url, WCPBIOClientConn wcpConn) throws WMSCommunicationException {
        this(url, wcpConn, true);
    }

    public WCPWebSocketV13(String url, WCPBIOClientConn wcpConn, boolean tryCompression) throws WMSCommunicationException {
        try {
            this.uri = new URI(url);
            this.wcpConn = wcpConn;
            this.tryCompression = tryCompression;
            if (!this.uri.getScheme().equals("ws") && !this.uri.getScheme().equals("wss")) {
                throw new WMSCommunicationException("Invalid url");
            }
            this.isSSL = this.uri.getScheme().equals("wss");
            this.port = this.uri.getPort();
            if (this.port == -1) {
                this.port = this.isSSL ? 443 : 80;
            }
            this.host = this.uri.getHost();
        }
        catch (URISyntaxException use) {
            throw new WMSCommunicationException("Invalid Url");
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception : " + e.getMessage());
        }
    }

    @Override
    public void setHandler(WebSocketHandler callbackHandler) {
    }

    @Override
    public void addCookie(String key, String value) {
        this.cookie = this.cookie != null ? this.cookie + "; " + key + "=" + value : key + "=" + value;
    }

    @Override
    public void connect() throws WMSCommunicationException {
        if (this.conStatus != 0) {
            return;
        }
        if (this.host == null) {
            throw new WMSCommunicationException("Invalid host " + this.host);
        }
        if (this.port < 0) {
            throw new WMSCommunicationException("Invalid port " + this.port);
        }
        this.readThread = new ReadThread();
        this.readThread.start();
    }

    public boolean isOpen() {
        return this.conStatus == 1;
    }

    private boolean isHold() {
        return this.conStatus == 2;
    }

    @Override
    public boolean write(String msg) throws WMSCommunicationException {
        return true;
    }

    @Override
    public boolean writeBinary(byte[] data) throws WMSCommunicationException {
        return true;
    }

    @Override
    public void hold() {
        if (this.isOpen()) {
            this.hold_set = true;
        }
    }

    @Override
    public void resume() {
        if (this.isHold()) {
            this.resume_set = true;
        }
    }

    @Override
    public void close() {
        this.close_set = true;
    }

    private void doConnect() throws WMSCommunicationException {
        boolean isConnException = true;
        try {
            if (this.isSSL) {
                SSLContext sslCtx = SSLContext.getInstance("TLS");
                sslCtx.init(null, null, null);
                this.socket = sslCtx.getSocketFactory().createSocket(this.host, this.port);
            } else {
                this.socket = new Socket(this.host, this.port);
            }
            this.in = this.socket.getInputStream();
            this.out = this.socket.getOutputStream();
            isConnException = false;
        }
        catch (UnknownHostException uhe) {
            throw new WMSCommunicationException("Invalid Host : " + uhe);
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IO Exception : " + ioe);
        }
        catch (SecurityException se) {
            throw new WMSCommunicationException("Secruity Exception : " + se);
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception : " + e.getMessage());
        }
        finally {
            this.isConnectException = isConnException;
        }
    }

    private void doHandshake() throws WMSCommunicationException {
        try {
            ArrayList<String> responseHeader;
            block31: {
                this.headerBuffer.clear();
                String path = this.uri.getPath();
                if (path == null) {
                    path = "/";
                } else if (this.uri.getQuery() != null) {
                    path = path + "?" + this.uri.getRawQuery();
                }
                this.headerBuffer.put("GET " + path + " HTTP/1.1" + newline);
                this.appendHeaderValue("Host", this.host);
                this.appendHeaderValue("Upgrade", "websocket");
                this.appendHeaderValue("Connection", "Upgrade");
                this.appendHeaderValue("Sec-WebSocket-Version", "" + version);
                this.appendHeaderValue("Sec-WebSocket-Key", Base64.encodeByte(this.getRandomBytes(16)));
                if (this.tryCompression) {
                    this.appendHeaderValue("sec-websocket-extensions", "permessage-deflate");
                }
                Enumeration en = this.headers.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    this.appendHeaderValue(key, (String)this.headers.get(key));
                }
                if (this.cookie != null) {
                    this.appendHeaderValue("Cookie", this.cookie);
                }
                this.headerBuffer.put(newline);
                this.headerBuffer.flip();
                this.writeBytes(this.headerBuffer.toString().getBytes("UTF-8"));
                int maxLen = 1024;
                byte[] buffer = new byte[maxLen];
                int pos = 0;
                responseHeader = new ArrayList<String>();
                do {
                    byte b = this.readByte();
                    buffer[pos] = b;
                    if (buffer[++pos - 1] == 10 && buffer[pos - 2] == 13) {
                        String line = new String(buffer, "UTF-8");
                        if (line.trim().equals("")) break block31;
                        responseHeader.add(line.trim());
                        buffer = new byte[maxLen];
                        pos = 0;
                    }
                    if (pos < 1020) continue;
                    throw new WMSCommunicationException("Header too long : " + new String(buffer, "UTF-8"));
                } while (responseHeader.size() <= 10);
                throw new WMSCommunicationException("Too many headers : " + responseHeader);
            }
            if (responseHeader.size() == 0) {
                throw new WMSCommunicationException("Insuffcient response header");
            }
            String responseStatus = (String)responseHeader.remove(0);
            try {
                HashMap<String, String> responseHeaderMap = new HashMap<String, String>();
                for (String line : responseHeader) {
                    String[] keyValue = line.split(": ", 2);
                    responseHeaderMap.put(keyValue[0].toLowerCase(), keyValue[1]);
                }
                if (responseHeaderMap.containsKey("x-wcp-failed-status")) {
                    logger.log(Level.SEVERE, "WCPERR--> Security Failed. error code:{0} remoteip={1} poolName={2} apiname={3} prd={4}", new Object[]{responseHeaderMap.get("x-wcp-failed-status"), this.wcpConn.getRemoteIP(), this.wcpConn.getPoolName(), this.wcpConn.getApiname(), this.wcpConn.getPrd()});
                    WCPStats.addWCPErrorStats("WCPBIOCLientConn.poll", this.wcpConn.getApiname(), this.wcpConn.getPrd(), this.wcpConn.getPoolName(), "[WCP_SECURITY_FAILED][Error Code : " + (String)responseHeaderMap.get("x-wcp-failed-status") + "]");
                }
                if (responseHeaderMap.containsKey("x-wcp-accesstoken-verification-status")) {
                    int accessTokenStatus = Integer.parseInt((String)responseHeaderMap.get("x-wcp-accesstoken-verification-status"));
                    switch (accessTokenStatus) {
                        case 0: {
                            logger.info("HB--> WCP accessToken veified successfully. remoteIp=" + this.wcpConn.getRemoteIP() + " poolName=" + this.wcpConn.getPoolName() + " apiName=" + this.wcpConn.getApiname() + " prd=" + this.wcpConn.getPrd() + " accessTokenStatus=" + accessTokenStatus);
                            break;
                        }
                        case 1: {
                            throw new WMSCommunicationException("WCP accessToken verification failed. remoteIp=" + this.wcpConn.getRemoteIP() + " apiName=" + this.wcpConn.getApiname() + " prd=" + this.wcpConn.getPrd() + " poolName=" + this.wcpConn.getPoolName());
                        }
                        case 2: {
                            WCPConfManager.updateAccessToken(this.wcpConn.getApiname());
                            throw new WMSCommunicationException("WCP accessToken expired. remoteIp=" + this.wcpConn.getRemoteIP() + " apiName=" + this.wcpConn.getApiname() + " prd=" + this.wcpConn.getPrd() + " poolName=" + this.wcpConn.getPoolName());
                        }
                        default: {
                            throw new WMSCommunicationException("Invalid accessToken statusCode:" + accessTokenStatus + "  remoteIp=" + this.wcpConn.getRemoteIP() + " apiName=" + this.wcpConn.getApiname() + " prd=" + this.wcpConn.getPrd() + " poolName=" + this.wcpConn.getPoolName());
                        }
                    }
                }
                try {
                    int responseStatusCode = Integer.parseInt(responseStatus.substring(9, 12));
                    if (responseStatusCode != 101) {
                        throw new WMSCommunicationException("Invalid status code : " + responseStatusCode);
                    }
                }
                catch (WMSCommunicationException wce1) {
                    throw wce1;
                }
                catch (Exception e1) {
                    throw new WMSCommunicationException("Invalid Status message in response");
                }
                if (!((String)responseHeaderMap.get("upgrade")).toLowerCase().equals("websocket") || !((String)responseHeaderMap.get("connection")).toLowerCase().equals("upgrade")) {
                    throw new WMSCommunicationException("Headers on upgrade not found");
                }
                if (responseHeaderMap.get("sec-websocket-extensions") != null && ((String)responseHeaderMap.get("sec-websocket-extensions")).trim().equals("permessage-deflate")) {
                    this.isCompressionEnabled = true;
                    this.inflater = new Inflater(true);
                    this.deflater = new Deflater(9, true);
                }
                if (responseHeaderMap.containsKey("x-wcp-initialised") && "false".equals(responseHeaderMap.get("x-wcp-initialised"))) {
                    throw new WMSCommunicationException("WCPDispatcher is not initialised");
                }
            }
            catch (WMSCommunicationException wce2) {
                throw wce2;
            }
            catch (Exception e2) {
                throw new WMSCommunicationException("Unable to verify response header : " + e2.getMessage());
            }
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException : " + ioe.getMessage());
        }
        catch (Exception e) {
            throw new WMSCommunicationException("Exception doHandshake : " + e.getMessage());
        }
    }

    private void appendHeaderValue(String name, String value) {
        this.headerBuffer.put(name);
        this.headerBuffer.put(": ");
        this.headerBuffer.put(value);
        this.headerBuffer.put(newline);
    }

    private synchronized void handleClose() {
        if (this.closed) {
            return;
        }
        this.closed = true;
        try {
            if (this.deflater != null) {
                this.deflater.end();
            }
            if (this.inflater != null) {
                this.inflater.end();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Thread.currentThread() != this.readThread) {
                this.readThread.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (Thread.currentThread() != this.writeThread) {
                this.writeThread.interrupt();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.in.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.out.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (Exception exception) {
        }
        finally {
            this.readThread = null;
            this.writeThread = null;
            this.socket = null;
        }
        this.wcpConn.onClose();
        this.wcpConn = null;
    }

    private byte readByte() throws WMSCommunicationException {
        try {
            byte[] data = new byte[1];
            if (this.in.read(data) == -1) {
                throw new WMSCommunicationException("Stream Closed");
            }
            return data[0];
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "While ReadByte", ioe);
            throw new WMSCommunicationException("IOException on read");
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
    }

    private int readByte(byte[] data, int offset, int len) throws WMSCommunicationException {
        try {
            int bytesRead = this.in.read(data, offset, len);
            if (bytesRead == -1) {
                throw new WMSCommunicationException("Stream Closed");
            }
            return bytesRead;
        }
        catch (IOException ioe) {
            throw new WMSCommunicationException("IOException on read");
        }
        catch (WMSCommunicationException wce) {
            throw wce;
        }
    }

    private void writeBytes(byte[] data) throws WMSCommunicationException {
        try {
            this.out.write(data);
            this.out.flush();
        }
        catch (IOException ioe) {
            logger.log(Level.SEVERE, "While WriteByte", ioe);
            throw new WMSCommunicationException("IOException on write");
        }
    }

    private byte[] inflate(byte[] data) throws IOException, DataFormatException {
        int count;
        ByteBuffer bb = ByteBuffer.allocate(data.length + 4);
        bb.put(data);
        bb.put(new byte[]{0, 0, -1, -1});
        data = bb.array();
        this.inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while ((count = this.inflater.inflate(buffer, 0, buffer.length)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        return output;
    }

    private byte[] deflate(byte[] data) throws IOException {
        int count;
        this.deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while ((count = this.deflater.deflate(buffer, 0, buffer.length, 2)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        ByteBuffer bb = ByteBuffer.allocate(output.length - 4);
        bb.put(output, 0, output.length - 4);
        output = bb.array();
        return output;
    }

    private byte[] getRandomBytes(int len) {
        byte[] rb = new byte[len];
        this.random.nextBytes(rb);
        return rb;
    }

    protected int getConnectionStaus() {
        return this.conStatus;
    }

    protected boolean isConnectException() {
        return this.isConnectException;
    }

    public void interruptWriteThread() {
        this.writeThread.interrupt();
    }

    public static class Status {
        public static final int HOLD = 2;
        public static final int CONNECTED = 1;
        public static final int NOT_CONNECTED = 0;
        public static final int CLOSED = -1;
        public static final int ABORTED = -2;
        public static final int ERROR = -3;
    }

    static class OPCode {
        public static final int CONTINUATION = 0;
        public static final int TEXT = 1;
        public static final int BINARY = 2;
        public static final int CLOSE = 8;
        public static final int PING = 9;
        public static final int PONG = 10;

        OPCode() {
        }
    }

    class WriteFrame {
        private byte opcode;
        private byte[] data;

        public WriteFrame(int opcode, String strData) throws WMSCommunicationException {
            this(opcode, strData, true);
        }

        public WriteFrame(int opcode, String strData, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(strData.getBytes("UTF-8"), mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public WriteFrame(int opcode, byte[] data) throws WMSCommunicationException {
            this(opcode, data, true);
        }

        public WriteFrame(int opcode, byte[] data, boolean mask) throws WMSCommunicationException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(data, mask);
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public byte[] getBytes() {
            return this.data;
        }

        private byte[] prepareFrame(byte[] rawData, boolean mask) throws WMSCommunicationException {
            try {
                byte[] b;
                ByteArrayOutputStream wf = new ByteArrayOutputStream(rawData.length + 10);
                if (WCPWebSocketV13.this.isCompressionEnabled) {
                    wf.write((byte)(0xC0 | this.opcode));
                    rawData = rawData.length == 0 ? rawData : WCPWebSocketV13.this.deflate(rawData);
                } else {
                    wf.write((byte)(0x80 | this.opcode));
                }
                int length = rawData.length;
                int lf = 0;
                if (length < 126) {
                    lf = length;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                } else if (length <= 65535) {
                    lf = 126;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 8), (byte)(length & 0xFF)};
                    wf.write(b);
                } else if (length > 65535) {
                    lf = 127;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 56), (byte)(length >>> 48), (byte)(length >>> 40), (byte)(length >>> 32), (byte)(length >>> 24), (byte)(length >>> 16), (byte)(length >>> 8), (byte)length};
                    wf.write(b);
                }
                if (mask) {
                    byte[] maskValue = WCPWebSocketV13.this.getRandomBytes(4);
                    wf.write(maskValue);
                    for (int i = 0; i < rawData.length; ++i) {
                        int n = i;
                        rawData[n] = (byte)(rawData[n] ^ maskValue[i % 4]);
                    }
                }
                wf.write(rawData);
                return wf.toByteArray();
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }
    }

    class ReadFrame {
        private int payloadSize = -1;
        private ByteArrayOutputStream baos;
        byte[] data;
        private int opcode = 0;
        private boolean finSet = true;
        private boolean isCompressed = false;

        ReadFrame() {
        }

        public int readFully() throws WMSCommunicationException {
            try {
                byte header = WCPWebSocketV13.this.readByte();
                this.finSet = (header >> 7 & 1) == 1;
                boolean rsv1 = (header & 0x40) != 0;
                boolean ctrl = (header & 8) != 0;
                this.isCompressed = this.finSet && !ctrl && rsv1;
                this.opcode = header & 0xF;
                if (this.opcode == 8) {
                    return 0;
                }
                byte plen = WCPWebSocketV13.this.readByte();
                if (plen > 0 && plen < 126) {
                    this.payloadSize = plen;
                } else if (plen == 126) {
                    this.payloadSize = (int)this.readSize(2);
                } else if (plen == 127) {
                    this.payloadSize = (int)this.readSize(8);
                }
                if (this.payloadSize < 1) {
                    return 0;
                }
                this.baos = new ByteArrayOutputStream(this.payloadSize);
                if (this.payloadSize <= WCPWebSocketV13.this.maxdataperread) {
                    this.readAndWriteInBAOS(this.payloadSize);
                } else {
                    for (int sizeRemaining = this.payloadSize; sizeRemaining > 0; sizeRemaining -= WCPWebSocketV13.this.maxdataperread) {
                        if (sizeRemaining < WCPWebSocketV13.this.maxdataperread) {
                            this.readAndWriteInBAOS(sizeRemaining);
                            continue;
                        }
                        this.readAndWriteInBAOS(WCPWebSocketV13.this.maxdataperread);
                    }
                }
                if (this.baos.size() != this.payloadSize) {
                    throw new WMSCommunicationException("Corrupted Stream");
                }
                this.data = this.isCompressed && WCPWebSocketV13.this.isCompressionEnabled ? WCPWebSocketV13.this.inflate(this.baos.toByteArray()) : this.baos.toByteArray();
                return this.payloadSize;
            }
            catch (WMSCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Read Frame Failed", e);
                throw new WMSCommunicationException("Exception : " + e.getMessage());
            }
        }

        private void readAndWriteInBAOS(int size) throws WMSCommunicationException, IOException {
            int bytesRead;
            int offset = 0;
            for (int remainingSize = size; remainingSize > 0; remainingSize -= bytesRead) {
                bytesRead = WCPWebSocketV13.this.readByte(WCPWebSocketV13.this.readData, offset, remainingSize);
                offset += bytesRead;
            }
            if (size < WCPWebSocketV13.this.maxdataperread) {
                byte[] unfilledData = Arrays.copyOf(WCPWebSocketV13.this.readData, size);
                this.baos.write(unfilledData);
            } else {
                this.baos.write(WCPWebSocketV13.this.readData);
            }
        }

        public boolean isSingleFrame() {
            return this.finSet;
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }

        public boolean isTextFrame() {
            return this.opcode == 1;
        }

        public String getText() throws WMSCommunicationException {
            try {
                return new String(this.data, "UTF-8");
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to get text : " + e.getMessage());
            }
        }

        public byte[] getData() throws WMSCommunicationException {
            try {
                return this.data;
            }
            catch (Exception e) {
                throw new WMSCommunicationException("Unable to get text : " + e.getMessage());
            }
        }

        private long readSize(int len) throws WMSCommunicationException {
            long size = 0L;
            for (int i = 0; i < len; ++i) {
                size = size << 8 | (long)(WCPWebSocketV13.this.readByte() & 0xFF);
            }
            return size;
        }

        public void clear() {
            this.baos = null;
        }
    }

    class WriteThread
    extends Thread {
        private long lastPingTime = 0L;

        public WriteThread() {
            this.setName("WCP/" + WCPWebSocketV13.this.wcpConn.getPoolName() + "-" + WCPWebSocketV13.this.wcpConn.getPrd() + "-" + WCPWebSocketV13.this.wcpConn.getRemoteIP() + "-" + WCPWebSocketV13.this.wcpConn.getSID() + "-" + "write_thread");
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            while (!WCPWebSocketV13.this.closed) {
                byte[] data = null;
                WriteFrame wf = null;
                try {
                    try {
                        if (WCPWebSocketV13.this.hold_set) {
                            wf = new WriteFrame(2, ".");
                            WCPWebSocketV13.this.conStatus = 2;
                            WCPWebSocketV13.this.hold_set = false;
                        } else if (WCPWebSocketV13.this.resume_set) {
                            wf = new WriteFrame(2, ",");
                            WCPWebSocketV13.this.conStatus = 1;
                            WCPWebSocketV13.this.resume_set = false;
                        } else if (WCPWebSocketV13.this.close_set) {
                            wf = new WriteFrame(8, "");
                            WCPWebSocketV13.this.close_set = false;
                        } else {
                            data = WCPWebSocketV13.this.wcpConn.poll(pingInterval * 1000L);
                            if (data != null) {
                                wf = new WriteFrame(2, data);
                            }
                        }
                    }
                    catch (Exception ex) {
                        logger.warning("[Exception - creating new WriteFrame][" + ex.getMessage() + "]");
                    }
                    if (wf == null && !WCPWebSocketV13.this.isHold()) {
                        if (System.currentTimeMillis() - this.lastPingTime <= pingInterval * 1000L) continue;
                        this.lastPingTime = System.currentTimeMillis();
                        wf = new WriteFrame(2, "-");
                        WCPWebSocketV13.this.writeBytes(wf.getBytes());
                        continue;
                    }
                    if (wf == null) continue;
                    WCPWebSocketV13.this.writeBytes(wf.getBytes());
                    WCPWebSocketV13.this.wcpConn.punchWCPDataSizeStats(wf.getBytes().length, "success");
                    if (!wf.isCloseFrame()) continue;
                    WCPWebSocketV13.this.conStatus = -1;
                    try {
                        Thread.sleep(500L);
                    }
                    catch (Exception ex) {
                    }
                }
                catch (Exception e) {
                    WCPStats.addWSCloseStats("write_thread", WCPWebSocketV13.this.wcpConn.getApiname(), WCPWebSocketV13.this.wcpConn.getPrd(), WCPWebSocketV13.this.wcpConn.getPoolName(), WCPWebSocketV13.this.wcpConn.getRemoteIP(), e.getMessage(), this.getName(), System.currentTimeMillis() - startTime);
                    if (WCPWebSocketV13.this.wcpConn != null && wf != null) {
                        WCPWebSocketV13.this.wcpConn.storeFailedPacket(data, wf.getBytes().length, e);
                        WCPWebSocketV13.this.wcpConn.setCloseReason(e.getMessage());
                    }
                    WCPWebSocketV13.this.conStatus = -2;
                }
                break;
            }
            WCPWebSocketV13.this.handleClose();
        }
    }

    class ReadThread
    extends Thread {
        public ReadThread() {
            this.setName("WCP/" + WCPWebSocketV13.this.wcpConn.getPoolName() + "-" + WCPWebSocketV13.this.wcpConn.getPrd() + "-" + WCPWebSocketV13.this.wcpConn.getRemoteIP() + "-" + WCPWebSocketV13.this.wcpConn.getSID() + "-" + "read_thread");
        }

        @Override
        public void run() {
            long startTime = System.currentTimeMillis();
            try {
                WCPWebSocketV13.this.doConnect();
                WCPWebSocketV13.this.doHandshake();
                WCPWebSocketV13.this.conStatus = 1;
                WCPWebSocketV13.this.writeThread = new WriteThread();
                WCPWebSocketV13.this.writeThread.start();
                WCPWebSocketV13.this.wcpConn.onConnect();
                while (!WCPWebSocketV13.this.closed) {
                    ReadFrame rf = new ReadFrame();
                    int len = rf.readFully();
                    if (rf.isCloseFrame()) {
                        WCPWebSocketV13.this.conStatus = -1;
                        break;
                    }
                    if (len < 0) {
                        WCPWebSocketV13.this.conStatus = -3;
                        break;
                    }
                    if (len == 0) continue;
                    if (rf.isTextFrame()) {
                        WCPWebSocketV13.this.wcpConn.onMessage(rf.getData());
                    }
                    rf.clear();
                }
            }
            catch (Exception e) {
                WCPStats.addWSCloseStats("read_thread", WCPWebSocketV13.this.wcpConn.getApiname(), WCPWebSocketV13.this.wcpConn.getPrd(), WCPWebSocketV13.this.wcpConn.getPoolName(), WCPWebSocketV13.this.wcpConn.getRemoteIP(), e.getMessage(), this.getName(), System.currentTimeMillis() - startTime);
                if (WCPWebSocketV13.this.wcpConn != null) {
                    WCPWebSocketV13.this.wcpConn.setCloseReason(e.getMessage());
                }
                WCPWebSocketV13.this.conStatus = -2;
            }
            WCPWebSocketV13.this.handleClose();
        }
    }
}

