/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net.connection;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.WCPClientConnPool;
import com.adventnet.wms.common.components.net.WCPConfManager;
import com.adventnet.wms.common.components.net.WCPSessionManager;
import com.adventnet.wms.common.components.net.connection.WCPConnection;
import com.adventnet.wms.common.components.net.connection.WCPWebSocketV13;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.util.WCPConstants;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import com.adventnet.wms.common.components.net.util.WCPPacketizer;
import java.net.URLEncoder;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPBIOClientConn
extends WCPConnection {
    private Logger logger = Logger.getLogger(WCPBIOClientConn.class.getName());
    private WCPWebSocketV13 websocket;
    private String poolName = null;
    private ArrayBlockingQueue<WCPPacket> dataQueue;
    private LinkedBlockingQueue<WCPPacket> ackQueue = new LinkedBlockingQueue();
    private LinkedBlockingQueue<WCPPacket> cbResponseQueue = new LinkedBlockingQueue();
    private AtomicInteger rr_index = new AtomicInteger(0);
    private boolean manualClose = false;
    private long retryTime = -1L;
    private long recentPacketSentTime;
    private byte[] failedPacket = null;
    private boolean retryFailedPacket = false;
    private int retryFailedPacketCount = 0;
    private boolean isRedirectEnabled = false;
    private boolean isPolling = false;
    private AtomicInteger connRefusedRetryAttempt = new AtomicInteger(0);

    public WCPBIOClientConn(String prd, String apiName, String poolName, String remoteIp, String sid, WCPClientConnPool connPool, ArrayBlockingQueue<WCPPacket> bq, LinkedBlockingQueue<WCPPacket> cbResponseQueue, int connNum) throws Exception {
        super(prd, apiName, remoteIp, 0L, sid, connPool);
        this.dataQueue = bq;
        this.poolName = poolName;
        this.cbResponseQueue = cbResponseQueue;
        this.retryTime = -1L;
        this.recentPacketSentTime = System.currentTimeMillis();
        this.connect();
    }

    public void connect() throws Exception {
        this.connectionTime = System.currentTimeMillis();
        String protocol = "ws://";
        if (WCPConfManager.isSSLEnabled()) {
            protocol = "wss://";
        }
        int port = this.connPool.getPort();
        String uri = this.connPool.getURI();
        String context = this.connPool.getContext();
        String poolName = "&pname=" + this.connPool.getPoolName();
        String wcpAccessToken = WCPConfManager.getAccessToken(this.apiName, this.connPool.isCustomAuth());
        if (!CommonUtil.isEmpty(wcpAccessToken)) {
            wcpAccessToken = URLEncoder.encode(wcpAccessToken, "UTF-8");
        }
        String source = "";
        String cntx = "";
        String prdId = "";
        String accessToken = "";
        String servingMode = "&x-req-origin-servingmode=" + WCPAPIDispatcher.getServingMode(this.connPool.getApiName());
        if (wcpAccessToken != null) {
            accessToken = "&x-wcp-api-accesstoken=" + wcpAccessToken;
        }
        if (context != null) {
            cntx = "&context=" + context;
        }
        if (this.prd != null) {
            prdId = "&prd=" + this.prd;
        }
        if (this.apiName != null) {
            source = this.apiName + "-" + this.prd;
        }
        this.reason = null;
        this.websocket = new WCPWebSocketV13("" + protocol + this.remoteIp + ":" + port + uri + "?source=" + source + "&sid=" + this.sid.trim() + cntx + prdId + poolName + servingMode + accessToken, this);
        this.websocket.connect();
    }

    @Override
    public void onConnect() {
        this.connRefusedRetryAttempt.set(0);
        this.recentPacketSentTime = System.currentTimeMillis();
        this.addConnStats("conn_onconnect", "client-onconnect");
        this.logger.info("[WCP][New Client Connection Established][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
    }

    @Override
    public void onMessage(byte[] data) {
        block20: {
            if (this.retryTime != -1L) {
                this.retryTime = -1L;
            }
            try {
                WCPPacket packet = WCPPacketizer.getDataFromPacket(data);
                int packetType = packet.getPacketType();
                if (packet == null) break block20;
                block2 : switch (packetType) {
                    case 2: {
                        try {
                            int payLoadType = packet.getPayLoadType();
                            switch (payLoadType) {
                                case 1: 
                                case 7: {
                                    WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(payLoadType), "ack_received");
                                    if (packet.getNetInTime() != -1L) {
                                        WCPStats.addWCPClientRTT(this.prd, this.apiName, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(payLoadType), System.currentTimeMillis() - packet.getNetInTime());
                                        break block2;
                                    }
                                    break block20;
                                }
                                default: {
                                    WCPStats.addWCPErrorStats("WCPBIOCLientConn.onMessage", this.apiName, this.prd, this.poolName, "INVALID_ACK_PACKET_TYPE_RECEIVED_IN_CLIENT");
                                    return;
                                }
                            }
                        }
                        catch (Exception payLoadType) {
                            break;
                        }
                    }
                    case 4: {
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, "notify", "msg_received");
                        this.connPool.processWCPNotifyData(this.remoteIp, packet);
                        this.sendAck(packet.getPacketId(), 4);
                        break;
                    }
                    case 3: {
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, "meta", "msg_received");
                        this.connPool.processWCPMetaData(this.remoteIp, packet);
                        this.sendAck(packet.getPacketId(), 3);
                        break;
                    }
                    case 14: {
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, "cb-request", "msg_received");
                        WCPSessionManager.handleWCPCBRequest(this.poolName, this.prd, this.remoteIp, packet.getHeaderAsTable(), this.sid, packet.getPayLoadData());
                        this.sendAck(packet.getPacketId(), 14);
                        break;
                    }
                    case 8: {
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, "response", "msg_received");
                        String id = packet.getHeaderAsTable().get("reqid");
                        this.connPool.receiveResponse(id, packet);
                        this.sendAck(packet.getPacketId(), 8);
                        break;
                    }
                    case 5: {
                        if (packet.getPayLoadType() == 5) {
                            this.connPool.createConnection(packet.getHeader("redirectip"));
                            this.logger.info("ARBINFO--> REDIRECT poolName=" + this.poolName + " rediectIp=" + packet.getHeader("redirectip") + " currentIp=" + this.remoteIp + " sid=" + this.sid);
                            this.isRedirectEnabled = true;
                        } else if (packet.getPayLoadType() == 6) {
                            this.connPool.createConnection(packet.getHeader("redirectip"));
                            this.logger.info("ARBINFO--> ADDCONN poolName=" + this.poolName + " rediectIp=" + packet.getHeader("redirectip") + " currentIp=" + this.remoteIp + " sid=" + this.sid);
                        }
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, "control", "msg_received");
                        this.sendAck(packet.getPacketId(), 5);
                        break;
                    }
                    default: {
                        throw new Exception("Invalid PacketType = " + packetType);
                    }
                }
            }
            catch (Exception ex) {
                WCPStats.addWCPErrorStats("WCPBIOCLientConn.onMessage", this.apiName, this.prd, this.poolName, ex.getMessage());
                this.logger.log(Level.SEVERE, "WCPERR--> [" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]", ex);
            }
        }
    }

    public byte[] poll(long time) {
        WCPPacket packet = null;
        try {
            packet = this.ackQueue.poll();
            if (packet != null) {
                this.recentPacketSentTime = System.currentTimeMillis();
                int payLoadType = packet.getPayLoadType();
                switch (payLoadType) {
                    case 3: 
                    case 4: 
                    case 5: 
                    case 8: 
                    case 14: {
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(payLoadType), "ack_sent");
                        break;
                    }
                    default: {
                        WCPStats.addWCPErrorStats("WCPBIOCLientConn.poll", this.apiName, this.prd, this.poolName, "INVALID_ACK_PACKET_TYPE_SENT_FROM_CLIENT");
                        return null;
                    }
                }
                return packet.getCompletePacketData();
            }
            if (this.retryFailedPacket && this.failedPacket != null) {
                byte[] data = this.failedPacket;
                this.retryFailedPacket = false;
                this.failedPacket = null;
                this.logger.info("[WCPBIOClientConn - Retrying FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
                return data;
            }
            this.retryFailedPacketCount = 0;
            if (this.manualClose) {
                this.websocket.close();
                return null;
            }
            if (this.dataQueue.isEmpty() || this.rr_index.get() % 2 == 0) {
                packet = this.cbResponseQueue.poll();
            }
            if (this.isRedirectEnabled && this.cbResponseQueue.size() == 0 && this.ackQueue.size() == 0) {
                Thread.sleep(2000L);
            }
            if (!this.isRedirectEnabled && packet == null) {
                this.isPolling = true;
                packet = this.dataQueue.poll(time, TimeUnit.MILLISECONDS);
                this.isPolling = false;
            }
            if (packet != null) {
                this.rr_index.incrementAndGet();
                long currTime = System.currentTimeMillis();
                long pcktId = this.packetId.incrementAndGet();
                packet.addHeader("x-bq-intime", Long.toString(currTime - packet.getQueueInTime()));
                packet.setPacketId(pcktId);
                packet.setQTime(System.currentTimeMillis() - packet.getQueueInTime());
                this.recentPacketSentTime = System.currentTimeMillis();
                packet.addHeader("time", Long.toString(currTime));
                packet.setNetInTime(System.currentTimeMillis());
                int packetType = packet.getPacketType();
                switch (packetType) {
                    case 1: 
                    case 15: {
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, WCPConstants.PacketType.getPacketTypeString(packetType), "msg_sent");
                        break;
                    }
                    case 7: {
                        String reqId = packet.getHeader("reqid");
                        reqId = this.poolName + "@" + this.remoteIp + "@" + this.sid + "@" + reqId;
                        packet.addHeader("reqid", reqId);
                        this.connPool.setRemoteip(reqId, this.remoteIp);
                        WCPStats.addWCPClientData(this.prd, this.apiName, this.poolName, this.remoteIp, "request", "msg_sent");
                        break;
                    }
                    default: {
                        WCPStats.addWCPErrorStats("WCPBIOCLientConn.Poll", this.apiName, this.prd, this.poolName, "INVALID_PACKET_TYPE_SENT_FROM_CLIENT");
                        return null;
                    }
                }
                return packet.getCompletePacketData();
            }
            if (packet == null) {
                if (this.isRedirectEnabled && System.currentTimeMillis() - this.recentPacketSentTime > 30000L) {
                    this.logger.info("HB--> ARB Close. queueSize=" + this.dataQueue.size() + " connectionCount=" + this.connPool.getConnectionCount() + " sid=" + this.sid);
                    this.reason = "ConnIdle";
                    this.close();
                }
                if (System.currentTimeMillis() - this.recentPacketSentTime > WCPConfManager.getWCPMaxConnIdelTime() && !this.connPool.isLastConnection() && !this.connPool.isLastConnection()) {
                    this.logger.info("HB--> Idle Connection CLose. queueSize=" + this.dataQueue.size() + " connectionCount=" + this.connPool.getConnectionCount() + " sid=" + this.sid + " isARBClose=" + this.isRedirectEnabled);
                    this.reason = "ConnIdle";
                    this.close();
                }
            }
        }
        catch (InterruptedException currTime) {
        }
        catch (Exception ex) {
            WCPStats.addWCPErrorStats("WCPBIOCLientConn.Poll", this.apiName, this.prd, this.poolName, ex.getMessage());
            this.logger.log(Level.SEVERE, "WCPERR-- Error inside poll [" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]", ex);
        }
        return null;
    }

    @Override
    public void onClose() {
        block10: {
            try {
                this.addConnStats("conn_onclose", this.reason);
                if (this.retryTime == -1L) {
                    this.retryTime = System.currentTimeMillis();
                }
                if (this.websocket.isConnectException()) {
                    this.connRefusedRetryAttempt.incrementAndGet();
                }
                if (this.connRefusedRetryAttempt.get() >= 3 && !this.connPool.isDomainBased()) {
                    this.connPool.addConnRefusedIP(this.remoteIp);
                    this.connPool.removeConnFromPool(this.remoteIp, this.sid);
                    break block10;
                }
                if (!this.manualClose && System.currentTimeMillis() - this.retryTime < WCPConfManager.getWCPMaxRetryTime()) {
                    try {
                        try {
                            Thread.sleep(5000L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.logger.info("[WCPBIOClientConn - Reconnecting][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "]");
                        WCPStats.addWCPConnReconnect(this.prd, this.apiName, this.poolName, this.remoteIp, this.sid);
                        this.connect();
                    }
                    catch (Exception exception) {}
                    break block10;
                }
                this.connPool.removeConnFromPool(this.remoteIp, this.sid);
            }
            catch (Exception ex) {
                this.logger.log(Level.SEVERE, "WCPBIOClientConn - onClose poolName=" + this.getPoolName() + " ip=" + this.getRemoteIP(), ex);
            }
        }
    }

    @Override
    public void close() throws Exception {
        this.manualClose = true;
    }

    public String getPoolName() {
        return this.poolName;
    }

    public int getConnectionStatus() {
        return this.websocket.getConnectionStaus();
    }

    @Override
    public boolean isAlive() {
        return this.websocket.isOpen();
    }

    public void sendAck(long packetId, int packetType) throws Exception {
        WCPPacket ackPacket = WCPPacketizer.getPacketFromData(packetId, 2, packetType);
        this.ackQueue.put(ackPacket);
    }

    public void storeFailedPacket(byte[] data, long actual_size, Exception ex) {
        if (this.retryFailedPacketCount >= 3) {
            this.logger.info("[Exception][WCPBIOClientConn - WebSocketV13][Dropping FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + ex.getMessage() + "][" + data.length + "]");
            WCPStats.addWCPDataSizeStats(this.prd, this.apiName, this.poolName, this.remoteIp, "drop", actual_size);
            this.retryFailedPacket = false;
            this.failedPacket = null;
            this.retryFailedPacketCount = 0;
            return;
        }
        this.logger.info("[Exception][WCPBIOClientConn - WebSocketV13][Storing FailedPacket][" + this.poolName + "][" + this.remoteIp + "][" + this.sid + "][" + ex.getMessage() + "]");
        WCPStats.addWCPDataSizeStats(this.prd, this.apiName, this.poolName, this.remoteIp, "failure", actual_size);
        this.failedPacket = data;
        this.retryFailedPacket = true;
        ++this.retryFailedPacketCount;
    }

    public void punchWCPDataSizeStats(long size, String status) {
        WCPStats.addWCPDataSizeStats(this.prd, this.apiName, this.poolName, this.remoteIp, status, size);
    }

    public void addCBResponsePacket(WCPPacket packet) {
        this.cbResponseQueue.add(packet);
    }

    @Override
    public void interruptWriteThread() {
        if (this.isPolling) {
            this.websocket.interruptWriteThread();
        }
    }
}

