/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common.components.net;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.components.net.WCPAPIDispatcher;
import com.adventnet.wms.common.components.net.WCPClientConnPoolConfig;
import com.adventnet.wms.common.components.net.callback.WCPCBMetaHandler;
import com.adventnet.wms.common.components.net.callback.WCPCBNotifyHandler;
import com.adventnet.wms.common.components.net.callback.WCPResponseCBListener;
import com.adventnet.wms.common.components.net.callback.WCPResponseHandler;
import com.adventnet.wms.common.components.net.connection.WCPBIOClientConn;
import com.adventnet.wms.common.components.net.connection.WCPConnection;
import com.adventnet.wms.common.components.net.servlet.WCPFuture;
import com.adventnet.wms.common.components.net.servlet.WCPRequest;
import com.adventnet.wms.common.components.net.servlet.WCPResponse;
import com.adventnet.wms.common.components.net.stats.WCPStats;
import com.adventnet.wms.common.components.net.timeoutlistener.WCPReqTimeOutListener;
import com.adventnet.wms.common.components.net.util.WCPAdminUtil;
import com.adventnet.wms.common.components.net.util.WCPPacket;
import com.adventnet.wms.common.components.net.util.WCPPacketizer;
import com.adventnet.wms.common.components.net.util.WCPSessionIDGenerator;
import com.adventnet.wms.common.components.net.util.WCPUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.logging.Level;
import java.util.logging.Logger;

public class WCPClientConnPool {
    private static Logger logger = Logger.getLogger(WCPClientConnPool.class.getName());
    private List<String> seedsList;
    private Hashtable<String, String> ipSidMap;
    private Hashtable<String, WCPConnection> sidConnMap;
    private long maxRatePerConn = -1L;
    private WCPCBMetaHandler metaHandler;
    private WCPCBNotifyHandler notifyHandler;
    private WCPResponseHandler responseHandler;
    private Hashtable<String, LinkedBlockingQueue<WCPPacket>> cbResposeQueue;
    private int connCount = 0;
    private String poolName = null;
    private String prd = null;
    private String apiName = null;
    private String context = null;
    private String uri = null;
    private String domain = null;
    private boolean isDomainBased = false;
    private boolean isCustomAuth = false;
    private int port = 0;
    private int maxDataPerConn = 0;
    private Hashtable<String, WCPFuture> wcpRequestMap;
    private AtomicLong wcpRequestId = new AtomicLong(0L);
    private ArrayBlockingQueue<WCPPacket> dataQueue;
    private AtomicLong bqRate;
    private WCPClientConnPoolConfig conf = null;
    private Map<String, Long> connRefusedIPS = new Hashtable<String, Long>();
    private ArrayList<String> domainSidList;

    public WCPClientConnPool(String poolName, List<String> seedsList, String context, String prd, String apiName, int ipQueueSize, int newConnThreshold, String uri, int port, int maxDataPerConn, int maxDataAddRetryCount) throws Exception {
        this.prd = prd;
        this.uri = uri;
        this.context = context;
        this.apiName = apiName;
        this.poolName = poolName;
        this.seedsList = seedsList;
        this.port = port;
        this.maxDataPerConn = newConnThreshold * ipQueueSize / 100;
        this.bqRate = new AtomicLong();
        this.dataQueue = new ArrayBlockingQueue(ipQueueSize);
        this.ipSidMap = new Hashtable();
        this.sidConnMap = new Hashtable();
        this.wcpRequestMap = new Hashtable();
        this.cbResposeQueue = new Hashtable();
        this.domainSidList = new ArrayList();
        this.metaHandler = new WCPCBMetaHandler(this);
        this.metaHandler.start();
        this.notifyHandler = new WCPCBNotifyHandler(this, ipQueueSize);
        this.responseHandler = new WCPResponseHandler(this, ipQueueSize);
        logger.info("[WCP - New WCPConnPool Created] poolname=" + this.poolName + " seedsMap=" + this.seedsList + " context=" + context + " api=" + this.apiName + " prd=" + this.prd + " port=" + this.port);
    }

    public WCPClientConnPool(WCPClientConnPoolConfig conf) throws Exception {
        this.conf = conf;
        conf.setConnPool(this);
        this.prd = conf.getPrd();
        this.uri = conf.getUri();
        this.context = conf.getContext();
        this.apiName = conf.getApiName();
        this.poolName = conf.getPoolName();
        this.seedsList = conf.getSeeds();
        this.domain = conf.getDomain();
        this.port = conf.getPort();
        this.maxDataPerConn = conf.getNewConnThreshold() * conf.getIpQueueSize() / 100;
        this.bqRate = new AtomicLong();
        this.isDomainBased = conf.isDomainBased();
        this.isCustomAuth = conf.isCustomAuth();
        this.dataQueue = new ArrayBlockingQueue(conf.getIpQueueSize());
        this.ipSidMap = new Hashtable();
        this.sidConnMap = new Hashtable();
        this.wcpRequestMap = new Hashtable();
        this.cbResposeQueue = new Hashtable();
        this.domainSidList = new ArrayList();
        this.metaHandler = new WCPCBMetaHandler(this);
        this.metaHandler.start();
        this.notifyHandler = new WCPCBNotifyHandler(this, conf.getIpQueueSize());
        this.responseHandler = new WCPResponseHandler(this, conf.getIpQueueSize());
        this.setNotifyHandlerPoolSize();
        this.setResponseHandlerPoolSize();
        if (this.isDomainBased) {
            this.createConnections();
        }
        logger.info("[WCP - New WCPConnPool Created] poolname=" + this.poolName + " seedsMap=" + this.seedsList + " context=" + this.context + " api=" + this.apiName + " prd=" + this.prd + " port=" + this.port + " domain=" + this.domain + " isDomainBased=" + this.isDomainBased);
    }

    public WCPClientConnPoolConfig getConnPoolConfig() {
        return this.conf;
    }

    public boolean isDomainBased() {
        return this.isDomainBased;
    }

    public boolean isCustomAuth() {
        return this.isCustomAuth;
    }

    public synchronized void setResponseHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.responseHandler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public synchronized void setNotifyHandlerPoolSize(int corePoolSize, int maximumPoolSize) {
        this.notifyHandler.setPoolSize(corePoolSize, maximumPoolSize);
    }

    public synchronized void setResponseHandlerPoolSize() {
        this.responseHandler.setPoolSize(this.conf.getResponseCorePoolSize(), this.conf.getResponseMaximumPoolSize());
    }

    public synchronized void setNotifyHandlerPoolSize() {
        this.notifyHandler.setPoolSize(this.conf.getNotifyCorePoolSize(), this.conf.getNotifyMaximumPoolSize());
    }

    public long getResponseHandlerQueueSize() {
        return this.responseHandler.getQueueSize();
    }

    public void manageConnections(List<String> newSeeds) throws Exception {
        logger.info("HB--> receivedSeeds. newSeeds=" + newSeeds);
        List<String> removedIps = this.getRemovedIpsList(newSeeds, this.ipSidMap);
        for (String removedIp : removedIps) {
            logger.info("HB--> closing unapprovedConnection. ip=" + removedIp + " sid=" + this.ipSidMap.get(removedIp));
            this.closeUnapprovedConns(this.ipSidMap.get(removedIp));
        }
        this.seedsList = newSeeds;
        newSeeds.size();
        this.createConnections();
        logger.info("HB--> updatedSeeds. seedsList=" + this.seedsList);
    }

    private List<String> getRemovedIpsList(List<String> newSeeds, Hashtable<String, String> ipSidMap) {
        ArrayList<String> removedIpsList = new ArrayList<String>(ipSidMap.keySet());
        removedIpsList.removeAll(newSeeds);
        return removedIpsList;
    }

    private synchronized void createConnections() throws Exception {
        if (!this.isDomainBased) {
            for (String ip : this.seedsList) {
                try {
                    logger.fine("HB--> trying to createConnection. poolName=" + this.poolName + " ip=" + ip);
                    if (this.ipSidMap.get(ip) != null || !this.createConnection(ip)) continue;
                    break;
                }
                catch (Exception exception) {
                }
            }
        } else if (this.domainSidList.size() < this.conf.getMaxConn()) {
            this.createConnection(this.domain);
        }
    }

    public synchronized boolean createConnection(String ip) throws Exception {
        boolean isConnectionMade = false;
        if (!this.isDomainBased) {
            if (!this.seedsList.contains(ip)) {
                logger.info("[WCP][createConnection] failed. Ip not available in seedsList. Ip=" + ip + " seedsList" + this.seedsList);
                return false;
            }
            if (this.ipSidMap.get(ip) != null) {
                logger.info("[WCP][createConnection] failed. Connection already present. Ip=" + ip);
                return false;
            }
            if (this.connRefusedIPS.containsKey(ip)) {
                long blockedUntil = this.connRefusedIPS.get(ip);
                if (System.currentTimeMillis() < blockedUntil) {
                    logger.info("[WCP][createConnection] Trying to connect blocked poolName=" + this.poolName + " ip=" + ip + ". remainingTime=" + (blockedUntil - System.currentTimeMillis()) + "ms");
                    return false;
                }
                logger.info("[WCP][createConnection] unblocked poolName=" + this.poolName + " ip=" + ip);
                this.connRefusedIPS.remove(ip);
            }
            try {
                String sid = Long.toString(WCPSessionIDGenerator.getUniqueId());
                this.cbResposeQueue.putIfAbsent(ip, new LinkedBlockingQueue());
                WCPBIOClientConn conn = new WCPBIOClientConn(this.prd, this.apiName, this.poolName, ip, sid, this, this.dataQueue, this.cbResposeQueue.get(ip), this.connCount++);
                for (int i = 0; i < 30; ++i) {
                    int connStatus = conn.getConnectionStatus();
                    if (connStatus == 1 || connStatus == 2) {
                        isConnectionMade = true;
                        break;
                    }
                    Thread.sleep(100L);
                }
                this.ipSidMap.put(ip, sid);
                this.sidConnMap.put(sid, conn);
                logger.info("HB--> ConnectionCreated. poolName=" + this.poolName + " ip=" + ip + " connectionCount=" + this.sidConnMap.size());
            }
            catch (Exception ex) {
                WCPStats.addWCPErrorStats("WCPBIOClientConn.creation", WCPAPIDispatcher.getApiName(this.poolName), WCPAPIDispatcher.getPrd(this.poolName), this.poolName, ex.getMessage());
                logger.log(Level.SEVERE, "WCPERR--> Error while creating connection ip=" + ip + " poolanme=" + this.poolName, ex);
                throw ex;
            }
        }
        try {
            String sid = Long.toString(WCPSessionIDGenerator.getUniqueId());
            this.cbResposeQueue.putIfAbsent(this.domain, new LinkedBlockingQueue());
            WCPBIOClientConn conn = new WCPBIOClientConn(this.prd, this.apiName, this.poolName, ip, sid, this, this.dataQueue, this.cbResposeQueue.get(ip), this.connCount++);
            for (int i = 0; i < 30; ++i) {
                int connStatus = conn.getConnectionStatus();
                if (connStatus == 1 || connStatus == 2) {
                    isConnectionMade = true;
                    break;
                }
                Thread.sleep(100L);
            }
            this.domainSidList.add(sid);
            this.sidConnMap.put(sid, conn);
            logger.info("HB--> ConnectionCreated. poolName=" + this.poolName + " domain=" + this.domain + " connectionCount=" + this.sidConnMap.size());
        }
        catch (Exception ex) {
            WCPStats.addWCPErrorStats("WCPBIOClientConn.creation - domain based", WCPAPIDispatcher.getApiName(this.poolName), WCPAPIDispatcher.getPrd(this.poolName), this.poolName, ex.getMessage());
            logger.log(Level.SEVERE, "WCPERR--> Error while creating connection. domain=" + this.domain + " poolanme=" + this.poolName, ex);
            throw ex;
        }
        return isConnectionMade;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeConnFromPool(String ip, String sid) {
        try {
            Object object = WCPUtil.getObjLock(ip);
            synchronized (object) {
                if (this.sidConnMap.containsKey(sid)) {
                    if (this.isDomainBased) {
                        this.domainSidList.remove(sid);
                    } else {
                        this.ipSidMap.remove(ip);
                    }
                    this.sidConnMap.remove(sid);
                    logger.info("[WCP][Closed Connection Removed From ConnectionPool][" + this.poolName + "][" + ip + "][" + sid + "][" + this.ipSidMap + "][" + this.sidConnMap + "][" + this.domainSidList + "][" + this.isDomainBased + "][" + this.sidConnMap.size() + "]");
                }
            }
        }
        finally {
            WCPUtil.releaseObjLock(ip);
        }
    }

    private void closeUnapprovedConns(String sid) {
        if (sid != null) {
            try {
                this.closeConn(this.sidConnMap.get(sid), "UnapprovedConn");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void closeConn(WCPConnection conn, String reason) throws Exception {
        if (conn == null) {
            return;
        }
        conn.setCloseReason(reason);
        conn.close();
    }

    public void addConnRefusedIP(String ip) {
        if (!this.connRefusedIPS.containsKey(ip)) {
            logger.info("[WCP][addConnRefusedIP] ip=" + ip);
            this.connRefusedIPS.put(ip, System.currentTimeMillis() + 300000L);
        }
    }

    public void receiveResponse(String id, WCPPacket packet) {
        String[] data = id.split("@");
        String ip = data[1];
        String sid = data[2];
        String reqid = data[3];
        if (this.wcpRequestMap.get(reqid) != null) {
            try {
                if (packet != null && packet.getPacketType() == 8) {
                    this.responseHandler.putData(this.poolName, ip, packet);
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "WCPWARN--> NotifyHandler PutData reqId=" + reqid + " poolName=" + this.poolName, ex);
                WCPStats.addWCPErrorStats("NotifyHandler.putData", WCPAPIDispatcher.getApiName(this.poolName), WCPAPIDispatcher.getPrd(this.poolName), this.poolName, ex.getMessage());
            }
        } else {
            logger.warning("[WCP][No WCPFutureObject][" + this.poolName + "][" + ip + "][" + sid + "][" + reqid + "]");
        }
    }

    public WCPFuture sendRequest(WCPRequest req, WCPResponseCBListener listener) throws Exception {
        String reqId = Long.toString(this.wcpRequestId.incrementAndGet());
        Hashtable<String, String> ht = new Hashtable<String, String>();
        ht.put("reqid", reqId);
        WCPFuture future = new WCPFuture(req, null, listener, this.poolName);
        req.addHeader("x-wcp-reqid", reqId);
        req.setReqId(reqId);
        if (!CommonUtil.isEmpty(req.getRKey()) && !CommonUtil.isEmpty(req.getURI())) {
            ht.put("rkey", req.getRKey());
            ht.put("uri", req.getURI());
            ht.put("startime", System.currentTimeMillis() + "");
            ht.put("requestimeout", String.valueOf(req.getTimeOutInMillis()));
            ht.put("expirytime", String.valueOf(req.getExpiryTime()));
        }
        this.wcpRequestMap.put(reqId, future);
        WCPReqTimeOutListener.TRACKER.touch(req.getExpiryTime(), this.poolName + "@" + reqId + "@" + req.getExpiryTime());
        WCPPacket packet = WCPPacketizer.getPacketFromData(-1L, 7, 0L, ht, -1, req.getReqAsData());
        boolean result = this.sendPacket(packet);
        if (!result) {
            future = this.wcpRequestMap.remove(reqId);
            future.cancel(true);
            future = null;
        }
        return future;
    }

    public boolean sendPacket(WCPPacket packet) throws Exception {
        return this.sendPacket(packet, null);
    }

    public boolean sendPacket(WCPPacket packet, String ip) throws Exception {
        if (!this.isDomainBased && CommonUtil.isEmpty(this.seedsList)) {
            WCPAdminUtil.refreshWCPDispatcherSeedsList(this.poolName, this.apiName, this.context);
            if (CommonUtil.isEmpty(this.seedsList)) {
                WCPStats.addWCPErrorStats("SendPacket-Failed", this.apiName, this.prd, this.poolName, "SeedsEmpty");
                return false;
            }
        }
        if (this.sidConnMap.size() == 0) {
            logger.info("HB--> first connection creation. poolName=" + this.poolName);
            this.createConnections();
        }
        if (ip != null) {
            String sid;
            this.cbResposeQueue.putIfAbsent(ip, new LinkedBlockingQueue());
            this.cbResposeQueue.get(ip).add(packet);
            if (this.ipSidMap.containsKey(ip) && this.sidConnMap.containsKey(sid = this.ipSidMap.get(ip))) {
                this.sidConnMap.get(sid).interruptWriteThread();
            }
            return true;
        }
        packet.setQueueInTime(System.currentTimeMillis());
        this.dataQueue.add(packet);
        this.setBqStats();
        if (this.dataQueue.size() > this.maxDataPerConn) {
            logger.info("HB--> creating additional connection. queueSize reached maxDataPerConn. queueSize=" + this.dataQueue.size() + " poolName=" + this.poolName + "  ipSidMap=" + this.ipSidMap + " sidConnMapSize= " + this.sidConnMap);
            this.createConnections();
        }
        return true;
    }

    public void processWCPMetaData(String ip, WCPPacket packet) {
        try {
            if (packet != null && packet.getPacketType() != 1) {
                this.metaHandler.putData(this.poolName, ip, packet);
            }
        }
        catch (Exception ex) {
            WCPStats.addWCPErrorStats("processWCPMetaData", WCPAPIDispatcher.getApiName(this.poolName), WCPAPIDispatcher.getPrd(this.poolName), this.poolName, ex.getMessage());
            logger.log(Level.WARNING, "WCPWARN--> processWCPMetaData poolName=" + this.poolName + " ip=" + ip, ex);
        }
    }

    public void processWCPNotifyData(String ip, WCPPacket packet) {
        try {
            if (packet != null && packet.getPacketType() == 4) {
                this.notifyHandler.putData(this.poolName, ip, packet);
            }
        }
        catch (Exception ex) {
            WCPStats.addWCPErrorStats("processWCPNotifyData", WCPAPIDispatcher.getApiName(this.poolName), WCPAPIDispatcher.getPrd(this.poolName), this.poolName, ex.getMessage());
            logger.log(Level.WARNING, "WCPWARN--> processWCPNotifyData poolName=" + this.poolName + " ip=" + ip, ex);
        }
    }

    public String getPoolName() {
        return this.poolName;
    }

    public String getContext() {
        return this.context;
    }

    public String getPrd() {
        return this.prd;
    }

    public String getApiName() {
        return this.apiName;
    }

    public String getURI() {
        return this.uri;
    }

    public int getPort() {
        return this.port;
    }

    public List<String> getSeedList() {
        return this.seedsList;
    }

    private void setBqStats() {
        try {
            this.bqRate.incrementAndGet();
        }
        catch (Exception e) {
            logger.log(Level.FINE, "setBqStats", e);
        }
    }

    private long getBqStats() {
        try {
            return this.bqRate.getAndSet(0L);
        }
        catch (Exception exception) {
            return 0L;
        }
    }

    public long getBqRatePerMin() {
        return this.getBqStats();
    }

    public long getLiveBQSize() {
        if (this.dataQueue != null) {
            return this.dataQueue.size();
        }
        return 0L;
    }

    public Hashtable<String, Integer> getResponseQueueSize() {
        Hashtable<String, Integer> ht = new Hashtable<String, Integer>();
        if (this.cbResposeQueue != null) {
            for (String ip : this.cbResposeQueue.keySet()) {
                ht.put(ip, this.cbResposeQueue.get(ip).size());
            }
            return ht;
        }
        return ht;
    }

    public long getLiveConnCount() {
        return this.sidConnMap.size();
    }

    public void setMaxDataPerConn(int maxDataPerConn) {
        this.maxDataPerConn = maxDataPerConn;
    }

    public void setMaxDataAddRetryCount(int maxDataAddRetryCount) {
    }

    public void setMaxRatePerConn(long maxData) {
        this.maxRatePerConn = Math.max(maxData, this.maxRatePerConn);
    }

    public long getMaxRatePerConn() {
        return this.maxRatePerConn;
    }

    public void closeUnnecessaryConn(String ip) {
        try {
            this.closeConn(this.sidConnMap.get(this.ipSidMap.get(ip)), "Unnecessary Connection");
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "WCPERR--> closeUnnecessaryConn poolName=" + this.poolName + " ip=" + ip, e);
        }
    }

    public WCPFuture removeWCPFutureObj(String reqid) {
        return this.wcpRequestMap.remove(reqid);
    }

    public void invalidateWCPRequest(String reqid) {
        WCPFuture future = this.removeWCPFutureObj(reqid);
        if (future != null) {
            WCPResponse response = new WCPResponse(null, null);
            response.setResponseCode("408");
            response.setResponseStr("request_timeout");
            future.setResponse(response);
            logger.info("[WCP][WCPRequest Cancelled][" + this.poolName + "][" + future.getRequest().getURI() + "][" + future.getRequest().getRemoteIp() + "][" + reqid + "]");
            WCPStats.addWCPRequestTimeout(this.poolName, this.prd, this.apiName, future.getRequest().getRemoteIp(), future.getRequest().getURI());
        }
    }

    public boolean isValidRequest(String reqid) {
        return this.wcpRequestMap.containsKey(reqid);
    }

    public void setRemoteip(String reqId, String remoteIp) {
        try {
            if (this.wcpRequestMap.containsKey(reqId)) {
                this.wcpRequestMap.get(reqId).getRequest().setRemoteIp(remoteIp);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getConnectionCount() {
        return this.ipSidMap.size();
    }

    public boolean hasConnections() {
        boolean hasConnections = false;
        if (!CommonUtil.isEmpty(this.sidConnMap)) {
            for (String sid : this.sidConnMap.keySet()) {
                hasConnections = this.sidConnMap.get(sid).isAlive();
            }
        }
        return hasConnections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isLastConnection() {
        Hashtable<String, WCPConnection> hashtable = this.sidConnMap;
        synchronized (hashtable) {
            return this.sidConnMap.size() == 1;
        }
    }

    public int getAliveConnCount() {
        int aliveConn = 0;
        if (!CommonUtil.isEmpty(this.sidConnMap)) {
            for (String sid : this.sidConnMap.keySet()) {
                if (!this.sidConnMap.get(sid).isAlive()) continue;
                ++aliveConn;
            }
        }
        return aliveConn;
    }

    public boolean isAlive(String remoteIp) {
        boolean isAlive = false;
        if (this.ipSidMap.containsKey(remoteIp) && this.sidConnMap.containsKey(this.ipSidMap.get(remoteIp))) {
            isAlive = this.sidConnMap.get(this.ipSidMap.get(remoteIp)).isAlive();
        }
        return isAlive;
    }
}

