/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import com.adventnet.wms.common.CommonUtil;
import com.adventnet.wms.common.HttpConnection;
import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.exception.WMSCommunicationException;
import com.adventnet.wms.common.exception.WMSException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.util.Hashtable;
import java.util.logging.Logger;

public class WMSInterServerConnection
extends HttpConnection {
    private static Logger logger = Logger.getLogger(WMSInterServerConnection.class.getName());

    public WMSInterServerConnection(String url) {
        super(url);
    }

    public WMSInterServerConnection(String url, int readTimeOut) {
        super(url, readTimeOut);
    }

    public WMSInterServerConnection(String url, int readTimeOut, int connectTimeOut) {
        super(url, readTimeOut, connectTimeOut);
    }

    @Override
    public Object doPost(Hashtable params, Hashtable headers, String body) throws WMSException {
        return this.doPost(params, headers, body, null);
    }

    @Override
    public Object doPost(Hashtable params, Hashtable headers, String body, String contentType) throws WMSException {
        StringBuilder response = new StringBuilder();
        BufferedReader reader = null;
        HttpURLConnection uc = null;
        try {
            OutputStreamWriter writer;
            String paramstring;
            if (params != null) {
                this.params = params;
            }
            if (headers != null) {
                this.headers = headers;
            }
            uc = !CommonUtil.isEmpty(paramstring = this.getParamString()) ? this.openConnection(this.url + "?" + paramstring) : this.openConnection(this.url);
            uc.setReadTimeout(this.readTimeOut);
            uc.setConnectTimeout(this.connectTimeOut);
            uc.setDoInput(true);
            uc.setDoOutput(true);
            uc.setUseCaches(false);
            this.setHeaders(uc);
            if (!CommonUtil.isEmpty(body)) {
                if (!CommonUtil.isEmpty(contentType)) {
                    uc.setRequestProperty("Content-Type", contentType);
                } else {
                    uc.setRequestProperty("Content-Type", "text/html; charset=utf-8");
                }
                uc.setRequestProperty("Content-Length", "" + body.getBytes("UTF-8").length);
                writer = new OutputStreamWriter(uc.getOutputStream());
                writer.write(body);
                writer.flush();
                writer.close();
            } else {
                uc.setRequestProperty("Content-Type", "text/html; charset=utf-8");
                uc.setRequestProperty("Content-Length", "0");
                writer = new OutputStreamWriter(uc.getOutputStream());
                writer.close();
            }
            this.statuscode = uc.getResponseCode();
            reader = new BufferedReader(new InputStreamReader(uc.getInputStream(), "UTF-8"));
            String line = null;
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
        }
        catch (IOException ie) {
            if (uc != null) {
                throw new WMSCommunicationException(this.statuscode, uc.getErrorStream(), "Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
            }
            throw new WMSCommunicationException("Server not reachable - " + this.getRestrainedURL(this.url) + " - " + this.getExceptionCause(ie));
        }
        catch (Exception exp) {
            logger.fine("Communication Error : doPost : " + this.getRestrainedURL(this.url) + " : " + this.getExceptionCause(exp));
            throw new WMSException("Communication Error : doPost : {0}", this.getRestrainedURL(this.url));
        }
        finally {
            try {
                if (reader != null) {
                    reader.close();
                }
            }
            catch (Exception exception) {}
        }
        Object data = HttpDataWraper.getObject(response.toString());
        return data != null ? data : response.toString();
    }
}

