/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.logging.Logger;

public abstract class VariableTimeOutListener
extends Thread {
    private static Logger logger = Logger.getLogger(VariableTimeOutListener.class.getName());
    private final Integer PUT = new Integer(1);
    private final Integer REMOVE = new Integer(2);
    private LinkedBlockingQueue<HashMap> queue = new LinkedBlockingQueue();
    private SortedMap lru = new TreeMap(new CustomWmsComparator());
    private Tracker tracker;

    protected VariableTimeOutListener(String thdName, long interval) {
        super(thdName + "-queue");
        this.start();
        this.tracker = new Tracker(thdName + "-tracker", interval);
        this.tracker.start();
    }

    public abstract boolean isExpired(Object var1);

    public abstract boolean isInvalidEntry(Object var1, long var2);

    public abstract void handleExpired(ArrayList var1);

    public boolean isVaryingTOLEntry() {
        return true;
    }

    public void touch(long time, Object obj) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", new TimeOutReferenceObject(time, obj));
            entry.put("opr", this.PUT);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - touch");
        }
    }

    public void remove(long time, Object obj) {
        try {
            HashMap<String, Object> entry = new HashMap<String, Object>();
            entry.put("obj", new TimeOutReferenceObject(time, obj));
            entry.put("opr", this.REMOVE);
            this.queue.put(entry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - remove");
        }
    }

    public void update(long oldtime, long newtime, Object obj) {
        try {
            HashMap<String, Object> rementry = new HashMap<String, Object>();
            rementry.put("obj", new TimeOutReferenceObject(oldtime, obj));
            rementry.put("opr", this.REMOVE);
            this.queue.put(rementry);
            HashMap<String, Object> addentry = new HashMap<String, Object>();
            addentry.put("obj", new TimeOutReferenceObject(newtime, obj));
            addentry.put("opr", this.PUT);
            this.queue.put(addentry);
        }
        catch (Exception e) {
            logger.warning("Error queueing in TimeOutListener - remove");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        while (true) {
            try {
                while (true) {
                    HashMap entry = this.queue.take();
                    SortedMap sortedMap = this.lru;
                    synchronized (sortedMap) {
                        if ((Integer)entry.get("opr") == this.PUT) {
                            this.lru.put(entry.get("obj"), "");
                        } else {
                            this.lru.remove(entry.get("obj"));
                        }
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            break;
        }
    }

    private Object getReferenceObject() {
        return new TimeOutReferenceObject(System.currentTimeMillis(), Long.MAX_VALUE);
    }

    class TimeOutReferenceObject {
        private Object obj;
        private long time;

        public TimeOutReferenceObject(long time, Object obj) {
            this.time = time;
            this.obj = obj;
        }

        public long getExpireTime() {
            return this.time;
        }

        public Object getObject() {
            return this.obj;
        }

        public String toString() {
            return "Exp Time :: " + this.time + " , Object :: " + this.obj.toString();
        }
    }

    class CustomWmsComparator
    implements Comparator {
        private int a = 0;

        CustomWmsComparator() {
        }

        public int compare(Object o1, Object o2) {
            long time2;
            TimeOutReferenceObject val1 = (TimeOutReferenceObject)o1;
            TimeOutReferenceObject val2 = (TimeOutReferenceObject)o2;
            long time1 = val1.getExpireTime();
            if (time1 > (time2 = val2.getExpireTime())) {
                return 1;
            }
            if (time1 < time2) {
                return -1;
            }
            if (time1 == time2) {
                Object obj1 = val1.getObject();
                Object obj2 = val2.getObject();
                if (obj1 instanceof Long && obj2 instanceof Long) {
                    long id2;
                    long id1 = (Long)obj1;
                    if (id1 == (id2 = ((Long)obj2).longValue())) {
                        return 0;
                    }
                    return 1;
                }
                if (obj1 == obj2) {
                    return 0;
                }
                if (obj1.hashCode() == obj2.hashCode()) {
                    return 0;
                }
                if (obj1.hashCode() > obj2.hashCode()) {
                    return 1;
                }
                if (obj2.hashCode() > obj1.hashCode()) {
                    return -1;
                }
            }
            return -1;
        }

        @Override
        public boolean equals(Object obj) {
            return false;
        }
    }

    class Tracker
    extends Thread {
        private long interval;

        public Tracker(String thdName, long interval) {
            super(thdName);
            this.interval = 0L;
            this.interval = interval;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        Tracker.sleep(this.interval);
                        ArrayList<Object> expList = new ArrayList<Object>();
                        SortedMap sortedMap = VariableTimeOutListener.this.lru;
                        synchronized (sortedMap) {
                            TimeOutReferenceObject headRef = (TimeOutReferenceObject)VariableTimeOutListener.this.getReferenceObject();
                            SortedMap expiredMap = VariableTimeOutListener.this.lru.headMap(headRef);
                            Iterator<TimeOutReferenceObject> it = expiredMap.keySet().iterator();
                            while (it.hasNext()) {
                                TimeOutReferenceObject obj;
                                TimeOutReferenceObject queObj = obj = it.next();
                                try {
                                    Object expObj = queObj.getObject();
                                    if (!VariableTimeOutListener.this.isVaryingTOLEntry()) {
                                        expList.add(expObj);
                                        it.remove();
                                        continue;
                                    }
                                    if (VariableTimeOutListener.this.isExpired(expObj)) {
                                        expList.add(expObj);
                                        it.remove();
                                        continue;
                                    }
                                    if (!VariableTimeOutListener.this.isInvalidEntry(expObj, queObj.getExpireTime())) continue;
                                    it.remove();
                                }
                                catch (Exception e1) {
                                    e1.printStackTrace();
                                }
                            }
                        }
                        if (expList.size() <= 0) continue;
                        VariableTimeOutListener.this.handleExpired(expList);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

