/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.common;

import com.adventnet.wms.common.HttpDataWraper;
import com.adventnet.wms.common.SoundAlgo;
import java.util.Hashtable;

public class UnsPush {
    private static final int MAX_ALERT_LENGTH = 150;
    private static final int MAX_ADDINFO_LENGTH_COMMON = 1536;
    private static final int MAX_ADDINFO_LENGTH_IOS = 1536;
    private static final int MAX_ADDINFO_LENGTH_ANDROID = 3072;
    private Hashtable data = new Hashtable();

    public UnsPush(String msg) {
        try {
            int mlen = msg.getBytes("UTF-8").length;
            if (mlen > 150 && msg.length() > 150) {
                msg = msg.substring(0, 150) + "...";
            }
            this.data.put("msg", msg);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setReferenceID(String rfid) {
        if (rfid != null) {
            this.data.put("rfid", rfid);
        }
    }

    public String getReferenceID() {
        return (String)this.data.get("rfid");
    }

    public void setType(String type) {
        this.data.put("type", type);
    }

    public void setSoundAlgo(SoundAlgo algo) {
        this.data.put("soundalgo", "" + algo.toString());
    }

    public int setAdditionalInfo(Object info) {
        try {
            if (info != null) {
                String strInfo = HttpDataWraper.getString(info);
                int mlen = strInfo.getBytes("UTF-8").length;
                if (mlen > 1536) {
                    return 1536 - mlen;
                }
                this.data.put("addInfoCommon", strInfo);
                return 1;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0;
    }

    public int checkAdditionalInfoSize(Object info) {
        try {
            String strInfo = HttpDataWraper.getString(info);
            int mlen = strInfo.getBytes("UTF-8").length;
            return 1536 - mlen;
        }
        catch (Exception e) {
            return -1;
        }
    }

    public Object getAdditionalInfo() {
        if (this.data.get("addInfoCommon") != null) {
            return HttpDataWraper.getObject((String)this.data.get("addInfoCommon"));
        }
        return null;
    }

    public Hashtable getHash() {
        return this.data;
    }

    public class Android {
        public int setAdditionalInfo(Object info) {
            try {
                if (info != null) {
                    String strInfo = HttpDataWraper.getString(info);
                    int mlen = strInfo.getBytes("UTF-8").length;
                    if (mlen > 3072) {
                        return 3072 - mlen;
                    }
                    UnsPush.this.data.put("AND.addInfo", strInfo);
                    return 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }

        public int checkAdditionalInfoSize(Object info) {
            try {
                String strInfo = HttpDataWraper.getString(info);
                int mlen = strInfo.getBytes("UTF-8").length;
                return 3072 - mlen;
            }
            catch (Exception e) {
                return -1;
            }
        }
    }

    public class IOS {
        public void overRideWithLargeMessage(String msg) {
            if (msg != null) {
                UnsPush.this.data.put("IOS.bigMsg", msg);
            }
        }

        public int setAdditionalInfo(Object info) {
            try {
                if (info != null) {
                    String strInfo = HttpDataWraper.getString(info);
                    int mlen = strInfo.getBytes("UTF-8").length;
                    if (mlen > 1536) {
                        return 1536 - mlen;
                    }
                    UnsPush.this.data.put("IOS.addInfo", strInfo);
                    return 1;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return 0;
        }

        public int checkAdditionalInfoSize(Object info) {
            try {
                String strInfo = HttpDataWraper.getString(info);
                int mlen = strInfo.getBytes("UTF-8").length;
                return 1536 - mlen;
            }
            catch (Exception e) {
                return -1;
            }
        }

        public void enableBackgroundAppRefresh() {
            UnsPush.this.data.put("IOS.bgAppRefresh", "true");
        }

        public void setCategory(String categoryId) {
            UnsPush.this.data.put("IOS.category", categoryId);
        }

        public void setTitle(String title) {
            UnsPush.this.data.put("IOS.title", title);
        }
    }
}

