/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.websocket;

import com.adventnet.wms.nioclient.SSLWrapper;
import com.adventnet.wms.nioclient.exception.NIOCommunicationException;
import com.adventnet.wms.nioclient.exception.NIOException;
import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequest;
import com.adventnet.wms.nioclient.http.HttpRequestEventListener;
import com.adventnet.wms.nioclient.http.ReadTimeOutListener;
import com.adventnet.wms.nioclient.http.SelectorPoolFactory;
import com.adventnet.wms.nioclient.util.NIOBase64;
import com.adventnet.wms.nioclient.websocket.PingTimeOutListener;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.security.SecureRandom;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;

public class WebSocketRequest
extends HttpRequest {
    private static Logger logger = Logger.getLogger(WebSocketRequest.class.getName());
    private boolean handshakedone = false;
    private ByteBuffer wsdataBuffer = null;
    private ByteBuffer continuationBuffer = null;
    private ReadFrame rf = null;
    private SecureRandom random = new SecureRandom();
    private final int VERSION = 13;
    protected int readtimeout = 300000;
    private boolean isCompressionEnabled = false;
    private boolean tryCompression = true;
    private Inflater inflater;
    private Deflater deflater;
    public static final int OPCODE_CONTINUATION = 0;
    public static final int OPCODE_TEXT = 1;
    public static final int OPCODE_BINARY = 2;
    public static final int OPCODE_CLOSE = 8;
    public static final int OPCODE_PING = 9;
    public static final int OPCODE_PONG = 10;
    private int ping_interval = -1;
    private long lastpingtime = System.currentTimeMillis();
    private long lastwritetime = System.currentTimeMillis();
    private boolean sendPingFrame = false;
    private ConcurrentLinkedQueue writeQueue = new ConcurrentLinkedQueue();
    private int writeFrameCounter = 0;
    private int readFramesCounter = 0;
    private int sendbuffersize = -1;
    private boolean notifyEmptyFrame = false;
    private String pingMessage = "-";

    public WebSocketRequest(String url, int port, HttpRequestEventListener listener, boolean compression) throws Exception {
        super(url, port, "GET", listener);
        this.tryCompression = compression;
        this.random.setSeed(System.currentTimeMillis());
    }

    public WebSocketRequest(String url, int port, HttpRequestEventListener listener) throws Exception {
        super(url, port, "GET", listener);
        this.random.setSeed(System.currentTimeMillis());
    }

    @Override
    public void connect() throws IOException {
        this.connect(20000L);
    }

    @Override
    public void connect(long timeout) throws IOException {
        this.addHeader("Upgrade", "websocket");
        this.addHeader("Connection", "Upgrade");
        this.addHeader("Sec-WebSocket-Version", "13");
        this.addHeader("Sec-WebSocket-Key", NIOBase64.encodeByte(this.getRandomBytes(16)));
        if (this.tryCompression) {
            this.addHeader("Sec-Websocket-Extensions", "permessage-deflate");
        }
        this.isWebsocketConnection = true;
        this.createRequestWrapper();
        SelectorPoolFactory.getInstance(this.port).connect(this.connecthost, this.connectport, this, timeout, this.sendbuffersize);
        this.statReports.put("inittime", System.currentTimeMillis());
    }

    public void setSendBufferSize(int sendbuffersize) {
        this.sendbuffersize = sendbuffersize;
    }

    public void setPingInterval(int seconds) {
        this.ping_interval = seconds * 1000;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void readData(SelectionKey key) throws IOException, CancelledKeyException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.statReports.containsKey("readinittime")) {
                this.statReports.put("readinittime", System.currentTimeMillis());
            }
            if (this.key == null) {
                this.key = key;
            }
            int count = -1;
            if (this.isSSL) {
                if (this.ssl.doHandshake(key)) {
                    count = this.ssl.read();
                    this.byteBuffer = this.ssl.getDataBuffer();
                }
            } else {
                count = ((SocketChannel)key.channel()).read(this.byteBuffer);
            }
            this.bytesRead += (long)count;
            this.statReports.put("bytesread", this.bytesRead);
            this.statReports.put("lastreadtime", System.currentTimeMillis());
            if (count > 0) {
                this.zeroReadCount = 0;
                if (this.isHeaderComplete(this.byteBuffer) && this.handshakedone) {
                    block51: {
                        int pendingcount = count;
                        while (true) {
                            if (this.wsdataBuffer == null) {
                                try {
                                    this.rf = this.getReadFrame(this.byteBuffer);
                                }
                                catch (NIOException wex) {
                                    this.key.interestOps(1);
                                    break block51;
                                }
                                if (this.rf.isCloseFrame()) {
                                    this.close();
                                    EventDispatcher.process(this, -4);
                                    this.statReports.put("framesread", ++this.readFramesCounter);
                                    return;
                                }
                                if (this.rf.isPongFrame()) {
                                    byte[] wsresponse;
                                    if (this.rf.getPayloadSize() > 0) {
                                        wsresponse = new byte[this.rf.getPayloadSize()];
                                        this.byteBuffer.get(wsresponse);
                                    } else {
                                        wsresponse = new byte[]{};
                                    }
                                    EventDispatcher.process(this, 9, wsresponse);
                                    continue;
                                }
                                if (this.rf.isPingFrame()) {
                                    if (this.rf.getPayloadSize() > 0) {
                                        byte[] wsresponse = new byte[this.rf.getPayloadSize()];
                                        this.byteBuffer.get(wsresponse);
                                        this.sendPongFrame(wsresponse);
                                        continue;
                                    }
                                    this.sendPongFrame();
                                    continue;
                                }
                                int plsize = this.rf.getPayloadSize();
                                if (plsize < 0) {
                                    this.close();
                                    EventDispatcher.process(this, -4);
                                    return;
                                }
                                if (plsize == 0) {
                                    if (!this.notifyEmptyFrame) continue;
                                    this.response.addChunk("".getBytes("UTF-8"));
                                    EventDispatcher.process(this, 3);
                                    continue;
                                }
                                this.wsdataBuffer = ByteBuffer.allocate(plsize);
                                int clen = plsize;
                                if (this.byteBuffer.remaining() < plsize) {
                                    clen = this.byteBuffer.remaining();
                                }
                                if (clen > 0) {
                                    byte[] wsresponse = new byte[clen];
                                    this.byteBuffer.get(wsresponse);
                                    this.wsdataBuffer.put(wsresponse);
                                    if (!this.rf.isLastFrame()) {
                                        if (this.continuationBuffer == null) {
                                            this.continuationBuffer = ByteBuffer.allocate(plsize);
                                            this.continuationBuffer.put(wsresponse);
                                        } else {
                                            ByteBuffer newBB = ByteBuffer.allocate(this.continuationBuffer.position() + wsresponse.length);
                                            this.continuationBuffer.flip();
                                            newBB.put(this.continuationBuffer);
                                            this.continuationBuffer = newBB;
                                            this.continuationBuffer.put(wsresponse);
                                        }
                                    } else if (this.rf.isContinuationFrame()) {
                                        ByteBuffer newBB = ByteBuffer.allocate(this.continuationBuffer.position() + wsresponse.length);
                                        this.continuationBuffer.flip();
                                        newBB.put(this.continuationBuffer);
                                        this.continuationBuffer = newBB;
                                        this.continuationBuffer.put(wsresponse);
                                    }
                                    if (clen == plsize) {
                                        if (this.rf.isValidFrame()) {
                                            this.statReports.put("framesread", ++this.readFramesCounter);
                                            if (this.continuationBuffer != null) {
                                                try {
                                                    if (this.rf.isFrameCompressed()) {
                                                        ByteBuffer.wrap(this.inflate(this.continuationBuffer.array()));
                                                    }
                                                    wsresponse = this.continuationBuffer.array();
                                                }
                                                catch (DataFormatException dfe) {
                                                    throw new IOException("Websocket Decompression Error : " + dfe.getMessage());
                                                }
                                            }
                                            try {
                                                if (this.rf.isFrameCompressed()) {
                                                    wsresponse = this.inflate(wsresponse);
                                                }
                                            }
                                            catch (DataFormatException dfe) {
                                                throw new IOException("Websocket Decompression Error : " + dfe.getMessage());
                                            }
                                            this.response.addChunk(wsresponse);
                                            EventDispatcher.process(this, 3);
                                        }
                                        boolean isValidFrame = this.rf.isValidFrame();
                                        this.rf = null;
                                        key.interestOps(1);
                                        int chunkDatalen = wsresponse.length;
                                        pendingcount -= chunkDatalen;
                                        wsresponse = null;
                                        this.wsdataBuffer = null;
                                        if (this.byteBuffer.hasRemaining()) continue;
                                        if (this.continuationBuffer != null && isValidFrame) {
                                            this.continuationBuffer = null;
                                        }
                                    } else {
                                        key.interestOps(1);
                                    }
                                } else {
                                    key.interestOps(1);
                                }
                            }
                            if (!this.byteBuffer.hasRemaining()) {
                                key.interestOps(1);
                                this.clearBuffer(this.byteBuffer);
                                return;
                            }
                            if (this.wsdataBuffer.limit() - this.wsdataBuffer.position() > pendingcount) break;
                            byte[] data = new byte[this.wsdataBuffer.limit() - this.wsdataBuffer.position()];
                            this.byteBuffer.get(data);
                            this.wsdataBuffer.put(data);
                            int dataLen = data.length;
                            byte[] wsData = new byte[this.wsdataBuffer.limit()];
                            this.wsdataBuffer.flip();
                            this.wsdataBuffer.get(wsData);
                            if (this.rf.isValidFrame()) {
                                this.statReports.put("framesread", ++this.readFramesCounter);
                                if (this.rf.isFrameCompressed()) {
                                    try {
                                        wsData = this.inflate(wsData);
                                    }
                                    catch (DataFormatException dfe) {
                                        throw new IOException("Websocket Decompression Error : " + dfe.getMessage());
                                    }
                                }
                                this.response.addChunk(wsData);
                                EventDispatcher.process(this, 3);
                            }
                            this.rf = null;
                            wsData = null;
                            this.wsdataBuffer = null;
                            key.interestOps(1);
                            pendingcount -= dataLen;
                            data = null;
                        }
                        byte[] data = new byte[pendingcount];
                        this.byteBuffer.get(data);
                        this.wsdataBuffer.put(data);
                        data = null;
                        this.clearBuffer(this.byteBuffer);
                        key.interestOps(1);
                        return;
                    }
                    this.clearBuffer(this.byteBuffer);
                } else {
                    key.interestOps(1);
                }
            } else {
                if (count < 0) {
                    throw new IOException("Read -1");
                }
                if (count == 0) {
                    ++this.zeroReadCount;
                    key.interestOps(1);
                    if (this.zeroReadCount > this.maxZeroReadCount) {
                        throw new IOException("Key Read Count = 0 : Max Crossed");
                    }
                }
            }
        }
    }

    public ReadFrame getReadFrame(ByteBuffer bb) throws NIOException, IOException {
        boolean ctrl;
        int i = bb.position();
        int payloadSize = -1;
        boolean finSet = true;
        int opcode = 0;
        if (bb.remaining() == 0) {
            throw new NIOException("Insufficient Data");
        }
        byte header = bb.get(i);
        ++i;
        finSet = (header >> 7 & 1) == 1;
        opcode = header & 0xF;
        boolean isCompressed = false;
        boolean fin = (header & 0x80) != 0;
        boolean rsv1 = (header & 0x40) != 0;
        boolean bl = ctrl = (header & 8) != 0;
        if (fin && !ctrl && rsv1) {
            if (!this.isCompressionEnabled) {
                throw new IOException("Websocket Invalid read frame : Compressed data on Uncompressed Stream");
            }
            isCompressed = true;
        }
        if (opcode == 8) {
            ReadFrame rf = new ReadFrame(opcode);
            return rf;
        }
        if (bb.remaining() < 2) {
            throw new NIOException("Insufficient Data");
        }
        byte plen = bb.get(i);
        ++i;
        if (plen > 0 && plen < 126) {
            payloadSize = plen;
        } else if (plen == 126) {
            if (bb.remaining() < 4) {
                throw new NIOException("Insufficient Data");
            }
            payloadSize = (bb.get(i) & 0xFF) << 8 | bb.get(i + 1) & 0xFF;
            i += 2;
        } else if (plen == 127) {
            if (bb.remaining() < 10) {
                throw new NIOException("Insufficient Data");
            }
            payloadSize = (((((((bb.get(i) & 0xFF) << 8 | bb.get(i + 1) & 0xFF) << 8 | bb.get(i + 2) & 0xFF) << 8 | bb.get(i + 3) & 0xFF) << 8 | bb.get(i + 4) & 0xFF) << 8 | bb.get(i + 5) & 0xFF) << 8 | bb.get(i + 6) & 0xFF) << 8 | bb.get(i + 7) & 0xFF;
            i += 8;
        }
        if (payloadSize < 1) {
            payloadSize = 0;
        }
        bb.position(i);
        ReadFrame rf = new ReadFrame(opcode, payloadSize, finSet, isCompressed, fin);
        return rf;
    }

    @Override
    public void parseResponse(ByteBuffer bb) throws IOException {
        if (!this.headerread) {
            bb.flip();
            byte[] headerData = new byte[this.headerLength];
            bb.get(headerData);
            BufferedReader br = new BufferedReader(new StringReader(new String(headerData)));
            String line = br.readLine();
            String[] tokens = line.split(" ");
            String version = tokens[0];
            String responsecode = tokens[1];
            String responsestatusmsg = tokens[2];
            this.response.setResponseCode(responsecode);
            this.response.setResponseMessage(responsestatusmsg);
            String rawUrl = tokens[1];
            while ((line = br.readLine()) != null && !line.equals("")) {
                tokens = line.split(": ", 2);
                if (tokens.length == 2) {
                    this.response.addHeader(tokens[0].toLowerCase(), tokens[1]);
                    continue;
                }
                logger.log(Level.INFO, "MALFORMWRONGHEADER {0}", new Object[]{line});
            }
            if (this.isProxyConnectRequest) {
                this.requestComplete = true;
                EventDispatcher.process(this, 3);
                if (this.isHttps()) {
                    this.isSSL = true;
                    this.ssl = new SSLWrapper(this.sc, this.getHost());
                }
                this.isProxyConnectRequest = false;
                this.handshakedone = true;
                return;
            }
            if (this.response.getResponseHeader("upgrade") != null && this.response.getResponseHeader("upgrade").toLowerCase().equals("websocket") && this.response.getResponseHeader("connection") != null && this.response.getResponseHeader("connection").toLowerCase().equals("upgrade")) {
                headerData = null;
                this.statReports.put("upgradedtime", System.currentTimeMillis());
                this.handshakedone = true;
                if (this.response.getResponseHeader("sec-websocket-extensions") != null && this.response.getResponseHeader("sec-websocket-extensions").trim().toLowerCase().equals("permessage-deflate")) {
                    this.isCompressionEnabled = true;
                    this.inflater = new Inflater(true);
                    this.deflater = new Deflater(9, true);
                }
                this.response.prepareWSResponseQueue();
                if (this.ping_interval != -1) {
                    this.pingExpireTime = System.currentTimeMillis() + (long)this.ping_interval;
                    PingTimeOutListener.TRACKER.touch(this.pingExpireTime, this);
                }
                ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
                this.onHandshake();
            } else {
                EventDispatcher.process(this, -1);
                this.close();
            }
        }
        this.headerread = true;
    }

    public void write(String msg) throws IOException {
        if (this.closed) {
            throw new IOException("Connection isn't alive");
        }
        try {
            this.writeQueue.add(new WriteFrame(1, msg));
        }
        catch (NIOCommunicationException wcex) {
            throw new IOException("Write Failure");
        }
        if (this.handshakedone) {
            try {
                this.onHandshake();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void write(byte[] msg) throws IOException {
        if (this.closed) {
            throw new IOException("Connection isn't alive");
        }
        try {
            this.writeQueue.add(new WriteFrame(2, msg));
        }
        catch (NIOCommunicationException wcex) {
            throw new IOException("Write Failure");
        }
        if (this.handshakedone) {
            try {
                this.onHandshake();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void onHandshake() {
        WriteFrame frame = null;
        while ((frame = (WriteFrame)this.writeQueue.poll()) != null) {
            try {
                this.writeWSData(frame);
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.inflater != null) {
                    this.inflater.end();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.deflater != null) {
                    this.deflater.end();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.isCompressionEnabled = false;
            try {
                this.writeWSData(new WriteFrame(8, ""));
            }
            catch (Exception exception) {
                // empty catch block
            }
            PingTimeOutListener.TRACKER.remove(this.pingExpireTime, this);
            try {
                ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.isSSL) {
                    this.ssl.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in ssl close : ", ex);
            }
            SocketChannel ch = null;
            try {
                ch = (SocketChannel)this.key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in getting key channel : ", ex);
            }
            try {
                this.key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key cancel : ", ex);
            }
            try {
                if (ch.isOpen()) {
                    ch.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel close for client : ", ex);
            }
            this.closed = true;
            this.statReports.put("closetime", System.currentTimeMillis());
        }
    }

    public void setNotifyEmptyFrame(boolean status) {
        this.notifyEmptyFrame = status;
    }

    public void invokePingFrame(boolean sendPingFrame) {
        this.sendPingFrame = sendPingFrame;
    }

    public void setPingMessage(String pingMessage) {
        this.pingMessage = pingMessage;
    }

    @Override
    public void doPing() {
        try {
            if (this.sendPingFrame) {
                this.writePingData(this.pingMessage);
                EventDispatcher.process(this, 8);
            } else {
                WriteFrame frame = (WriteFrame)this.writeQueue.poll();
                if (frame == null) {
                    if (System.currentTimeMillis() - this.lastwritetime < (long)this.ping_interval) {
                        this.lastpingtime = System.currentTimeMillis();
                        long oldTime = this.pingExpireTime;
                        this.pingExpireTime = System.currentTimeMillis() + (long)this.ping_interval;
                        PingTimeOutListener.TRACKER.update(oldTime, this.pingExpireTime, this);
                        return;
                    }
                    this.writeWSData(new WriteFrame(1, this.pingMessage));
                    EventDispatcher.process(this, 8);
                } else {
                    this.writeWSData(frame);
                    EventDispatcher.process(this, 8);
                }
            }
            this.lastpingtime = System.currentTimeMillis();
            long oldTime = this.pingExpireTime;
            this.pingExpireTime = System.currentTimeMillis() + (long)this.ping_interval;
            PingTimeOutListener.TRACKER.update(oldTime, this.pingExpireTime, this);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in doPing : ", ex);
        }
    }

    public void doCustomPing(String pingMessage) throws Exception {
        if (this.ping_interval != -1) {
            throw new Exception("Disable setPingInterval to send custom ping.");
        }
        if (pingMessage == null) {
            this.writeWSData(new WriteFrame(9, ""));
        } else {
            this.writeWSData(new WriteFrame(9, pingMessage));
        }
        EventDispatcher.process(this, 8);
    }

    private void writePingData(String msg) throws IOException {
        if (this.closed) {
            throw new IOException("Connection isn't alive");
        }
        try {
            this.writeQueue.add(new WriteFrame(9, msg));
        }
        catch (NIOCommunicationException wcex) {
            throw new IOException("Write Failure");
        }
        if (this.handshakedone) {
            try {
                this.onHandshake();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void sendPongFrame() throws IOException {
        this.sendPongFrame(null);
    }

    private void sendPongFrame(byte[] msg) throws IOException {
        if (this.closed) {
            throw new IOException("Connection isn't alive");
        }
        try {
            if (msg != null) {
                this.writeQueue.add(new WriteFrame(10, msg));
            } else {
                this.writeQueue.add(new WriteFrame(10, new byte[0]));
            }
        }
        catch (NIOCommunicationException wcex) {
            throw new IOException("Write Failure");
        }
        if (this.handshakedone) {
            try {
                this.onHandshake();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void writeWSData(WriteFrame frame) throws Exception {
        if (frame == null) {
            return;
        }
        ByteBuffer writeBB = ByteBuffer.wrap(frame.getBytes());
        int count = 0;
        while (writeBB.hasRemaining()) {
            int wcount = 0;
            if (this.isSSL) {
                wcount = this.ssl.write(writeBB);
                count += wcount;
            } else {
                wcount = this.sc.write(writeBB);
                count += wcount;
            }
            if (wcount == 0) {
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            this.lastwritetime = System.currentTimeMillis();
        }
        this.bytesWritten += (long)count;
        this.statReports.put("byteswritten", this.bytesWritten);
        this.statReports.put("frameswritten", this.writeFrameCounter);
        this.statReports.put("lastwrittentime", System.currentTimeMillis());
    }

    public long getLastPingTime() {
        return this.lastpingtime;
    }

    public boolean isInactive() {
        return System.currentTimeMillis() - this.lastpingtime > (long)(this.ping_interval * 5);
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public HashMap getReports(boolean humanReadable) {
        LinkedHashMap humanReadableStats = new LinkedHashMap();
        if (humanReadable) {
            for (Map.Entry pair : this.statReports.entrySet()) {
                if (pair.getKey() == "handshaketime" || pair.getKey() == "bytesread" || pair.getKey() == "byteswritten" || pair.getKey() == "frameswritten" || pair.getKey() == "framesread") {
                    humanReadableStats.put(pair.getKey(), pair.getValue());
                    continue;
                }
                humanReadableStats.put(pair.getKey(), new Date(Long.parseLong(pair.getValue().toString())));
            }
            return humanReadableStats;
        }
        return this.statReports;
    }

    private byte[] getRandomBytes(int len) {
        byte[] rb = new byte[len];
        this.random.nextBytes(rb);
        return rb;
    }

    private byte[] inflate(byte[] data) throws IOException, DataFormatException {
        int count;
        int compSize = data.length;
        ByteBuffer bb = ByteBuffer.allocate(data.length + 4);
        bb.put(data);
        bb.put(new byte[]{0, 0, -1, -1});
        data = bb.array();
        this.inflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while ((count = this.inflater.inflate(buffer, 0, buffer.length)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        int inflatedSize = output.length;
        return output;
    }

    private byte[] deflate(byte[] data) throws IOException {
        int count;
        int orgSize = data.length;
        this.deflater.setInput(data);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(data.length);
        byte[] buffer = new byte[1024];
        while ((count = this.deflater.deflate(buffer, 0, buffer.length, 2)) > 0) {
            outputStream.write(buffer, 0, count);
        }
        outputStream.close();
        byte[] output = outputStream.toByteArray();
        ByteBuffer bb = ByteBuffer.allocate(output.length - 4);
        bb.put(output, 0, output.length - 4);
        output = bb.array();
        int deflatedSize = output.length;
        return output;
    }

    class WriteFrame {
        private byte opcode;
        private byte[] data;

        public WriteFrame(int opcode, String strData) throws NIOCommunicationException, IOException {
            this(opcode, strData, true);
        }

        public WriteFrame(int opcode, byte[] byteData) throws NIOCommunicationException, IOException {
            this(opcode, byteData, true);
        }

        public WriteFrame(int opcode, String strData, boolean mask) throws NIOCommunicationException, IOException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(strData.getBytes("UTF-8"), mask);
            }
            catch (NIOCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new NIOCommunicationException("Unable to prepare write frame [TEXT] : " + e.getMessage());
            }
        }

        public WriteFrame(int opcode, byte[] byteData, boolean mask) throws NIOCommunicationException, IOException {
            try {
                this.opcode = (byte)opcode;
                this.data = this.prepareFrame(byteData, mask);
            }
            catch (NIOCommunicationException wce) {
                throw wce;
            }
            catch (Exception e) {
                throw new NIOCommunicationException("Unable to prepare write frame [BINARY] : " + e.getMessage());
            }
        }

        public byte[] getBytes() {
            return this.data;
        }

        private byte[] prepareFrame(byte[] rawData, boolean mask) throws NIOCommunicationException, IOException {
            WebSocketRequest.this.writeFrameCounter++;
            try {
                byte[] b;
                ByteArrayOutputStream wf = new ByteArrayOutputStream(rawData.length + 10);
                if (WebSocketRequest.this.isCompressionEnabled && !this.isPingFrame() && !this.isPongFrame()) {
                    try {
                        wf.write((byte)(0xC0 | this.opcode));
                        rawData = WebSocketRequest.this.deflate(rawData);
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, " Exception ", ex);
                        throw new IOException("Websocket Compression Error : " + ex.getMessage());
                    }
                } else {
                    wf.write((byte)(0x80 | this.opcode));
                }
                int length = rawData.length;
                int lf = 0;
                if (length < 126) {
                    lf = length;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                } else if (length <= 65535) {
                    lf = 126;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[]{(byte)(length >>> 8), (byte)(length & 0xFF)};
                    wf.write(b);
                } else if (length > 65535) {
                    lf = 127;
                    lf = mask ? 0x80 | lf : lf;
                    wf.write((byte)lf);
                    b = new byte[8];
                    long blength = new Long(length);
                    b[0] = (byte)(blength >>> 56);
                    b[1] = (byte)(blength >>> 48);
                    b[2] = (byte)(blength >>> 40);
                    b[3] = (byte)(blength >>> 32);
                    b[4] = (byte)(blength >>> 24);
                    b[5] = (byte)(blength >>> 16);
                    b[6] = (byte)(blength >>> 8);
                    b[7] = (byte)(blength & 0xFFL);
                    wf.write(b);
                }
                if (mask) {
                    byte[] maskValue = WebSocketRequest.this.getRandomBytes(4);
                    wf.write(maskValue);
                    for (int i = 0; i < rawData.length; ++i) {
                        int n = i;
                        rawData[n] = (byte)(rawData[n] ^ maskValue[i % 4]);
                    }
                }
                wf.write(rawData);
                return wf.toByteArray();
            }
            catch (Exception e) {
                throw new NIOCommunicationException("Unable to prepare write frame : " + e.getMessage());
            }
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }

        public boolean isPingFrame() {
            return this.opcode == 9;
        }

        public boolean isPongFrame() {
            return this.opcode == 10;
        }
    }

    class ReadFrame {
        private int payloadSize = -1;
        private int opcode = 0;
        private boolean finSet = true;
        private boolean isCompressed = false;
        private boolean fin = false;

        public ReadFrame(int opcode) {
            this.opcode = opcode;
        }

        public ReadFrame(int opcode, int payloadSize, boolean finSet, boolean isCompressed, boolean fin) {
            this.payloadSize = payloadSize;
            this.opcode = opcode;
            this.finSet = finSet;
            this.isCompressed = isCompressed;
            this.fin = fin;
        }

        public int getPayloadSize() {
            return this.payloadSize;
        }

        public boolean isValidFrame() {
            return this.fin && (this.opcode == 1 || this.opcode == 2 || this.opcode == 0);
        }

        public boolean isCloseFrame() {
            return this.opcode == 8;
        }

        public boolean isContinuationFrame() {
            return this.opcode == 0;
        }

        public boolean isFrameCompressed() {
            return this.isCompressed;
        }

        public boolean isLastFrame() {
            return this.fin;
        }

        public boolean isPongFrame() {
            return this.opcode == 10;
        }

        public boolean isPingFrame() {
            return this.opcode == 9;
        }
    }
}

