/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import java.io.IOException;
import java.net.Socket;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SNIServerName;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;

public class TCPSSLWrapper {
    private SocketChannel sc;
    private SelectionKey key;
    private ByteBuffer dataBuffer;
    private static int dataBBSize = 4096;
    private SSLEngine sslEngine = null;
    private int appSize;
    private int netSize;
    private ByteBuffer inBB;
    private ByteBuffer outBB;
    private int max_size = 0x100000;
    private static ByteBuffer handShakeBB = ByteBuffer.allocate(0);
    private int writebuffersize = 8192;
    private int maxwritebuffersize = 40960;
    private ByteBuffer writeBB = ByteBuffer.allocate(this.writebuffersize);
    private SSLEngineResult.HandshakeStatus sslHSStatus;
    private boolean sslHSComplete;
    private boolean close = false;
    private static Logger logger = Logger.getLogger(TCPSSLWrapper.class.getName());
    private long byteswritten;
    private long lastwrittentime;
    private Map handshakeReports = new LinkedHashMap();
    private boolean closehsinitiated = false;

    public TCPSSLWrapper(SocketChannel sc, SSLEngine sslEng, String sniServerName) throws IOException {
        this(sc, sslEng, null, null, null, null, sniServerName);
    }

    public TCPSSLWrapper(SocketChannel sc, SSLEngine sslEng, ArrayList<String> sslversion, ArrayList<String> ciphersuites, String sniServerName) throws IOException {
        this(sc, sslEng, sslversion, ciphersuites, null, null, sniServerName);
    }

    public TCPSSLWrapper(SocketChannel sc, SSLEngine sslEng, ArrayList<String> sslversion, ArrayList<String> ciphersuites, ArrayList<String> ignoresslversions, ArrayList<String> ignoreciphersuites, String sniServerName) throws IOException {
        this.sc = sc;
        this.sc.configureBlocking(false);
        this.sslEngine = sslEng;
        try {
            String[] s = this.sslEngine.getEnabledProtocols();
            String[] cp = this.sslEngine.getSupportedCipherSuites();
            ArrayList<String> protocolSupportedList = new ArrayList<String>(Arrays.asList(s));
            ArrayList<String> cipherSuiteSupportedList = new ArrayList<String>(Arrays.asList(cp));
            if (ciphersuites.size() > 0) {
                this.sslEngine.setEnabledCipherSuites(ciphersuites.toArray(new String[0]));
            } else if (ignoreciphersuites.size() > 0) {
                List ciphersuitelist = this.removeSelectiveCPSuiteList(cipherSuiteSupportedList, ignoreciphersuites);
                this.sslEngine.setEnabledCipherSuites(ciphersuitelist.toArray(new String[0]));
            }
            if (sslversion.size() > 0) {
                this.sslEngine.setEnabledProtocols(sslversion.toArray(new String[0]));
            } else if (ignoresslversions.size() > 0) {
                protocolSupportedList.removeAll(ignoresslversions);
                this.sslEngine.setEnabledProtocols(protocolSupportedList.toArray(new String[0]));
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception ", ex);
        }
        this.sslEngine.setUseClientMode(true);
        this.setSni(this.sslEngine, sniServerName);
        this.sslHSStatus = SSLEngineResult.HandshakeStatus.NEED_UNWRAP;
        this.sslHSComplete = false;
        this.netSize = this.sslEngine.getSession().getPacketBufferSize();
        this.inBB = ByteBuffer.allocate(this.netSize);
        this.outBB = ByteBuffer.allocate(this.netSize);
        this.outBB.position(0);
        this.outBB.limit(0);
        this.appSize = this.sslEngine.getSession().getApplicationBufferSize();
        this.dataBuffer = ByteBuffer.allocate(this.appSize);
    }

    private void setSni(SSLEngine sslEngine, String sniServerName) {
        try {
            if (sniServerName != null && !sniServerName.isEmpty()) {
                String regex = "^((?!-)[A-Za-z0-9-]{1,63}(?<!-)\\.)+[A-Za-z]{2,6}$";
                if (!sniServerName.matches(regex)) {
                    logger.log(Level.INFO, "Invalid DomainName : {0}. Proceeding without setting sni name.", new Object[]{sniServerName});
                    return;
                }
                SSLParameters params = sslEngine.getSSLParameters();
                ArrayList<SNIServerName> list = new ArrayList<SNIServerName>();
                SNIHostName serverName = new SNIHostName(sniServerName);
                list.add(serverName);
                params.setServerNames(list);
                sslEngine.setSSLParameters(params);
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in setServerName : ", ex);
        }
    }

    protected void setWriteBufferSize(int size, int maxsize) {
        this.writebuffersize = size;
        this.maxwritebuffersize = maxsize;
    }

    protected int getInterestOps() {
        return this.key.interestOps();
    }

    private String getHost() {
        try {
            Socket socket = this.sc.socket();
            return socket.getInetAddress().getHostName();
        }
        catch (Exception ex) {
            return null;
        }
    }

    private List removeSelectiveCPSuiteList(List<String> cipherSuiteSupportedList, ArrayList ignoreciphersuites) {
        ArrayList<String> removeList = new ArrayList<String>();
        for (String cpsuite : cipherSuiteSupportedList) {
            for (int cpCnt = 0; cpCnt < ignoreciphersuites.size(); ++cpCnt) {
                String ignorecpSuiteName = (String)ignoreciphersuites.get(cpCnt);
                if (!cpsuite.contains(ignorecpSuiteName)) continue;
                removeList.add(cpsuite);
            }
        }
        if (removeList.size() > 0) {
            cipherSuiteSupportedList.removeAll(removeList);
        }
        return cipherSuiteSupportedList;
    }

    private void resizeDataBB() {
        if (this.dataBuffer.remaining() < this.appSize && this.dataBuffer.capacity() > 0 && this.dataBuffer.capacity() < this.max_size) {
            ByteBuffer bb = ByteBuffer.allocate(this.dataBuffer.capacity() * 2);
            this.dataBuffer.flip();
            bb.put(this.dataBuffer);
            this.dataBuffer = bb;
        }
    }

    public void clearDataBuffer() {
        this.dataBuffer.clear();
    }

    private boolean flush(ByteBuffer bb) throws IOException {
        int cnt = this.sc.write(bb);
        this.byteswritten += (long)cnt;
        return !bb.hasRemaining();
    }

    private int flushData() throws IOException {
        int count = this.sc.write(this.outBB);
        this.byteswritten += (long)count;
        this.lastwrittentime = System.currentTimeMillis();
        return count;
    }

    public long getLastWrittenTime() {
        return this.lastwrittentime;
    }

    public Map getHandshakeReports() {
        return this.handshakeReports;
    }

    public boolean doHandshake(SelectionKey sk) throws IOException {
        if (!this.handshakeReports.containsKey("handshakeinittime")) {
            this.handshakeReports.put("handshakeinittime", System.currentTimeMillis());
        }
        if (this.sslHSComplete) {
            return this.sslHSComplete;
        }
        if (this.outBB.hasRemaining()) {
            if (!this.flush(this.outBB)) {
                sk.interestOps(4);
                return false;
            }
            switch (this.sslHSStatus) {
                case FINISHED: {
                    this.sslHSComplete = true;
                }
                case NEED_UNWRAP: {
                    if (sk == null) break;
                    sk.interestOps(1);
                    break;
                }
                case NEED_WRAP: {
                    if (sk == null) break;
                    sk.interestOps(4);
                }
            }
            return this.sslHSComplete;
        }
        block5 : switch (this.sslHSStatus) {
            case NEED_UNWRAP: {
                SSLEngineResult result;
                if (this.sc.read(this.inBB) == -1) {
                    this.inBB.flip();
                    SSLEngineResult result2 = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
                    this.sslEngine.closeInbound();
                    throw new IOException("SSL Handshake : Read -1");
                }
                block23: while (this.sslHSStatus == SSLEngineResult.HandshakeStatus.NEED_UNWRAP) {
                    this.inBB.flip();
                    result = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
                    this.inBB.compact();
                    this.sslHSStatus = result.getHandshakeStatus();
                    switch (result.getStatus()) {
                        case OK: {
                            switch (this.sslHSStatus) {
                                case NOT_HANDSHAKING: {
                                    throw new IOException("SSL - Invalid handshake");
                                }
                                case NEED_TASK: {
                                    this.sslHSStatus = this.doTasks();
                                    break;
                                }
                                case FINISHED: {
                                    this.sslHSComplete = true;
                                    break block23;
                                }
                            }
                            continue block23;
                        }
                        case BUFFER_UNDERFLOW: {
                            if (sk == null) break block23;
                            sk.interestOps(1);
                            break block23;
                        }
                        case CLOSED: {
                            this.sslEngine.closeInbound();
                        }
                        default: {
                            throw new IOException("SSL - Invalid handshake " + (Object)((Object)result.getStatus()));
                        }
                    }
                }
                if (this.sslHSStatus != SSLEngineResult.HandshakeStatus.NEED_WRAP) break;
            }
            case NEED_WRAP: {
                this.outBB.clear();
                SSLEngineResult result = this.sslEngine.wrap(handShakeBB, this.outBB);
                this.outBB.flip();
                this.sslHSStatus = result.getHandshakeStatus();
                switch (result.getStatus()) {
                    case OK: {
                        if (this.sslHSStatus == SSLEngineResult.HandshakeStatus.NEED_TASK) {
                            this.sslHSStatus = this.doTasks();
                        }
                        if (sk == null) break block5;
                        sk.interestOps(4);
                        break block5;
                    }
                    default: {
                        throw new IOException("SSL Invalid handshake " + (Object)((Object)result.getStatus()));
                    }
                }
            }
            case FINISHED: {
                this.sslHSComplete = true;
                break;
            }
            default: {
                throw new RuntimeException("SSL Invlaid hand shake state" + (Object)((Object)this.sslHSStatus));
            }
        }
        if (this.sslHSComplete) {
            this.handshakeReports.put("handshakeend", System.currentTimeMillis());
            this.handshakeReports.put("handshaketime", Long.parseLong(this.handshakeReports.get("handshakeend").toString()) - Long.parseLong(this.handshakeReports.get("handshakeinittime").toString()));
        }
        return this.sslHSComplete;
    }

    private SSLEngineResult.HandshakeStatus doTasks() {
        Runnable runnable;
        while ((runnable = this.sslEngine.getDelegatedTask()) != null) {
            runnable.run();
        }
        return this.sslEngine.getHandshakeStatus();
    }

    public int read() throws IOException {
        SSLEngineResult result;
        if (!this.sslHSComplete) {
            throw new IllegalStateException();
        }
        int pos = this.dataBuffer.position();
        if (pos > 0) {
            return pos;
        }
        if (this.sc.read(this.inBB) == -1) {
            this.sslEngine.closeInbound();
            return -1;
        }
        int currentpos = this.dataBuffer.position();
        block4: do {
            this.resizeDataBB();
            this.inBB.flip();
            result = this.sslEngine.unwrap(this.inBB, this.dataBuffer);
            this.inBB.compact();
            currentpos = this.dataBuffer.position();
            switch (result.getStatus()) {
                case OK: 
                case BUFFER_UNDERFLOW: {
                    if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block4;
                    this.doTasks();
                    break;
                }
                case CLOSED: {
                    this.sslEngine.closeInbound();
                }
                default: {
                    if (this.dataBuffer.position() - pos > 0) break;
                    throw new IOException("SSL sslEngine error read " + (Object)((Object)result.getStatus()));
                }
            }
            if (result.bytesProduced() == 0) break;
        } while (currentpos < this.max_size && this.inBB.position() != 0 && result.getStatus() != SSLEngineResult.Status.BUFFER_UNDERFLOW);
        return this.dataBuffer.position() - pos;
    }

    public ByteBuffer getDataBuffer() {
        return this.dataBuffer;
    }

    public boolean isWritePending() {
        return this.writeBB.position() > 0;
    }

    public void writeData(ByteBuffer[] buffers) throws IOException, CancelledKeyException {
        for (int i = 0; i < buffers.length; ++i) {
            ByteBuffer bb;
            ByteBuffer src = buffers[i];
            if (!this.sslHSComplete) {
                throw new IllegalStateException("SSL Invalid Handshake state Write");
            }
            if (this.writeBB.position() == 0 && src.capacity() <= this.maxwritebuffersize) {
                ByteBuffer bb2 = ByteBuffer.allocate(src.capacity());
                this.writeBB.flip();
                bb2.put(this.writeBB);
                this.writeBB = bb2;
                this.writeBB.put(src);
                return;
            }
            if (this.writeBB.capacity() - this.writeBB.position() > src.capacity()) {
                this.writeBB.put(src);
                continue;
            }
            if (src.capacity() + this.writeBB.position() < this.writebuffersize) {
                ByteBuffer bb3 = ByteBuffer.allocate(this.writebuffersize);
                this.writeBB.flip();
                bb3.put(this.writeBB);
                this.writeBB = bb3;
                this.writeBB.put(src);
                continue;
            }
            if (src.capacity() + this.writeBB.position() > this.writeBB.capacity() * 2) {
                if (src.capacity() + this.writeBB.position() < this.maxwritebuffersize) {
                    int en_size = src.capacity() + this.writeBB.position();
                    bb = ByteBuffer.allocate(en_size);
                    this.writeBB.flip();
                    bb.put(this.writeBB);
                    this.writeBB = bb;
                    this.writeBB.put(src);
                    continue;
                }
                throw new IOException("Exceeded max allowed size " + (src.capacity() + this.writeBB.position()) + " Allowed " + this.maxwritebuffersize);
            }
            if (src.capacity() + this.writeBB.position() < this.writeBB.capacity() * 2) {
                int en_size = src.capacity() + this.writeBB.position();
                bb = ByteBuffer.allocate(en_size);
                this.writeBB.flip();
                bb.put(this.writeBB);
                this.writeBB = bb;
                this.writeBB.put(src);
                continue;
            }
            ByteBuffer bb4 = ByteBuffer.allocate(this.writeBB.capacity() * 2);
            this.writeBB.flip();
            bb4.put(this.writeBB);
            this.writeBB = bb4;
            this.writeBB.put(src);
        }
    }

    public void handleWrite(SelectionKey key) throws IOException, CancelledKeyException {
        if (this.key == null) {
            this.key = key;
        }
        boolean write = true;
        block5: while (write) {
            if (this.outBB.hasRemaining() && !this.flush(this.outBB)) {
                if (key != null) {
                    key.interestOps(4);
                }
                return;
            }
            SSLEngineResult result = null;
            if (this.writeBB.position() > 0) {
                this.writeBB.flip();
                this.outBB.clear();
                result = this.sslEngine.wrap(this.writeBB, this.outBB);
                if (result == null) continue;
                switch (result.getStatus()) {
                    case OK: {
                        this.writeBB.compact();
                        boolean proceed = true;
                        this.outBB.flip();
                        while (this.outBB.hasRemaining() && proceed) {
                            if (this.flushData() > 0) continue;
                            proceed = false;
                        }
                        if (result.getHandshakeStatus() != SSLEngineResult.HandshakeStatus.NEED_TASK) continue block5;
                        this.doTasks();
                        continue block5;
                    }
                    case BUFFER_OVERFLOW: {
                        write = false;
                        continue block5;
                    }
                    case BUFFER_UNDERFLOW: {
                        write = false;
                        continue block5;
                    }
                }
                throw new IOException("SSL sslEngine error write " + (Object)((Object)result.getStatus()));
            }
            write = false;
        }
        if (this.writeBB.position() > 0) {
            key.interestOps(4);
        } else {
            key.interestOps(1);
        }
    }

    public long byteswritten() {
        return this.byteswritten;
    }

    public boolean close() throws IOException {
        if (!this.closehsinitiated) {
            SSLEngineResult result = null;
            if (this.sslEngine.isOutboundDone()) {
                return true;
            }
            this.sslEngine.closeOutbound();
            this.outBB.clear();
            result = this.sslEngine.wrap(handShakeBB, this.outBB);
            if (result.getStatus() != SSLEngineResult.Status.CLOSED) {
                throw new SSLException("SSL Invalid close state");
            }
            this.outBB.flip();
            this.closehsinitiated = true;
            this.flush(this.outBB);
        } else if (this.outBB.hasRemaining()) {
            this.flush(this.outBB);
        }
        if (this.outBB.hasRemaining()) {
            this.key.interestOps(5);
            return false;
        }
        return this.sslEngine.isOutboundDone() && !this.outBB.hasRemaining();
    }
}

