/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.tcp.TCPSSLTrustManager;
import java.util.ArrayList;
import java.util.Hashtable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.TrustManager;
import org.conscrypt.Conscrypt;
import org.conscrypt.OpenSSLContextImpl;

public class TCPSSLManager {
    private static Hashtable<String, SSLContext> sslClientCntxMap = new Hashtable();
    private static Hashtable<String, OpenSSLContextImpl> conscryptCntxMap = new Hashtable();
    private static boolean conscrypt;
    private static boolean conscryptticketresumption;

    public static void initializeClientManager(ArrayList domains) throws Exception {
        String domain2;
        for (String domain2 : domains) {
            TCPSSLManager.initClientCntx(domain2, null, null, null);
        }
        domain2 = "default";
        TCPSSLManager.initClientCntx(domain2, null, null, null);
    }

    public static void initializeClientManager(String domain, String file, String password) throws Exception {
        TCPSSLManager.initClientCntx(domain, file, password, null);
    }

    public static void initializeClientManager(String domain, String file, String password, String keystoreType) throws Exception {
        TCPSSLManager.initClientCntx(domain, file, password, keystoreType);
    }

    private static void initClientCntx(String domain, String file, String password, String keystoreType) throws Exception {
        if (!conscrypt) {
            SSLContext sslClientCntx = SSLContext.getInstance("TLSv1.2");
            TCPSSLTrustManager tm = new TCPSSLTrustManager(domain, file, password, keystoreType);
            sslClientCntx.init(tm.getKeyManagers(), new TrustManager[]{tm}, null);
            sslClientCntxMap.put(domain, sslClientCntx);
        } else {
            OpenSSLContextImpl sslClientCntx = (OpenSSLContextImpl)Conscrypt.newPreferredSSLContextSpi();
            TCPSSLTrustManager tm = new TCPSSLTrustManager(domain, file, password, keystoreType);
            sslClientCntx.engineInit(tm.getKeyManagers(), new TrustManager[]{tm}, null);
            conscryptCntxMap.put(domain, sslClientCntx);
        }
    }

    public static SSLContext getSSLClientContext(String indomain) {
        return TCPSSLManager.getSSLClientContext(indomain, null, null, null, false, false);
    }

    public static SSLContext getSSLClientContext(String indomain, boolean ignorecertificatevalidation, boolean ignorechainverification) {
        return TCPSSLManager.getSSLClientContext(indomain, null, null, null, ignorecertificatevalidation, ignorechainverification);
    }

    public static SSLContext getSSLClientContext(String indomain, String file, String password) {
        return TCPSSLManager.getSSLClientContext(indomain, file, password, null, false, false);
    }

    public static SSLContext getSSLClientContext(String indomain, String file, String password, String keystoreType) {
        return TCPSSLManager.getSSLClientContext(indomain, file, password, keystoreType, false, false);
    }

    public static SSLContext getSSLClientContext(String indomain, String file, String password, String keystoreType, boolean ignorecertificatevalidation, boolean ignorechainverification) {
        try {
            if (!ignorecertificatevalidation && !ignorechainverification && sslClientCntxMap.get(indomain) != null) {
                return sslClientCntxMap.get(indomain);
            }
            SSLContext sslClientCntx = SSLContext.getInstance("TLSv1.2");
            if (!ignorecertificatevalidation && !ignorechainverification) {
                TCPSSLTrustManager tm = new TCPSSLTrustManager(indomain, file, password, keystoreType);
                sslClientCntx.init(tm.getKeyManagers(), new TrustManager[]{tm}, null);
                sslClientCntxMap.put(indomain, sslClientCntx);
            } else {
                TCPSSLTrustManager manager = new TCPSSLTrustManager(indomain, file, password, keystoreType);
                if (ignorecertificatevalidation) {
                    manager.ignoreCertificateValidation();
                }
                if (ignorechainverification) {
                    manager.ignoreChainVerification();
                }
                sslClientCntx.init(manager.getKeyManagers(), new TrustManager[]{manager}, null);
            }
            return sslClientCntx;
        }
        catch (Exception ex) {
            return sslClientCntxMap.get("default");
        }
    }

    public static OpenSSLContextImpl getConscryptContext(String domain) {
        return TCPSSLManager.getConscryptContext(domain, null, null, null, false, false);
    }

    public static OpenSSLContextImpl getConscryptContext(String domain, boolean ignorecertificatevalidation, boolean ignorechainverification) {
        return TCPSSLManager.getConscryptContext(domain, null, null, null, ignorecertificatevalidation, ignorechainverification);
    }

    public static OpenSSLContextImpl getConscryptContext(String domain, String file, String password) {
        return TCPSSLManager.getConscryptContext(domain, file, password, null, false, false);
    }

    public static OpenSSLContextImpl getConscryptContext(String domain, String file, String password, String keystoreType) {
        return TCPSSLManager.getConscryptContext(domain, file, password, keystoreType, false, false);
    }

    public static OpenSSLContextImpl getConscryptContext(String indomain, String file, String password, String keystoreType, boolean ignorecertificatevalidation, boolean ignorechainverification) {
        try {
            if (!ignorecertificatevalidation && !ignorechainverification && conscryptCntxMap.get(indomain) != null) {
                return conscryptCntxMap.get(indomain);
            }
            OpenSSLContextImpl sslClientCntx = (OpenSSLContextImpl)Conscrypt.newPreferredSSLContextSpi();
            if (!ignorecertificatevalidation && !ignorechainverification) {
                TCPSSLTrustManager tm = new TCPSSLTrustManager(indomain, file, password, keystoreType);
                sslClientCntx.engineInit(tm.getKeyManagers(), new TrustManager[]{tm}, null);
                conscryptCntxMap.put(indomain, sslClientCntx);
            } else {
                TCPSSLTrustManager manager = new TCPSSLTrustManager(indomain, file, password, keystoreType);
                if (ignorecertificatevalidation) {
                    manager.ignoreCertificateValidation();
                }
                if (ignorechainverification) {
                    manager.ignoreChainVerification();
                }
                sslClientCntx.engineInit(manager.getKeyManagers(), new TrustManager[]{manager}, null);
            }
            return sslClientCntx;
        }
        catch (Exception ex) {
            return conscryptCntxMap.get("default");
        }
    }

    public static SSLEngine getSSLEngine(SSLContext cntx) {
        return cntx.createSSLEngine();
    }

    public static SSLEngine getSSLEngine(OpenSSLContextImpl cntx) {
        SSLEngine eng = cntx.engineCreateSSLEngine();
        if (conscryptticketresumption) {
            Conscrypt.setUseSessionTickets((SSLEngine)eng, (boolean)true);
        }
        return eng;
    }

    public static void setConscrypt(boolean status) {
        conscrypt = status;
    }

    public static void setConscryptTicketResumption(boolean status) {
        conscryptticketresumption = status;
    }

    public static boolean isConscryptEnabled() {
        return conscrypt;
    }
}

