/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.tcp;

import com.adventnet.wms.nioclient.exception.NIOException;
import com.adventnet.wms.nioclient.exception.NIOSSLCertificateException;
import com.adventnet.wms.nioclient.tcp.ConnectTimeOutListener;
import com.adventnet.wms.nioclient.tcp.PacketAssembler;
import java.io.IOException;
import java.net.ConnectException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetDataProcessor {
    private static Logger logger = Logger.getLogger(NetDataProcessor.class.getName());
    private static LinkedBlockingQueue queue;
    private static LinkedBlockingQueue highpriorityqueue;
    private static ThreadPoolExecutor executor;
    private static ThreadPoolExecutor highpriorityexecutor;
    private static boolean initialized;

    public static void initialize(int threadcount, int maxthreadcount) {
        NetDataProcessor.initialize(threadcount, maxthreadcount, -1, -1);
    }

    public static void initialize(int threadcount, int maxthreadcount, int highprioritythreadcount, int maxhighprioritythreadcount) {
        if (!initialized) {
            queue = new LinkedBlockingQueue();
            executor = new ThreadPoolExecutor(threadcount, maxthreadcount, 100L, TimeUnit.MILLISECONDS, queue);
            if (highprioritythreadcount != -1 && maxhighprioritythreadcount != -1) {
                highpriorityqueue = new LinkedBlockingQueue();
                highpriorityexecutor = new ThreadPoolExecutor(highprioritythreadcount, maxhighprioritythreadcount, 100L, TimeUnit.MILLISECONDS, highpriorityqueue);
            }
            initialized = true;
        }
    }

    public static void process(SelectionKey key, int readyops) throws CancelledKeyException, NIOException {
        PacketAssembler pasm = (PacketAssembler)key.attachment();
        if (pasm == null || !pasm.isValid()) {
            SocketChannel sc = null;
            try {
                sc = (SocketChannel)key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
            }
            try {
                key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
            }
            try {
                if (sc.isOpen()) {
                    sc.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
            }
            return;
        }
        if (!key.isValid() || !((SocketChannel)key.channel()).isOpen()) {
            SocketChannel sc = null;
            try {
                sc = (SocketChannel)key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
            }
            try {
                key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
            }
            try {
                if (sc.isOpen()) {
                    sc.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
            }
            readyops = -1;
        }
        if (pasm.isHighPriority()) {
            highpriorityexecutor.execute(new Processor(key, readyops));
        } else {
            executor.execute(new Processor(key, readyops));
        }
    }

    public static List<List<Runnable>> shutdown() {
        ArrayList<List<Runnable>> list = new ArrayList<List<Runnable>>();
        try {
            if (executor == null && highpriorityexecutor == null) {
                initialized = false;
                return list;
            }
            if (executor != null) {
                List<Runnable> executorlist = executor.shutdownNow();
                list.add(executorlist);
                if (executorlist.isEmpty()) {
                    executor = null;
                }
            }
            if (highpriorityexecutor != null) {
                List<Runnable> highpriorityexecutorlist = highpriorityexecutor.shutdownNow();
                list.add(highpriorityexecutorlist);
                if (highpriorityexecutorlist.isEmpty()) {
                    highpriorityexecutor = null;
                }
            }
            if (executor == null && highpriorityexecutor == null) {
                initialized = false;
            }
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in shutdown ", e);
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }
    }

    static {
        initialized = false;
    }

    static class Processor
    implements Runnable {
        private SelectionKey key = null;
        private int readyops;

        public Processor(SelectionKey key, int readyops) {
            this.key = key;
            this.readyops = readyops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            PacketAssembler pasm = (PacketAssembler)this.key.attachment();
            if (pasm == null || !pasm.isValid()) {
                SocketChannel sc = null;
                try {
                    sc = (SocketChannel)this.key.channel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                }
                try {
                    this.key.cancel();
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                }
                try {
                    if (sc.isOpen()) {
                        sc.close();
                    }
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                }
                return;
            }
            Object object = pasm.getLockObject();
            synchronized (object) {
                block86: {
                    try {
                        if (this.readyops == -1 || !this.key.isValid() || !((SocketChannel)this.key.channel()).isOpen()) {
                            this.close(pasm);
                            return;
                        }
                        if ((this.readyops & 1) == 1) {
                            if (pasm.isSSL() || pasm.isTLS() && pasm.isHSStarted()) {
                                if (!pasm.isHSDone()) {
                                    boolean status = pasm.doHandshake(this.key);
                                    if (status) {
                                        pasm.setHSDone();
                                        this.key.interestOps(1);
                                        pasm.onHandshake();
                                        pasm.readData(this.key);
                                    }
                                } else {
                                    pasm.readData(this.key);
                                    this.key.interestOps(1);
                                }
                            } else {
                                pasm.readData(this.key);
                                this.key.interestOps(1);
                            }
                            break block86;
                        }
                        if ((this.readyops & 4) == 4) {
                            if (pasm.isSSL() && !pasm.isHSDone() || pasm.isTLS() && pasm.isHSStarted() && !pasm.isHSDone()) {
                                boolean hsstaus = pasm.doHandshake(this.key);
                                if (hsstaus) {
                                    pasm.setHSDone();
                                    this.key.interestOps(1);
                                    pasm.onHandshake();
                                    pasm.readData(this.key);
                                }
                            } else {
                                pasm.handleWrite(this.key);
                            }
                            break block86;
                        }
                        if ((this.readyops & 8) != 8) break block86;
                        try {
                            if (!pasm.getSocketChannel().finishConnect()) {
                                if (pasm.isConnectRetryLimitExceeded()) {
                                    ConnectTimeOutListener.TRACKER.remove(pasm.getConnectExpireTime(), this.key);
                                    pasm.onConnectFailure(System.currentTimeMillis() - pasm.getInitConnectTime());
                                    if (this.key != null) {
                                        SocketChannel sc = null;
                                        try {
                                            sc = (SocketChannel)this.key.channel();
                                        }
                                        catch (Exception ex) {
                                            logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                                        }
                                        try {
                                            this.key.cancel();
                                        }
                                        catch (Exception ex) {
                                            logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                                        }
                                        try {
                                            if (sc.isOpen()) {
                                                sc.close();
                                            }
                                        }
                                        catch (Exception ex) {
                                            logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                                        }
                                        this.key.attach(null);
                                    }
                                    return;
                                }
                                this.key.interestOps(8);
                                pasm.incrementConnectRetry();
                                return;
                            }
                            ConnectTimeOutListener.TRACKER.remove(pasm.getConnectExpireTime(), this.key);
                        }
                        catch (Exception ex) {
                            ConnectTimeOutListener.TRACKER.remove(pasm.getConnectExpireTime(), this.key);
                            this.close(pasm);
                            try {
                                pasm.onConnectFailure(System.currentTimeMillis() - pasm.getInitConnectTime());
                                SocketChannel sc = null;
                                try {
                                    sc = (SocketChannel)this.key.channel();
                                }
                                catch (Exception e) {
                                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", e);
                                }
                                try {
                                    this.key.cancel();
                                }
                                catch (Exception e) {
                                    logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", e);
                                }
                                try {
                                    if (sc.isOpen()) {
                                        sc.close();
                                    }
                                }
                                catch (Exception e) {
                                    logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", e);
                                }
                                this.key.attach(null);
                            }
                            catch (Exception sc) {
                                // empty catch block
                            }
                            return;
                        }
                        if (pasm.isSSL()) {
                            if (!pasm.isHSDone()) {
                                boolean status = pasm.doHandshake(this.key);
                                if (status) {
                                    pasm.setHSDone();
                                    this.key.interestOps(1);
                                    pasm.onHandshake();
                                }
                            } else {
                                this.key.interestOps(1);
                                pasm.onConnect();
                            }
                        } else {
                            this.key.interestOps(1);
                            pasm.onConnect();
                        }
                    }
                    catch (ConnectException ce) {
                        logger.log(Level.FINE, "[NIOCLIENT][NET DATA PROCESSOR EXCEPTION]", ce);
                        this.close(pasm);
                        if (ce.getMessage() == null || !ce.getMessage().contains("Connection refused")) break block86;
                        try {
                            if (this.key != null) {
                                pasm.onDisconnect(-2);
                            }
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "Exception ", ex);
                        }
                        return;
                    }
                    catch (NIOSSLCertificateException excep) {
                        logger.log(Level.FINE, "[NIOCLIENT][NET DATA PROCESSOR EXCEPTION]", excep);
                        this.close(pasm);
                        if (this.key == null) break block86;
                        SocketChannel sc = null;
                        try {
                            sc = (SocketChannel)this.key.channel();
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", e);
                        }
                        try {
                            this.key.cancel();
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", e);
                        }
                        try {
                            if (sc.isOpen()) {
                                sc.close();
                            }
                        }
                        catch (Exception e) {
                            logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", e);
                        }
                        this.key.attach(null);
                        return;
                    }
                    catch (IOException ce) {
                        logger.log(Level.FINE, "[NIOCLIENT][NET DATA PROCESSOR EXCEPTION]", ce);
                        this.close(pasm);
                        if (ce.getMessage() != null && ce.getMessage().contains("Connection timed out")) {
                            try {
                                if (this.key != null) {
                                    pasm.onDisconnect(-2);
                                }
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "Exception ", ex);
                            }
                            return;
                        }
                        pasm.onDisconnect(-1);
                        if (this.key != null) {
                            SocketChannel sc = null;
                            try {
                                sc = (SocketChannel)this.key.channel();
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                            }
                            try {
                                this.key.cancel();
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                            }
                            try {
                                if (sc.isOpen()) {
                                    sc.close();
                                }
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                            }
                            this.key.attach(null);
                        }
                        return;
                    }
                    catch (Exception e) {
                        logger.log(Level.FINE, "[NIOCLIENT][NET DATA PROCESSOR EXCEPTION]", e);
                        pasm.onDisconnect(-1);
                        if (this.key != null) {
                            SocketChannel sc = null;
                            try {
                                sc = (SocketChannel)this.key.channel();
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL TYPECAST ", ex);
                            }
                            try {
                                this.key.cancel();
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "EXCEPTION IN KEY CANCEL ", ex);
                            }
                            try {
                                if (sc.isOpen()) {
                                    sc.close();
                                }
                            }
                            catch (Exception ex) {
                                logger.log(Level.INFO, "EXCEPTION IN SOCKET CHANNEL CLOSE ", ex);
                            }
                            this.key.attach(null);
                        }
                        return;
                    }
                }
                if (this.key != null && this.key.isValid() && this.key.interestOps() == 0) {
                    try {
                        this.key.interestOps(1);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }

        private void close(PacketAssembler pasm) {
            try {
                pasm.close();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception tcp close ", ex);
            }
        }
    }
}

