/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import com.adventnet.wms.nioclient.rtsp.SelectorPool;
import com.adventnet.wms.nioclient.rtsp.SelectorPoolImpl;
import java.io.IOException;
import java.util.HashMap;

public class SelectorPoolFactory {
    private static SelectorPoolFactory spool;
    private static HashMap selectorPoolMap;
    private static HashMap highpriorityselectorPoolMap;

    public static SelectorPool getInstance(int port) {
        if (selectorPoolMap.containsKey("" + port)) {
            return (SelectorPool)selectorPoolMap.get(port + "");
        }
        return null;
    }

    public static SelectorPool getHighPriorityInstance(int port) {
        if (highpriorityselectorPoolMap.containsKey("" + port)) {
            return (SelectorPool)highpriorityselectorPoolMap.get("" + port);
        }
        return null;
    }

    public static void init(int port, int count) throws IOException {
        SelectorPoolFactory.init(port, count, -1);
    }

    public static void init(int port, int count, int highprioritycount) throws IOException {
        SelectorPoolFactory.init(port, count, highprioritycount, 100);
    }

    public static void init(int port, int count, int highprioritycount, int timeout) throws IOException {
        SelectorPoolImpl rtsppool = new SelectorPoolImpl(count, timeout);
        ((SelectorPool)rtsppool).init();
        selectorPoolMap.put("" + port, rtsppool);
        if (highprioritycount != -1) {
            SelectorPoolImpl highpriorityrtsppool = new SelectorPoolImpl(highprioritycount);
            ((SelectorPool)highpriorityrtsppool).init();
            highpriorityselectorPoolMap.put("" + port, highpriorityrtsppool);
        }
    }

    static {
        selectorPoolMap = new HashMap();
        highpriorityselectorPoolMap = new HashMap();
    }
}

