/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import java.util.Hashtable;

public class RTSPStatus {
    private static Hashtable statusReasons = new Hashtable();
    public static final int OK = 200;
    public static final int MOVED_PERMANENTLY = 301;
    public static final int MOVED_TEMPORARILY = 302;
    public static final int BAD_REQUEST = 400;
    public static final int UNAUTHORIZED = 401;
    public static final int PAYMENT_REQUIRED = 402;
    public static final int FORBIDDEN = 403;
    public static final int NOT_FOUND = 404;
    public static final int INTERNAL_SERVER_ERROR = 500;
    public static final int SERVICE_UNAVAILABLE = 503;

    private static void addToStatusReasonMap(int code, String reason) {
        if (code != -1 && reason != null && !reason.equals("")) {
            statusReasons.put(code, reason);
        }
    }

    public static String getReasonForRTSPStatus(int code) {
        if (code != -1) {
            return (String)statusReasons.get(code);
        }
        return null;
    }

    static {
        RTSPStatus.addToStatusReasonMap(200, "OK");
        RTSPStatus.addToStatusReasonMap(301, "Moved Permanently");
        RTSPStatus.addToStatusReasonMap(302, "Moved Temporarily");
        RTSPStatus.addToStatusReasonMap(400, "Bad Request");
        RTSPStatus.addToStatusReasonMap(401, "Unauthorized");
        RTSPStatus.addToStatusReasonMap(402, "Payment Required");
        RTSPStatus.addToStatusReasonMap(404, "Not Found");
        RTSPStatus.addToStatusReasonMap(500, "Internal Server Error");
        RTSPStatus.addToStatusReasonMap(503, "Service Unavailable");
    }
}

