/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class RTSPResponse {
    private HashMap headerMap;
    private byte[] body;
    private int statuscode;
    private String statusmessage;
    private int outputdatasize = 1024;
    private ByteArrayOutputStream headerbaos = new ByteArrayOutputStream();
    private static final String NEWLINE = "\r\n";
    private static Logger logger = Logger.getLogger(RTSPResponse.class.getName());

    public RTSPResponse(int statuscode, String statusmessage, String body) throws IOException {
        this(statuscode, statusmessage, body.getBytes("UTF-8"));
    }

    public RTSPResponse(int statuscode, String statusmessage, byte[] body) {
        this.statuscode = statuscode;
        this.statusmessage = statusmessage;
        this.body = body;
        this.headerMap = new HashMap();
    }

    public RTSPResponse() {
        this.headerMap = new HashMap();
    }

    public void setStatusCode(String statuscode) {
        this.statuscode = Integer.parseInt(statuscode);
    }

    public int getStatusCode() {
        return this.statuscode;
    }

    public void setStatusMessage(String statusmessage) {
        this.statusmessage = statusmessage;
    }

    public String getStatusMessage() {
        return this.statusmessage;
    }

    public void addHeader(String key, String value) throws IOException {
        String currentValue = this.getHeader(key);
        if (currentValue == null) {
            this.headerMap.put(key, value);
            this.headerbaos.write((key + ": " + value + NEWLINE).getBytes("UTF-8"));
            return;
        }
        logger.log(Level.INFO, "RTSPResponse -> {0} header already present with value {1}", new Object[]{key, currentValue});
    }

    public void addDefaultHeaders() {
        try {
            this.addHeader("Server", "ZohoWMS");
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception while adding header to response : ", ex);
        }
    }

    public void parseHeader(String key, String value) {
        this.headerMap.put(key, value);
    }

    public boolean isGZIPEncoded() {
        return this.headerMap.get("content-encoding") != null && ((String)this.headerMap.get("content-encoding")).toLowerCase().equals("gzip");
    }

    public void setBody(String data) throws IOException {
        this.setBody(data.getBytes("UTF-8"));
    }

    public void setBody(byte[] data) {
        this.body = data;
        this.outputdatasize += this.body.length;
    }

    public void parseBody(byte[] data) {
        try {
            if (this.isGZIPEncoded()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                GZIPInputStream stream = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] arr = new byte[1024];
                int c = -1;
                while ((c = stream.read(arr)) != -1) {
                    baos.write(arr, 0, c);
                }
                this.body = baos.toByteArray();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in setBody : ", ex);
        }
    }

    public HashMap getHeaders() {
        return this.headerMap;
    }

    public String getHeader(String key) {
        try {
            return (String)this.headerMap.get(key.toLowerCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public int getCSeq() {
        return Integer.parseInt(this.getHeader("CSeq"));
    }

    public ByteBuffer getHeaderInfo() {
        this.addDefaultHeaders();
        return ByteBuffer.wrap(this.headerbaos.toByteArray());
    }

    public byte[] getBody() {
        return this.body;
    }

    public String getRawResponseData() {
        return new String(this.body);
    }

    public boolean isBodyEmpty() {
        return new String(this.body).isEmpty();
    }

    public int getOutputDataSize() {
        return this.outputdatasize;
    }

    public String toString() {
        return "RTSPResponse Info : CODE " + this.statuscode + " MSG " + this.statusmessage + " HEADER " + this.headerMap;
    }
}

