/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import com.adventnet.wms.nioclient.SSLManager;
import com.adventnet.wms.nioclient.SSLWrapper;
import com.adventnet.wms.nioclient.rtsp.ConnectTimeOutListener;
import com.adventnet.wms.nioclient.rtsp.EventDispatcher;
import com.adventnet.wms.nioclient.rtsp.RTSPEventListener;
import com.adventnet.wms.nioclient.rtsp.RTSPInstanceWrapper;
import com.adventnet.wms.nioclient.rtsp.RTSPRequest;
import com.adventnet.wms.nioclient.rtsp.RTSPResponse;
import com.adventnet.wms.nioclient.rtsp.ReadTimeOutListener;
import com.adventnet.wms.nioclient.rtsp.SelectorPoolFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RTSPAgent {
    private static Logger logger = Logger.getLogger(RTSPAgent.class.getName());
    private boolean hsdone = false;
    protected boolean isSSL = false;
    protected ByteBuffer byteBuffer = ByteBuffer.allocate(3072);
    protected ByteBuffer writeBB = null;
    protected String host = null;
    protected int port = -1;
    private String reqType = null;
    protected int zeroReadCount = 0;
    protected int maxZeroReadCount = 25;
    protected static final int MAX_SIZE = 3072;
    private static String NEWLINE = "\r\n";
    protected RTSPResponse response = new RTSPResponse();
    protected boolean headerread = false;
    protected boolean isProxyConnectRequest = false;
    protected int headerLength = 0;
    private ByteBuffer bodyBuffer = null;
    protected SSLWrapper ssl = null;
    protected SocketChannel sc = null;
    private ByteArrayOutputStream headerbaos = new ByteArrayOutputStream();
    private ByteArrayOutputStream bodybaos = null;
    protected RTSPInstanceWrapper connInstWrapper = null;
    protected boolean rtsps = false;
    protected boolean readyToDispatch = false;
    private boolean headerComplete = false;
    private StringBuffer paramBuffer = new StringBuffer();
    private HashMap headerMap = new HashMap();
    private HashMap paramMap = new HashMap();
    protected RTSPEventListener listener = null;
    protected int readtimeout = 30000;
    protected long readexpiretime = -1L;
    protected boolean closed = false;
    protected boolean timeoutstate = true;
    protected SelectionKey key = null;
    private boolean bufferingConnection = true;
    private boolean closeConnection = false;
    private int pendingnlcut = 0;
    protected int pendingcount = 0;
    private ByteBuffer delimitedBuffer = null;
    private ByteArrayOutputStream delimbaos = new ByteArrayOutputStream();
    protected boolean tmentryadded = false;
    protected Object lock = new Object();
    private boolean writeCompleted = false;
    private long initConnectTime;
    protected long bytesRead = 0L;
    protected long bytesWritten = 0L;
    private long connectexpiretime;
    protected boolean isWebsocketConnection = false;
    protected boolean streamwrite = false;
    protected HashMap statReports = new LinkedHashMap();
    protected HashMap<String, RTSPInstanceWrapper> instMap = new HashMap();
    private boolean redirect = false;
    private boolean streammode = false;
    private RTSPRequest serverRequest = new RTSPRequest();
    private Object streamlock = new Object();
    private int currentreqid = -1;
    private long totalReadTime;
    private long readInitTime;
    private long lastWriteTime;
    private long totalWriteTime;

    public RTSPAgent(String host, int port) throws Exception {
        this.host = host;
        this.port = port;
    }

    public void setListener(RTSPEventListener listener) {
        this.listener = listener;
    }

    private boolean isValidRequestType(String reqType) {
        return reqType != null && reqType.matches("OPTIONS|DESCRIBE|PLAY|PAUSE|TEARDOWN|GET_PARAMETER|SET_PARAMETER|REDIRECT");
    }

    public void setReadBufferSize(int size) {
        this.byteBuffer = ByteBuffer.allocate(size);
    }

    public void resetForNewRead() throws Exception {
        this.headerLength = 0;
        this.headerComplete = false;
        this.headerread = false;
        this.readyToDispatch = false;
        this.response = new RTSPResponse();
        this.serverRequest = new RTSPRequest();
    }

    public void setReadTimeout(int timeout) {
        this.readtimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readtimeout;
    }

    public void setTimeOutState(boolean state) {
        this.timeoutstate = state;
    }

    public String getHost() {
        return this.host.replaceAll("rtsp://|rtsps://", "").replaceAll(":.*", "").replaceAll("/.*", "");
    }

    private int getPort() {
        return this.port;
    }

    private String getDestURL(String url) throws IOException {
        try {
            if (this.isSSL()) {
                return "rtsps:/" + url;
            }
            return "rtsp:/" + url;
        }
        catch (Exception ex) {
            throw new IOException("Unsupported URL during client request : " + url);
        }
    }

    private String getURI(String url) throws IOException {
        try {
            if (this.isSSL()) {
                return url.split("rtsps:/")[1];
            }
            return url.split("rtsp:/")[1];
        }
        catch (Exception ex) {
            throw new IOException("Unsupported URL during server request : " + url);
        }
    }

    public void setSocketChannel(SocketChannel sc) {
        try {
            this.sc = sc;
            this.initConnectTime = System.currentTimeMillis();
            if (this.isSSL) {
                this.ssl = new SSLWrapper(sc, this.getHost());
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in setSocketChannel : ", e);
        }
    }

    public void setHSDone() {
        this.hsdone = true;
    }

    public boolean isHSDone() {
        return this.hsdone;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void connect() throws IOException {
        this.connect(20000L);
    }

    public void connect(long timeout) throws IOException {
        this.createInstanceWrapper();
        SelectorPoolFactory.getInstance(this.port).connect(this.getHost(), this.port, this, timeout);
        this.statReports.put("inittime", System.currentTimeMillis());
    }

    public void createInstanceWrapper() {
        this.connInstWrapper = new RTSPInstanceWrapper(this.host, "" + this.port, -1);
    }

    protected boolean isRTSPs() {
        return this.isRTSPs(this.host);
    }

    protected boolean isRTSPs(String url) {
        if (this.host.startsWith("rtsps://") || this.host.startsWith("wss://")) {
            this.rtsps = true;
            return this.rtsps;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sendResponse(int instanceId, RTSPResponse rtspResponse) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long initWriteTime = System.currentTimeMillis();
            rtspResponse.addHeader("CSeq", "" + instanceId);
            ByteBuffer writeBB = ByteBuffer.allocate(rtspResponse.getOutputDataSize());
            String fline = null;
            fline = "RTSP/2.0 " + rtspResponse.getStatusCode() + " " + rtspResponse.getStatusMessage() + NEWLINE;
            writeBB.put(fline.getBytes("UTF-8"));
            writeBB.put(rtspResponse.getHeaderInfo());
            writeBB.put(NEWLINE.getBytes());
            if (rtspResponse.getBody() != null) {
                writeBB.put(rtspResponse.getBody());
            }
            long written = this.writeData(writeBB);
            RTSPInstanceWrapper instWrapper = this.instMap.get("" + instanceId);
            instWrapper.setResponse(rtspResponse);
            if (this.timeoutstate && !this.tmentryadded) {
                this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                ReadTimeOutListener.TRACKER.touch(this.readexpiretime, this);
                this.tmentryadded = true;
            }
            this.bytesWritten += written;
            this.lastWriteTime = System.currentTimeMillis();
            this.totalWriteTime += this.lastWriteTime - initWriteTime;
            this.instMap.remove("" + instanceId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int sendRequest(RTSPRequest rtspRequest) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            long initWriteTime = System.currentTimeMillis();
            if (!this.statReports.containsKey("writeinittime")) {
                this.statReports.put("writeinittime", System.currentTimeMillis());
            }
            rtspRequest.addHeader("CSeq", "" + ++this.currentreqid);
            RTSPInstanceWrapper instanceWrapper = new RTSPInstanceWrapper(this.host, "" + this.port, this.currentreqid);
            String fline = null;
            fline = rtspRequest.getType() + " " + this.getDestURL(rtspRequest.getURI()) + " " + "RTSP/2.0" + NEWLINE;
            ByteBuffer writeBB = ByteBuffer.allocate(rtspRequest.getInputDataSize());
            writeBB.put(fline.getBytes("UTF-8"));
            writeBB.put(rtspRequest.getHeaderInfo());
            writeBB.put(NEWLINE.getBytes());
            if (rtspRequest.getBody() != null) {
                writeBB.put(rtspRequest.getBody());
            }
            long written = this.writeData(writeBB);
            instanceWrapper.setRequest(rtspRequest);
            this.instMap.put("" + this.currentreqid, instanceWrapper);
            if (this.timeoutstate && !this.tmentryadded) {
                this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                ReadTimeOutListener.TRACKER.touch(this.readexpiretime, this);
                this.tmentryadded = true;
            }
            this.bytesWritten += written;
            this.lastWriteTime = System.currentTimeMillis();
            this.totalWriteTime += this.lastWriteTime - initWriteTime;
            EventDispatcher.process(this, 2, this.currentreqid);
            return this.currentreqid;
        }
    }

    private long writeData(ByteBuffer writeBB) throws IOException {
        long written = 0L;
        if (this.isSSL) {
            writeBB.flip();
            while (writeBB.hasRemaining()) {
                if (this.ssl.doHandshake(this.key)) {
                    written = this.ssl.write(writeBB);
                }
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        } else {
            writeBB.flip();
            while (writeBB.hasRemaining()) {
                written = this.sc.write(writeBB);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
            }
        }
        return written;
    }

    public long getReadExpireTime() {
        return this.readexpiretime;
    }

    public boolean isInvalidReadTimeoutEntry(long time) {
        return false;
    }

    public boolean isConnectionOpen() {
        try {
            return this.sc.isOpen();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public boolean doHandshake(SelectionKey key) throws IOException {
        if (this.key == null) {
            this.key = key;
        }
        boolean status = this.ssl.doHandshake(key);
        if (this.isSSL) {
            for (Map.Entry pair : this.ssl.handshakeReports().entrySet()) {
                this.statReports.put(pair.getKey(), pair.getValue());
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readData(SelectionKey key) throws Exception {
        block26: {
            Object object = this.lock;
            synchronized (object) {
                int count;
                block27: {
                    if (this.isClosed()) {
                        return;
                    }
                    this.readInitTime = System.currentTimeMillis();
                    if (this.key == null) {
                        this.key = key;
                    }
                    count = -1;
                    if (this.isSSL) {
                        if (!this.ssl.doHandshake(key)) {
                            return;
                        }
                        count = this.ssl.read();
                        this.byteBuffer = this.ssl.getDataBuffer();
                    } else {
                        count = ((SocketChannel)key.channel()).read(this.byteBuffer);
                    }
                    if (!this.isProxyConnectRequest) {
                        this.bytesRead += (long)count;
                    }
                    if (count <= 0) break block27;
                    this.zeroReadCount = 0;
                    this.pendingcount = count;
                    if (this.isHeaderComplete(this.byteBuffer)) {
                        if (this.timeoutstate && !this.closed) {
                            long oldTime = this.readexpiretime;
                            this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                            ReadTimeOutListener.TRACKER.update(oldTime, this.readexpiretime, this);
                        }
                        if (this.readyToDispatch) {
                            key.interestOps(1);
                            this.clearBuffer(this.byteBuffer);
                            this.resetForNewRead();
                            return;
                        }
                        if (!this.byteBuffer.hasRemaining()) {
                            key.interestOps(1);
                            this.clearBuffer(this.byteBuffer);
                            return;
                        }
                        if (this.bodyBuffer != null) {
                            if (this.bodyBuffer.limit() - this.bodyBuffer.position() == this.byteBuffer.remaining()) {
                                byte[] data = new byte[this.bodyBuffer.limit() - this.bodyBuffer.position()];
                                this.byteBuffer.get(data);
                                this.bodyBuffer.put(data);
                                byte[] clientData = new byte[this.bodyBuffer.limit()];
                                this.bodyBuffer.flip();
                                this.bodyBuffer.get(clientData);
                                if (this.response != null) {
                                    this.response.setBody(clientData);
                                    EventDispatcher.process(this, 3, this.response.getCSeq());
                                    data = null;
                                    clientData = null;
                                    this.readyToDispatch = true;
                                    this.bodyBuffer = null;
                                    this.resetForNewRead();
                                    if (this.byteBuffer.remaining() > 0) {
                                        this.resizeBuffer(this.byteBuffer);
                                        key.interestOps(key.interestOps() | 1);
                                        return;
                                    }
                                } else {
                                    if (this.serverRequest == null) {
                                        throw new IOException("Neither request nor response " + new String(clientData));
                                    }
                                    this.serverRequest.setBody(clientData);
                                    EventDispatcher.process(this, 7, this.serverRequest.getCSeq());
                                    this.readyToDispatch = true;
                                    this.bodyBuffer = null;
                                }
                            } else {
                                byte[] data = new byte[this.pendingcount];
                                this.byteBuffer.get(data);
                                this.bodyBuffer.put(data);
                                data = null;
                                key.interestOps(1);
                            }
                        }
                        this.clearBuffer(this.byteBuffer);
                        break block26;
                    } else if (this.closeConnection) {
                        this.clearBuffer(this.byteBuffer);
                        EventDispatcher.process(this, 3);
                        this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                        this.close();
                        break block26;
                    } else {
                        key.interestOps(1);
                    }
                    break block26;
                }
                if (count < 0) {
                    this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                    throw new IOException("Read -1");
                }
                if (count == 0) {
                    ++this.zeroReadCount;
                    key.interestOps(1);
                    if (this.zeroReadCount > this.maxZeroReadCount) {
                        this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                        throw new IOException("Key Read Count = 0 : Max Crossed");
                    }
                }
            }
        }
        this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
    }

    protected void clearBuffer(ByteBuffer bb) {
        if (this.isSSL) {
            this.ssl.clearDataBuffer();
        }
        bb.clear();
    }

    protected void resizeBuffer(ByteBuffer bb) {
        if (this.isSSL) {
            this.ssl.resizeDataBuffer();
        }
        byte[] b = new byte[bb.remaining()];
        bb.get(b);
        bb.clear();
        bb.put(b);
    }

    protected boolean isHeaderComplete(ByteBuffer bb) throws Exception {
        if (this.headerComplete && this.headerread) {
            bb.flip();
            return true;
        }
        if (!this.headerComplete && !this.isProperRTSPResponseOrRequest(bb)) {
            this.closeConnection = true;
            this.response.setStatusCode("403");
            return this.headerComplete;
        }
        for (int i = 0; i <= bb.position() - 4 && !this.headerComplete; ++i) {
            if (bb.get(i) != 13 || bb.get(i + 1) != 10 || bb.get(i + 2) != 13 || bb.get(i + 3) != 10) continue;
            this.headerComplete = true;
            this.headerLength = i + 4;
        }
        if (this.headerComplete) {
            if (this.isRequest(bb)) {
                this.parseRequest(bb);
            } else {
                this.parseResponse(bb);
            }
        }
        return this.headerComplete;
    }

    protected boolean isProperRTSPResponseOrRequest(ByteBuffer tempbb) {
        boolean valid = false;
        try {
            if (tempbb.get(0) == 82 && tempbb.get(1) == 84 && tempbb.get(2) == 83 && tempbb.get(3) == 80) {
                valid = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception - RESPONSE CHECK isProperRTSPResponseOrRequest : ", e);
        }
        try {
            if (this.isRequest(tempbb)) {
                valid = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception - REQUEST CHECK isProperRTSPResponseOrRequest : ", e);
        }
        return valid;
    }

    private boolean isRequest(ByteBuffer bb) {
        String request = new String(bb.array());
        String requestType = request.split(" ")[0];
        return this.isValidRequestType(requestType);
    }

    public void parseRequest(ByteBuffer bb) throws IOException {
        int instanceId = -1;
        if (!this.headerread) {
            bb.flip();
            byte[] headerData = new byte[this.headerLength];
            bb.get(headerData);
            this.pendingcount -= headerData.length;
            BufferedReader br = new BufferedReader(new StringReader(new String(headerData)));
            String line = br.readLine();
            String[] tokens = line.split(" ");
            String reqType = tokens[0];
            String reqURL = tokens[1];
            String version = tokens[2];
            if (tokens.length > 3) {
                throw new IOException("Request -> Invalid RTSP status line in response " + line);
            }
            this.serverRequest.setType(reqType);
            this.serverRequest.setURI(this.getURI(reqURL));
            this.serverRequest.setVersion(version);
            while ((line = br.readLine()) != null && !line.equals("")) {
                tokens = line.split(": ", 2);
                if (tokens.length == 2) {
                    this.serverRequest.parseHeader(tokens[0].toLowerCase(), tokens[1]);
                    continue;
                }
                logger.log(Level.INFO, "MALFORMWRONGHEADER {0}", new Object[]{line});
            }
            headerData = null;
        }
        if (this.serverRequest.getHeader("CSeq") == null) {
            throw new IOException("Improper RTSPRequest : " + this.serverRequest);
        }
        instanceId = Integer.parseInt(this.serverRequest.getHeader("CSeq"));
        RTSPInstanceWrapper instWrapper = new RTSPInstanceWrapper(this.host, "" + this.port, instanceId);
        instWrapper.setRequest(this.serverRequest);
        this.instMap.put("" + instanceId, instWrapper);
        if (this.serverRequest.getHeader("content-length") != null) {
            byte[] data;
            String contentLength = this.serverRequest.getHeader("content-length");
            int length = Integer.parseInt(contentLength.trim());
            if (length == 0) {
                this.readyToDispatch = true;
                this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                EventDispatcher.process(this, 7, instanceId);
                return;
            }
            if (bb.remaining() == 0) {
                this.bodyBuffer = ByteBuffer.allocate(length);
                return;
            }
            if (length > 0 && bb.remaining() >= length) {
                data = new byte[length];
                bb.get(data);
                this.pendingcount -= data.length;
                this.serverRequest.setBody(data);
                data = null;
                this.readyToDispatch = true;
                this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                EventDispatcher.process(this, 7, instanceId);
            } else if (bb.remaining() > 0 && bb.remaining() < length) {
                data = new byte[bb.remaining()];
                bb.get(data);
                this.pendingcount -= data.length;
                this.bodyBuffer = ByteBuffer.allocate(length);
                this.bodyBuffer.put(data);
            }
        } else {
            this.readyToDispatch = true;
            EventDispatcher.process(this, 7, instanceId);
        }
    }

    public void parseResponse(ByteBuffer bb) throws IOException {
        int instanceId = -1;
        if (!this.headerread) {
            bb.flip();
            byte[] headerData = new byte[this.headerLength];
            bb.get(headerData);
            this.pendingcount -= headerData.length;
            BufferedReader br = new BufferedReader(new StringReader(new String(headerData)));
            String line = br.readLine();
            String[] tokens = line.split(" ");
            String version = tokens[0];
            String responsecode = tokens[1];
            String responsestatusmsg = "";
            if (tokens.length >= 3) {
                responsestatusmsg = line.substring(version.length() + responsecode.length() + 2, line.length());
            } else if (!Character.isSpace(line.charAt(line.length() - 1))) {
                throw new IOException("Invalid RTSP status line in response " + line);
            }
            this.response.setStatusCode(responsecode);
            this.response.setStatusMessage(responsestatusmsg);
            String rawUrl = tokens[1];
            while ((line = br.readLine()) != null && !line.equals("")) {
                tokens = line.split(": ", 2);
                if (tokens.length == 2) {
                    this.response.parseHeader(tokens[0].toLowerCase(), tokens[1]);
                    continue;
                }
                logger.log(Level.INFO, "MALFORMWRONGHEADER {0}", new Object[]{line});
            }
            headerData = null;
        }
        this.headerread = true;
        int code = this.response.getStatusCode();
        if (this.response.getHeader("CSeq") == null) {
            throw new IOException("Improper RTSP response : " + this.response);
        }
        instanceId = Integer.parseInt(this.response.getHeader("CSeq"));
        RTSPInstanceWrapper instWrapper = this.instMap.get("" + instanceId);
        if (instWrapper == null) {
            throw new IOException("Request not made for instance : " + this.response.getHeader("CSeq"));
        }
        instWrapper.setResponse(this.response);
        if (this.response.getHeader("content-length") != null) {
            byte[] data;
            String respLength = this.response.getHeader("content-length");
            int length = Integer.parseInt(respLength.trim());
            if (length == 0) {
                this.readyToDispatch = true;
                this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                EventDispatcher.process(this, 3, instanceId);
                return;
            }
            if (bb.remaining() == 0) {
                this.bodyBuffer = ByteBuffer.allocate(length);
                return;
            }
            if (length > 0 && bb.remaining() >= length) {
                data = new byte[length];
                bb.get(data);
                this.pendingcount -= data.length;
                this.response.setBody(data);
                data = null;
                this.readyToDispatch = true;
                this.totalReadTime += System.currentTimeMillis() - this.readInitTime;
                EventDispatcher.process(this, 3, instanceId);
            } else if (bb.remaining() > 0 && bb.remaining() < length) {
                data = new byte[bb.remaining()];
                bb.get(data);
                this.pendingcount -= data.length;
                this.bodyBuffer = ByteBuffer.allocate(length);
                this.bodyBuffer.put(data);
            }
        } else {
            this.readyToDispatch = true;
            EventDispatcher.process(this, 3, instanceId);
        }
    }

    public boolean isValidDomain(String domain) {
        return SSLManager.getExternalDomains().contains(domain);
    }

    public void updateValidDomain(String domain) {
        SSLManager.updateExternalDomains(domain);
    }

    public boolean isPortInitiated(int port) {
        return SelectorPoolFactory.getInstance(port) != null;
    }

    public void initializeSelectorpool(int port) {
        try {
            SelectorPoolFactory.init(port, 2);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception - init selectorpool : ", ex);
        }
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
        if (this.isSSL()) {
            this.ssl.setSelectionKey(key);
        }
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public long getInitConnectTime() {
        return this.initConnectTime;
    }

    public void setConnectExpireTime(long time) {
        this.connectexpiretime = time;
    }

    public long getConnectExpireTime() {
        return this.connectexpiretime;
    }

    public boolean isConnectExpired() {
        return System.currentTimeMillis() >= this.connectexpiretime;
    }

    public boolean isInvalidConnectExpireTime(long time) {
        return time != this.connectexpiretime;
    }

    private boolean isConnectionAlive() {
        try {
            int count = -1;
            if (this.isSSL) {
                count = this.ssl.read();
            } else {
                ByteBuffer bf = ByteBuffer.allocate(0);
                count = this.sc.read(bf);
            }
            return count != -1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isCloseable() {
        try {
            if (this.isConnectionOpen() && this.isConnectionAlive()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                if (this.isSSL) {
                    this.ssl.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in ssl close : ", ex);
            }
            SocketChannel ch = null;
            try {
                ch = (SocketChannel)this.key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel : ", ex);
            }
            try {
                this.key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key cancel : ", ex);
            }
            try {
                if (ch.isOpen()) {
                    ch.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel close : ", ex);
            }
            this.closed = true;
            this.statReports.put("closetime", System.currentTimeMillis());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getLockObject() {
        return this.lock;
    }

    public void notifyListener(int event) throws Exception {
        this.notifyListener(event, -1);
    }

    public void notifyListener(int event, int instanceId) throws Exception {
        RTSPInstanceWrapper instanceWrapper = null;
        if (instanceId == -1) {
            instanceWrapper = this.connInstWrapper;
        } else {
            instanceWrapper = this.instMap.get("" + instanceId);
            if (instanceWrapper == null) {
                throw new IOException("Instance not requested : " + instanceId);
            }
        }
        switch (event) {
            case 1: {
                this.listener.onConnect(instanceWrapper);
                return;
            }
            case -1: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.listener.onConnectError(instanceWrapper);
                return;
            }
            case -2: {
                this.listener.onReadTimeout(instanceWrapper);
                return;
            }
            case 2: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                if (!this.redirect) {
                    this.listener.onSubmit(instanceWrapper);
                }
                return;
            }
            case -3: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.listener.onSubmitError(instanceWrapper);
                return;
            }
            case 7: {
                try {
                    this.listener.onRequest(instanceWrapper);
                    return;
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in notifyListener : ", ex);
                }
            }
            case 3: {
                int code = instanceWrapper.getResponse().getStatusCode();
                if (code >= 400) {
                    this.listener.onResponseError(instanceWrapper);
                    return;
                }
                try {
                    this.listener.onResponse(instanceWrapper);
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in notifyListener : ", ex);
                }
                this.instMap.remove("" + instanceId);
                return;
            }
            case -4: {
                try {
                    this.listener.onResponseError(instanceWrapper);
                    return;
                }
                catch (Exception exception) {
                    this.instMap.remove("" + instanceId);
                }
            }
            case -5: {
                this.listener.onDisconnect(instanceWrapper);
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                return;
            }
        }
        throw new IOException("Invalid event called : " + event);
    }

    public void setInterestOps(int op) {
        this.key.interestOps(op);
    }

    public HashMap getReports(boolean humanReadable) {
        LinkedHashMap humanReadableStats = new LinkedHashMap();
        if (humanReadable) {
            for (Map.Entry pair : this.statReports.entrySet()) {
                if (pair.getKey() == "bytesread" || pair.getKey() == "byteswritten" || pair.getKey() == "readtime" || pair.getKey() == "writetime" || pair.getKey() == "handshaketime") {
                    humanReadableStats.put(pair.getKey(), pair.getValue());
                    continue;
                }
                humanReadableStats.put(pair.getKey(), new Date(Long.parseLong(pair.getValue().toString())));
            }
            return humanReadableStats;
        }
        return this.statReports;
    }
}

