/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.rtsp;

import com.adventnet.wms.nioclient.rtsp.EventDispatcher;
import com.adventnet.wms.nioclient.rtsp.NetworkEventProcessor;
import com.adventnet.wms.nioclient.rtsp.RTSPAgent;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIONetDataProcessor {
    private static Logger logger = Logger.getLogger(NIONetDataProcessor.class.getName());
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor = null;
    private static boolean initialized = false;

    public static void initialize(int threadCount, int maxThreadCount) {
        executor = new ThreadPoolExecutor(threadCount, maxThreadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(SelectionKey key, int readyops) {
        RTSPAgent agentObj = (RTSPAgent)key.attachment();
        if (agentObj == null) {
            SocketChannel ch = null;
            try {
                ch = (SocketChannel)key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Channel type cast exp", ex);
            }
            try {
                key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key cancel", ex);
            }
            try {
                if (ch.isOpen()) {
                    ch.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel close for client", ex);
            }
            return;
        }
        if (!key.isValid() || !((SocketChannel)key.channel()).isOpen()) {
            key.cancel();
            readyops = -1;
        }
        executor.execute(new Processor(key, readyops));
    }

    public static List<List<Runnable>> shutdown() {
        ArrayList<List<Runnable>> list = new ArrayList<List<Runnable>>();
        try {
            if (executor == null) {
                initialized = false;
                return list;
            }
            if (executor != null) {
                List<Runnable> executorlist = executor.shutdownNow();
                list.add(executorlist);
                executor = null;
                initialized = false;
            }
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in NIOnetdata processor shutdown ", e);
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }
    }

    static class Processor
    implements Runnable {
        private SelectionKey key = null;
        private int readyops;

        public Processor(SelectionKey key, int readyops) {
            this.key = key;
            this.readyops = readyops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block40: {
                RTSPAgent agent = null;
                try {
                    agent = (RTSPAgent)this.key.attachment();
                    Object object = agent.getLockObject();
                    synchronized (object) {
                        if (this.readyops == -1 || !this.key.isValid() || !((SocketChannel)this.key.channel()).isOpen()) {
                            logger.warning("Key not valid for agent " + agent);
                            NetworkEventProcessor.process(agent, -5);
                            return;
                        }
                        if ((this.readyops & 1) == 1 || (this.readyops & 4) == 4) {
                            if (agent.isSSL()) {
                                if (!agent.isHSDone()) {
                                    try {
                                        boolean status = agent.doHandshake(this.key);
                                        if (status) {
                                            agent.setHSDone();
                                            NetworkEventProcessor.process(agent, 1);
                                        }
                                        this.key.interestOps(5);
                                    }
                                    catch (IOException ioex) {
                                        EventDispatcher.process(agent, -1);
                                        throw ioex;
                                    }
                                } else {
                                    agent.readData(this.key);
                                    this.key.interestOps(1);
                                }
                            } else {
                                agent.readData(this.key);
                                this.key.interestOps(1);
                            }
                        }
                    }
                }
                catch (CancelledKeyException cke) {
                    NetworkEventProcessor.process(agent, -5);
                    SocketChannel ch = null;
                    try {
                        ch = (SocketChannel)this.key.channel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Channel type cast exp", ex);
                    }
                    try {
                        this.key.cancel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key cancel ", ex);
                    }
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                    }
                    return;
                }
                catch (IOException excep) {
                    NetworkEventProcessor.process(agent, -5);
                    logger.log(Level.INFO, "SEVERE : NIONetDataProcessor : IOException  [ATTACHMENT] {0} [MESSAGE] {1}", new Object[]{this.key.attachment(), excep});
                    SocketChannel ch = null;
                    try {
                        ch = (SocketChannel)this.key.channel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Channel type cast exp", ex);
                    }
                    try {
                        this.key.cancel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key cancel ", ex);
                    }
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                    }
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception in NIONetDataProcessor ", e);
                    NetworkEventProcessor.process(agent, -5);
                    if (this.key == null) break block40;
                    SocketChannel ch = null;
                    try {
                        ch = (SocketChannel)this.key.channel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Channel type cast exp", ex);
                    }
                    try {
                        this.key.cancel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key cancel ", ex);
                    }
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                    }
                    this.key.attach(null);
                    return;
                }
            }
            if (this.key != null && this.key.isValid() && this.key.interestOps() == 0) {
                try {
                    this.key.interestOps(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

