/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.VariableTimeOutListener;
import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequest;
import java.util.ArrayList;
import java.util.logging.Logger;

public class ReadTimeOutListener
extends VariableTimeOutListener {
    private static final Logger logger = Logger.getLogger(ReadTimeOutListener.class.getName());
    private static final Logger mtlogger = Logger.getLogger("messagetracker");
    public static final ReadTimeOutListener TRACKER = new ReadTimeOutListener();

    private ReadTimeOutListener() {
        super("ReadTimeOutListener", 10000L);
    }

    @Override
    public boolean isExpired(Object obj) {
        return System.currentTimeMillis() >= ((HttpRequest)obj).getReadExpireTime();
    }

    @Override
    public boolean isInvalidEntry(Object obj, long time) {
        return ((HttpRequest)obj).isInvalidReadTimeoutEntry(time);
    }

    @Override
    public void handleExpired(ArrayList list) {
        logger.info("Expired Request List " + list.size());
        long readexpired = 0L;
        for (HttpRequest client : list) {
            try {
                if (!client.isClosed()) {
                    EventDispatcher.process(client, -2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                client.close();
            }
            catch (Exception exception) {}
        }
        if (readexpired > 0L) {
            mtlogger.info("Incomplete Read count " + readexpired);
        }
    }
}

