/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequest;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NetworkEventProcessor {
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor;
    private static boolean initialized;
    private static Logger logger;

    public static synchronized void initialize(int threadCount) {
        if (initialized) {
            return;
        }
        executor = new ThreadPoolExecutor(threadCount, threadCount, 100L, TimeUnit.MILLISECONDS, queue);
        initialized = true;
    }

    public static void process(HttpRequest request, int eventcode) {
        if (!initialized) {
            NetworkEventProcessor.initialize(2);
        }
        executor.execute(new RequestNetworkEventProcessor(request, eventcode));
    }

    public static List<Runnable> shutdown() {
        List<Runnable> list = new ArrayList<Runnable>();
        try {
            if (executor == null) {
                initialized = false;
                return list;
            }
            list = executor.shutdownNow();
            if (list.isEmpty()) {
                executor = null;
                initialized = false;
            }
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in networkevent processor shutdown ", e);
            return null;
        }
    }

    static {
        initialized = false;
        logger = Logger.getLogger(NetworkEventProcessor.class.getName());
    }

    static class RequestNetworkEventProcessor
    implements Runnable {
        private HttpRequest request;
        private int eventcode;

        public RequestNetworkEventProcessor(HttpRequest request, int eventcode) {
            this.request = request;
            this.eventcode = eventcode;
        }

        @Override
        public void run() {
            try {
                switch (this.eventcode) {
                    case 1: {
                        try {
                            this.request.writeData();
                        }
                        catch (Exception ex) {
                            logger.log(Level.INFO, "Exception in RequestNetworkEventProcessor : ", ex);
                            if (this.request.isClosed()) break;
                            try {
                                this.request.close();
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                            EventDispatcher.process(this.request, -3);
                        }
                        break;
                    }
                    case -5: {
                        if (this.request.isClosed()) break;
                        try {
                            this.request.close();
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                        EventDispatcher.process(this.request, -5);
                    }
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in RequestNetworkEventProcessor ", ex);
            }
        }
    }
}

