/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpRequest;
import com.adventnet.wms.nioclient.http.NetworkEventProcessor;
import java.io.IOException;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIONetDataProcessor {
    private static Logger logger = Logger.getLogger(NIONetDataProcessor.class.getName());
    private static LinkedBlockingQueue queue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor executor = null;
    private static LinkedBlockingQueue highpriorityqueue = new LinkedBlockingQueue();
    private static ThreadPoolExecutor highpriorityexecutor = null;
    private static boolean initialized = false;

    public static void initialize(int threadCount, int maxThreadCount) {
        NIONetDataProcessor.initialize(threadCount, maxThreadCount, -1, -1);
    }

    public static void initialize(int threadCount, int maxThreadCount, int highprioritythreadcount, int maxhighprioritythreadcount) {
        if (!initialized) {
            executor = new ThreadPoolExecutor(threadCount, maxThreadCount, 100L, TimeUnit.MILLISECONDS, queue);
            if (highprioritythreadcount != -1) {
                highpriorityexecutor = new ThreadPoolExecutor(highprioritythreadcount, maxhighprioritythreadcount, 100L, TimeUnit.MILLISECONDS, highpriorityqueue);
            }
            initialized = true;
        }
    }

    public static void process(SelectionKey key, int readyops) {
        HttpRequest requestObj = (HttpRequest)key.attachment();
        if (requestObj == null) {
            SocketChannel ch = null;
            try {
                ch = (SocketChannel)key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Channel type cast exp", ex);
            }
            try {
                key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key cancel", ex);
            }
            try {
                if (ch.isOpen()) {
                    ch.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel close for client", ex);
            }
            return;
        }
        if (!key.isValid() || !((SocketChannel)key.channel()).isOpen()) {
            key.cancel();
            readyops = -1;
        }
        if (requestObj.isHighPriority()) {
            highpriorityexecutor.execute(new Processor(key, readyops));
        } else {
            executor.execute(new Processor(key, readyops));
        }
    }

    public static List<List<Runnable>> shutdown() {
        ArrayList<List<Runnable>> list = new ArrayList<List<Runnable>>();
        try {
            if (executor == null && highpriorityexecutor == null) {
                initialized = false;
                return list;
            }
            if (executor != null) {
                List<Runnable> executorlist = executor.shutdownNow();
                list.add(executorlist);
                if (executorlist.isEmpty()) {
                    executor = null;
                }
            }
            if (highpriorityexecutor != null) {
                List<Runnable> highpriorityexecutorlist = highpriorityexecutor.shutdownNow();
                list.add(highpriorityexecutorlist);
                if (highpriorityexecutorlist.isEmpty()) {
                    highpriorityexecutor = null;
                }
            }
            if (executor == null && highpriorityexecutor == null) {
                initialized = false;
            }
            return list;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in NIOnetdata processor shutdown ", e);
            if (list.isEmpty()) {
                return null;
            }
            return list;
        }
    }

    static class Processor
    implements Runnable {
        private SelectionKey key = null;
        private int readyops;

        public Processor(SelectionKey key, int readyops) {
            this.key = key;
            this.readyops = readyops;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block40: {
                HttpRequest request = null;
                try {
                    request = (HttpRequest)this.key.attachment();
                    Object object = request.getLockObject();
                    synchronized (object) {
                        if (this.readyops == -1 || !this.key.isValid() || !((SocketChannel)this.key.channel()).isOpen()) {
                            logger.warning("Key not valid for request " + request);
                            NetworkEventProcessor.process(request, -5);
                            return;
                        }
                        if ((this.readyops & 1) == 1 || (this.readyops & 4) == 4) {
                            if (request.isSSL()) {
                                if (!request.isHSDone()) {
                                    try {
                                        boolean status = request.doHandshake(this.key);
                                        if (status) {
                                            request.setHSDone();
                                            NetworkEventProcessor.process(request, 1);
                                        }
                                        this.key.interestOps(5);
                                    }
                                    catch (IOException ioex) {
                                        EventDispatcher.process(request, -1);
                                        throw ioex;
                                    }
                                } else {
                                    request.readData(this.key);
                                    this.key.interestOps(1);
                                }
                            } else {
                                request.readData(this.key);
                                this.key.interestOps(1);
                            }
                        }
                    }
                }
                catch (CancelledKeyException cke) {
                    NetworkEventProcessor.process(request, -5);
                    SocketChannel ch = null;
                    try {
                        ch = (SocketChannel)this.key.channel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Channel type cast exp", ex);
                    }
                    try {
                        this.key.cancel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key cancel ", ex);
                    }
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                    }
                    return;
                }
                catch (IOException excep) {
                    NetworkEventProcessor.process(request, -5);
                    logger.log(Level.INFO, "SEVERE : NIONetDataProcessor : IOException  [ATTACHMENT] {0} [MESSAGE] {1}", new Object[]{this.key.attachment(), excep});
                    SocketChannel ch = null;
                    try {
                        ch = (SocketChannel)this.key.channel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Channel type cast exp", ex);
                    }
                    try {
                        this.key.cancel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key cancel ", ex);
                    }
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                    }
                    return;
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception in NIONetDataProcessor ", e);
                    NetworkEventProcessor.process(request, -5);
                    if (this.key == null) break block40;
                    SocketChannel ch = null;
                    try {
                        ch = (SocketChannel)this.key.channel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Channel type cast exp", ex);
                    }
                    try {
                        this.key.cancel();
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key cancel ", ex);
                    }
                    try {
                        if (ch.isOpen()) {
                            ch.close();
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in key channel close for client ", ex);
                    }
                    this.key.attach(null);
                    return;
                }
            }
            if (this.key != null && this.key.isValid() && this.key.interestOps() == 0) {
                try {
                    this.key.interestOps(1);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }
}

