/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.Part;
import java.io.ByteArrayOutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Multipart {
    public static final String FORM_DATA = "multipart/form-data";
    public static final String MIXED = "multipart/mixed";
    private Logger logger = Logger.getLogger(Multipart.class.getName());
    private byte[] crlf = "\r\n".getBytes();
    private byte[] delimiter = "--".getBytes();
    private String charset = "ISO-8859-1";
    private Random random = new Random();
    private String boundary;
    private byte[] preamble;
    private byte[] epilogue;
    private String preambleData;
    private String epilogueData;
    private String multipartType;
    private ArrayList<Part> multipart = new ArrayList();
    private int contentlength;
    private String contentType = null;
    private byte[] data;

    public Multipart(String multipartType) {
        this.multipartType = multipartType;
        this.boundary = "AWS_Boundary_" + this.getRandomNumber();
    }

    public Multipart(String multipartType, String boundary) {
        this.multipartType = multipartType;
        this.boundary = boundary;
    }

    public Multipart(String multipartType, String boundary, String charset) {
        this.multipartType = multipartType;
        this.boundary = boundary;
        this.charset = charset;
    }

    public void addPart(Part part) {
        this.multipart.add(part);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processMultipart(boolean isInnerPart) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            String ct = this.charset.equals("ISO-8859-1") ? this.multipartType + "; boundary=" + this.boundary : this.multipartType + "; boundary=" + this.boundary + "; charset=" + this.charset;
            if (isInnerPart) {
                baos.write(("Content-Type: " + ct).getBytes(this.charset));
                baos.write(this.crlf);
                baos.write(this.crlf);
            }
            this.contentType = ct;
            if (this.preamble != null && this.preamble.length > 0) {
                baos.write(this.preamble);
                baos.write(this.crlf);
            }
            Iterator<Part> iterator = this.multipart.iterator();
            while (iterator.hasNext()) {
                baos.write(this.delimiter);
                baos.write(this.boundary.getBytes(this.charset));
                baos.write(this.crlf);
                Part part = iterator.next();
                if (this.multipartType.equals(FORM_DATA) && !part.isFormData()) {
                    throw new Exception("Form-data multipart should only contains form-data parts.");
                }
                baos.write(part.getData());
            }
            baos.write(this.delimiter);
            baos.write(this.boundary.getBytes(this.charset));
            baos.write(this.delimiter);
            baos.write(this.crlf);
            if (this.epilogue != null && this.epilogue.length > 0) {
                baos.write(this.epilogue);
            }
            baos.write(this.crlf);
            if (!isInnerPart) {
                this.contentlength = baos.toByteArray().length;
            }
            this.data = baos.toByteArray();
            this.logger.log(Level.FINE, "Process Multipart : data framed :: {0}", new String(this.data));
        }
        catch (Exception ex) {
            this.logger.log(Level.INFO, "Exception in processMultipart : ", ex);
        }
        finally {
            try {
                baos.close();
            }
            catch (Exception exception) {}
        }
    }

    public void setPreambleContent(byte[] preamble) {
        this.preamble = preamble;
    }

    public void setEpilogueContent(byte[] epilogue) {
        this.epilogue = epilogue;
    }

    public void setCharset(String charset) {
        this.charset = charset;
    }

    void setPreambleContent(String preamble) {
        this.preambleData = preamble;
    }

    void setEpilogueContent(String epilogue) {
        this.epilogueData = epilogue;
    }

    public String getPreambleData() {
        return this.preambleData;
    }

    public String getEpilogueData() {
        return this.epilogueData;
    }

    byte[] getData() {
        return this.data;
    }

    int getContentLength() {
        return this.contentlength;
    }

    public String getContentType() {
        return this.contentType;
    }

    public String getCharset() {
        return this.charset;
    }

    public ArrayList<Part> getMultipartData() {
        return this.multipart;
    }

    private int getRandomNumber() {
        return this.random.nextInt(10000);
    }

    public String toString() {
        return "MULTIPART DATA :: " + this.multipart;
    }
}

