/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.Multipart;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.util.HashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;

public class HttpResponse {
    private HashMap responseHeaders = new HashMap();
    private String body;
    private boolean chunked = false;
    private ConcurrentLinkedQueue responseChunkQueue = null;
    private int responsecode;
    private String responsemessage;
    private int chunkCounter;
    private int MAX_CHUNK_COUNT = 25;
    private boolean websocket = false;
    private boolean streammode = false;
    private boolean keepalive = false;
    private boolean hasContentLength = false;
    private boolean hasKeepalive = false;
    private boolean asyncmode = false;
    private boolean multipart = false;
    private Multipart multipartData;
    private static Logger logger = Logger.getLogger(HttpResponse.class.getName());

    public void setResponseChunkQueueLimit(int limit) {
        this.MAX_CHUNK_COUNT = limit;
    }

    public void setResponseCode(String responsecode) {
        this.responsecode = Integer.parseInt(responsecode);
    }

    public int getResponseCode() {
        return this.responsecode;
    }

    public void setResponseMessage(String responsemessage) {
        this.responsemessage = responsemessage;
    }

    public String getResponseMessage() {
        return this.responsemessage;
    }

    public void addHeader(String key, String value) {
        this.responseHeaders.put(key, value);
        if (key.trim().toLowerCase().equals("transfer-encoding") && value.trim().toLowerCase().equals("chunked")) {
            this.chunked = true;
            this.responseChunkQueue = new ConcurrentLinkedQueue();
        }
        if (key.trim().toLowerCase().equals("content-length")) {
            this.responseChunkQueue = new ConcurrentLinkedQueue();
            this.hasContentLength = true;
        }
        if (key.trim().toLowerCase().equals("connection") && value.trim().toLowerCase().equals("keep-alive")) {
            this.hasKeepalive = true;
        }
        if (this.hasKeepalive && (this.chunked || this.hasContentLength)) {
            this.keepalive = true;
        }
        if (key.trim().toLowerCase().equals("content-type") && value.trim().toLowerCase().contains("multipart")) {
            this.multipart = true;
        }
    }

    public boolean isKeepAliveEnabled() {
        return this.keepalive;
    }

    public boolean isMultipart() {
        return this.multipart;
    }

    public void prepareWSResponseQueue() {
        this.websocket = true;
        this.responseChunkQueue = new ConcurrentLinkedQueue();
    }

    public boolean isGZIPEncoded() {
        return this.responseHeaders.get("content-encoding") != null && ((String)this.responseHeaders.get("content-encoding")).toLowerCase().equals("gzip");
    }

    public void setBody(char[] data) {
        this.body = new String(data);
    }

    public void setBody(byte[] data) {
        try {
            if (this.isGZIPEncoded()) {
                ByteArrayInputStream bais = new ByteArrayInputStream(data);
                GZIPInputStream stream = new GZIPInputStream(bais);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] arr = new byte[1024];
                int c = -1;
                while ((c = stream.read(arr)) != -1) {
                    baos.write(arr, 0, c);
                }
                data = baos.toByteArray();
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in setBody : ", ex);
        }
        try {
            this.body = new String(data, "UTF-8");
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in setBody : ", ex);
        }
    }

    public void addChunk(byte[] data) {
        int size = this.responseChunkQueue.size();
        if (this.MAX_CHUNK_COUNT != -1 && size > this.MAX_CHUNK_COUNT) {
            this.responseChunkQueue.poll();
            --this.chunkCounter;
        }
        this.responseChunkQueue.add(data);
        ++this.chunkCounter;
    }

    public HashMap getResponseHeaders() {
        return this.responseHeaders;
    }

    public String getResponseHeader(String key) {
        return (String)this.responseHeaders.get(key);
    }

    public String getResponseString() {
        try {
            byte[] data;
            if ((this.chunked || this.websocket || this.asyncmode || this.streammode) && (data = (byte[])this.responseChunkQueue.poll()) != null) {
                --this.chunkCounter;
                return new String(data, "UTF-8");
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in getResponseString : ", ex);
        }
        return this.body;
    }

    public String getResponseString(boolean removeResponse) {
        if (removeResponse) {
            return this.getResponseString();
        }
        try {
            byte[] data;
            if (this.chunked && (data = (byte[])this.responseChunkQueue.peek()) != null) {
                return new String(data, "UTF-8");
            }
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception in getResponseString : ", ex);
        }
        return this.body;
    }

    private String getResponseString(boolean removeResponse, boolean latestData) {
        try {
            if (!removeResponse && latestData && this.chunked) {
                Object[] dataArray = this.responseChunkQueue.toArray();
                byte[] databytes = (byte[])dataArray[this.chunkCounter - 1];
                if (databytes != null) {
                    return new String(databytes, "UTF-8");
                }
            } else {
                if (!removeResponse && !latestData) {
                    return this.getResponseString(false);
                }
                if (removeResponse) {
                    return this.getResponseString();
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in getResponseString : ", e);
        }
        return null;
    }

    public byte[] getRawResponseData() {
        byte[] data;
        if ((this.chunked || this.streammode || this.websocket) && (data = (byte[])this.responseChunkQueue.poll()) != null) {
            --this.chunkCounter;
            return data;
        }
        if (this.body != null) {
            return this.body.getBytes();
        }
        return null;
    }

    public boolean isChunked() {
        return this.chunked;
    }

    public boolean isChunkAvailable() {
        try {
            if (this.responseChunkQueue.size() > 0) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void setAsyncMode() {
        this.asyncmode = true;
        this.responseChunkQueue = new ConcurrentLinkedQueue();
    }

    public void setStreamMode() {
        this.streammode = true;
        this.responseChunkQueue = new ConcurrentLinkedQueue();
    }

    public boolean isBodyEmpty() {
        return this.body.isEmpty();
    }

    public byte[] getCompleteRawData() {
        byte[] data = (byte[])this.responseChunkQueue.poll();
        if (data != null) {
            --this.chunkCounter;
            return data;
        }
        return null;
    }

    void setMultipartData(Multipart multipart) {
        this.multipartData = multipart;
    }

    public Multipart getMultipartData() {
        return this.multipartData;
    }
}

