/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.HttpRequest;
import com.adventnet.wms.nioclient.http.HttpResponse;
import java.io.IOException;
import java.util.HashMap;

public class HttpRequestWrapper {
    private boolean https;
    private String url;
    private HashMap<String, String> headerMap;
    private HashMap paramMap;
    private HttpRequest req;
    private HttpResponse response;
    private String host;
    private int port;
    private String uri;
    private String reqType;
    private String redirectedURL;

    public HttpRequestWrapper(String host, int port, String rMethod, boolean https, String url, HashMap headerMap, HashMap paramMap) {
        this.host = host;
        this.port = port;
        this.https = https;
        this.url = url;
        this.headerMap = headerMap;
        this.paramMap = paramMap;
        this.reqType = rMethod;
    }

    public HttpRequest getRequest() throws IOException {
        if (this.req == null) {
            throw new IOException("Connection not registered for stream write. So couldn't retrieve the request.");
        }
        return this.req;
    }

    public String getHost() {
        return this.host;
    }

    public String getCompleteHost() {
        if (this.port == 80) {
            return "http://" + this.host;
        }
        if (this.port == 443) {
            return "https://" + this.host;
        }
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public boolean isHttps() {
        return this.https;
    }

    public String getURL() {
        return this.url;
    }

    public HashMap getHeaderMap() {
        return this.headerMap;
    }

    public HashMap getParamMap() {
        return this.paramMap;
    }

    public String getRequestMethod() {
        return this.reqType;
    }

    public void setResponse(HttpResponse resp) {
        this.response = resp;
    }

    public void setRequest(HttpRequest req) {
        this.req = req;
    }

    public void setURI(String requri) {
        this.uri = requri;
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public String getRequestURI() {
        return this.uri;
    }

    public String toString() {
        return "[HOST]:" + this.host + ",[PORT]:" + this.port + ",[ISHTTPS]:" + this.https + ",[URL]:" + this.url + ",[URI]" + this.uri + ",[HEADERS]:" + this.headerMap + ",[PARAMS]:" + this.paramMap;
    }

    public void setRedirectedURL(String url) {
        this.redirectedURL = url;
    }

    public String getRedirectedURL() {
        return this.redirectedURL;
    }
}

