/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.SSLManager;
import com.adventnet.wms.nioclient.SSLWrapper;
import com.adventnet.wms.nioclient.http.ConnectTimeOutListener;
import com.adventnet.wms.nioclient.http.ConnectionManager;
import com.adventnet.wms.nioclient.http.EventDispatcher;
import com.adventnet.wms.nioclient.http.HttpKeepaliveConnection;
import com.adventnet.wms.nioclient.http.HttpRequestEventListener;
import com.adventnet.wms.nioclient.http.HttpRequestWrapper;
import com.adventnet.wms.nioclient.http.HttpResponse;
import com.adventnet.wms.nioclient.http.HttpStreamRequestEventListener;
import com.adventnet.wms.nioclient.http.KeyValueProp;
import com.adventnet.wms.nioclient.http.Multipart;
import com.adventnet.wms.nioclient.http.NetworkEventProcessor;
import com.adventnet.wms.nioclient.http.Part;
import com.adventnet.wms.nioclient.http.ReadTimeOutListener;
import com.adventnet.wms.nioclient.http.SelectorPoolFactory;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.net.URLEncoder;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import sun.misc.BASE64Encoder;

public class HttpRequest {
    private static Logger logger = Logger.getLogger(HttpRequest.class.getName());
    private boolean hsdone = false;
    protected boolean isSSL = false;
    protected ByteBuffer byteBuffer = ByteBuffer.allocate(3072);
    protected ByteBuffer writeBB = null;
    protected String url = null;
    protected String host = null;
    protected String connecthost = null;
    protected String proxyUsername = "proxy";
    protected String proxyPassword = "proxy";
    protected int port = -1;
    protected int connectport = -1;
    private String uri = null;
    private String reqType = null;
    protected int zeroReadCount = 0;
    protected int maxZeroReadCount = 25;
    protected static final int MAX_SIZE = 3072;
    protected int inputdatasize = 3072;
    private static String NEWLINE = "\r\n";
    protected HttpResponse response = null;
    protected boolean headerread = false;
    protected boolean isProxyConnectRequest = false;
    protected int headerLength = 0;
    private ByteBuffer bodyBuffer = null;
    private ByteBuffer chunkBuffer = null;
    protected SSLWrapper ssl = null;
    protected SocketChannel sc = null;
    private ByteArrayOutputStream headerbaos = new ByteArrayOutputStream();
    private ByteArrayOutputStream bodybaos = null;
    protected HttpRequestWrapper requestWrapper = null;
    protected boolean https = false;
    protected boolean requestComplete = false;
    private boolean headerComplete = false;
    private StringBuffer paramBuffer = new StringBuffer();
    private HashMap headerMap = new HashMap();
    private HashMap paramMap = new HashMap();
    protected HttpRequestEventListener listener = null;
    private HttpRequestEventListener requestListener = null;
    private HttpStreamRequestEventListener streamListener = null;
    private HttpStreamRequestEventListener streamRequestListener = null;
    protected int readtimeout = 30000;
    protected long readexpiretime = -1L;
    protected long pingExpireTime = -1L;
    protected boolean closed = false;
    protected boolean timeoutstate = true;
    protected SelectionKey key = null;
    private boolean bufferingConnection = true;
    private ByteArrayOutputStream streamBuffer = null;
    private boolean closeConnection = false;
    private int pendingnlcut = 0;
    private int MAX_RESP_CHUNK_QUEUE_LIMIT = 25;
    protected int pendingcount = 0;
    private boolean delimited = false;
    private boolean highpriority = false;
    private ByteBuffer delimitedBuffer = null;
    private ByteArrayOutputStream delimbaos = new ByteArrayOutputStream();
    protected boolean tmentryadded = false;
    private boolean requestSubmitted = false;
    protected Object lock = new Object();
    private boolean writeCompleted = false;
    private boolean http2 = false;
    private long initConnectTime;
    protected long bytesRead = 0L;
    protected long bytesWritten = 0L;
    private long connectexpiretime;
    protected boolean isWebsocketConnection = false;
    protected boolean streamwrite = false;
    protected HashMap statReports = new LinkedHashMap();
    private boolean internalRedirection = false;
    private boolean redirect = false;
    private boolean keepalive = false;
    private boolean proxyEnabled = false;
    private boolean streammode = false;
    private Object streamlock = new Object();
    private boolean dispatcherthreadsafe = false;
    private boolean isFinalWriteChunkSent = false;
    private Multipart multipart;
    private String sniServerName = null;

    public HttpRequest(String url, int port, String reqType, HttpRequestEventListener listener) throws Exception {
        this(url, port, reqType, false);
        this.listener = listener;
        this.requestListener = listener;
    }

    public HttpRequest(String url, int port, String reqType, HttpStreamRequestEventListener listener) throws Exception {
        this(url, port, reqType, false);
        this.streamListener = listener;
        this.streamRequestListener = listener;
        this.streammode = true;
        this.setAsyncMode(true);
    }

    public HttpRequest(String url, int port, String reqType, HttpRequestEventListener listener, boolean http2) throws Exception {
        this(url, port, reqType, http2);
        this.listener = listener;
        this.requestListener = listener;
    }

    private HttpRequest(String url, int port, String reqType, boolean http2) throws Exception {
        this.url = url;
        this.connecthost = this.host = this.getHost();
        this.port = port;
        if (this.port == -1) {
            this.port = this.getPort();
        }
        this.connectport = port;
        this.uri = this.getURI();
        this.reqType = reqType;
        this.http2 = http2;
        if (!(http2 || reqType != null && (reqType.equals("GET") || reqType.equals("POST") || reqType.equals("PUT") || reqType.equals("DELETE")))) {
            throw new Exception("Request type invalid");
        }
        if (this.isHttps()) {
            this.isSSL = true;
        }
        this.intializeDefaultParams();
        this.byteBuffer = ByteBuffer.allocate(3072);
    }

    public void setReadBufferSize(int size) {
        this.byteBuffer = ByteBuffer.allocate(size);
    }

    public void setProxy(String host, int port) throws IOException {
        this.setProxy(host, port, null, null);
    }

    public void setProxy(String host, int port, String username, String password) throws IOException {
        this.connecthost = host;
        this.connectport = port;
        this.proxyUsername = username;
        this.proxyPassword = password;
        if (username != null && password != null) {
            this.addHeader("Proxy-Authorization", "Basic " + new BASE64Encoder().encode((username + ":" + password).getBytes("UTF-8")), false);
        }
        this.isProxyConnectRequest = true;
        this.proxyEnabled = true;
        if (this.isSSL) {
            this.isSSL = false;
        }
        ProxyImpl impl = new ProxyImpl();
        impl.setRequest(this);
        this.listener = impl;
    }

    public void setAsyncMode(boolean isAsync) {
        boolean bl = this.bufferingConnection = !isAsync;
        if (!this.bufferingConnection) {
            this.clearEOFBuffer();
        }
    }

    public void setDelimited() {
        this.delimited = true;
    }

    public void setHighPriority() {
        this.highpriority = true;
    }

    public boolean isHighPriority() {
        return this.highpriority;
    }

    public void setResponseChunkQueueLimit(int limit) {
        this.MAX_RESP_CHUNK_QUEUE_LIMIT = limit;
    }

    public void resetDefaults() {
        this.headerComplete = false;
        this.headerread = false;
        this.requestComplete = false;
        this.writeCompleted = false;
        this.requestSubmitted = false;
        ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
    }

    private void intializeDefaultParams() {
        try {
            this.addHeader("Host", this.host + ":" + this.port, false);
            this.addHeader("User-agent", "Java", false);
            this.addHeader("connection", "keep-alive", false);
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception while intializeDefaultParams : ", e);
        }
    }

    public void setRequestListener() {
        if (this.listener != null) {
            this.listener = this.requestListener;
        } else if (this.streamListener != null) {
            this.streamListener = this.streamRequestListener;
        }
    }

    public void setRequestURI(String reqUri) {
        if (!reqUri.startsWith("/")) {
            reqUri = "/" + reqUri;
        }
        this.uri = reqUri;
    }

    public void setReadTimeout(int timeout) {
        this.readtimeout = timeout;
    }

    public int getReadTimeout() {
        return this.readtimeout;
    }

    public void setTimeOutState(boolean state) {
        this.timeoutstate = state;
    }

    public String getHost() {
        return this.getHost(this.url);
    }

    public String getHost(String url) {
        return url.replaceAll("http://|https://|ws://|wss://", "").replaceAll(":.*", "").replaceAll("/.*", "");
    }

    private int getPort() {
        return this.getPort(this.url);
    }

    private int getPort(String url) {
        try {
            String port = url.replaceAll("http://|https://|www.|ws://|wss://", "").replaceAll("/.*", "").split(":")[1];
            return Integer.parseInt(port);
        }
        catch (Exception ex) {
            if (this.isHttps()) {
                return 443;
            }
            return 80;
        }
    }

    private String getURI() {
        return this.getURI(this.url);
    }

    private String getURI(String url) {
        try {
            String tmp = url.replaceAll("http://|https://|www.|ws://|wss://", "");
            tmp = tmp.substring(tmp.indexOf("/"));
            return tmp;
        }
        catch (Exception ex) {
            return "/";
        }
    }

    public void setSocketChannel(SocketChannel sc) {
        try {
            this.sc = sc;
            this.initConnectTime = System.currentTimeMillis();
            if (this.isSSL) {
                this.ssl = new SSLWrapper(sc, this.getHost(), this.sniServerName);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in setSocketChannel : ", e);
        }
    }

    public void setSNIServerName(String sniServerName) {
        this.sniServerName = sniServerName;
    }

    public void setHSDone() {
        this.hsdone = true;
    }

    public boolean isHSDone() {
        return this.hsdone;
    }

    public boolean isSSL() {
        return this.isSSL;
    }

    public void addHeader(ArrayList headerList) {
        for (int i = 0; i < headerList.size(); ++i) {
            try {
                KeyValueProp param = (KeyValueProp)headerList.get(i);
                this.addHeader(param.getName(), param.getValue(), false);
                continue;
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception in add header : ", e);
            }
        }
    }

    public void addHeader(String header, String value) throws IOException {
        this.addHeader(header, value, true);
    }

    public void addHeader(String header, String value, boolean encode) throws IOException {
        if (encode) {
            value = URLEncoder.encode(value, "UTF-8");
        }
        this.headerMap.put(header, value);
        this.headerbaos.write((header + ": " + value + NEWLINE).getBytes("UTF-8"));
    }

    public void addParam(String param, String value) throws IOException {
        this.addParam(param, value, true);
    }

    public void addParam(String param, String value, boolean encode) throws IOException {
        if (encode) {
            value = URLEncoder.encode(value, "UTF-8");
        }
        if (this.paramMap.size() > 0 && this.paramBuffer.length() > 0) {
            this.paramBuffer.append("&");
        }
        this.paramMap.put(param, value);
        this.paramBuffer.append(param + "=" + value);
    }

    public void setBody(String data) throws IOException {
        if (this.bodybaos == null) {
            this.bodybaos = new ByteArrayOutputStream();
        }
        if (data != null && !data.equals("")) {
            this.bodybaos.write(data.getBytes("UTF-8"));
            this.inputdatasize += this.bodybaos.toByteArray().length;
        }
    }

    public void setBody(byte[] data) throws IOException {
        if (this.bodybaos == null) {
            this.bodybaos = new ByteArrayOutputStream();
        }
        if (data != null && data.length > 0) {
            this.bodybaos.write(data);
            this.inputdatasize += this.bodybaos.toByteArray().length;
        }
    }

    public void setBody(Multipart mimedata) throws IOException {
        if (this.reqType.equals("POST")) {
            mimedata.processMultipart(false);
            this.addHeader("Content-Length", "" + mimedata.getContentLength());
            this.addHeader("Content-Type", mimedata.getContentType(), false);
            this.setBody(mimedata.getData());
        } else {
            logger.log(Level.SEVERE, "Multipart header supported only on POST request. Current request type : {0}", new Object[]{this.reqType});
        }
    }

    public void connect() throws IOException {
        this.connect(20000L);
    }

    public void connect(long timeout) throws IOException {
        if (!this.isWebsocketConnection && ConnectionManager.isKeepaliveEnabled() && this.isKeepaliveConnectionAvailable(timeout)) {
            logger.log(Level.INFO, "Since keep alive is enabled, connection established with preused connection...");
            this.statReports.put("inittime", System.currentTimeMillis());
            return;
        }
        this.createRequestWrapper();
        if (this.highpriority) {
            SelectorPoolFactory.getHighPriorityInstance(this.port).connect(this.connecthost, this.connectport, this, timeout);
        } else {
            SelectorPoolFactory.getInstance(this.port).connect(this.connecthost, this.connectport, this, timeout);
        }
        this.statReports.put("inittime", System.currentTimeMillis());
    }

    private boolean isKeepaliveConnectionAvailable(long timeout) throws IOException {
        try {
            if (this.proxyEnabled) {
                HttpKeepaliveConnection obj = ConnectionManager.getAvailableConnection(this.connecthost, this.connectport, this.host, this.port, this.proxyUsername, this.proxyPassword);
                if (obj == null) {
                    return false;
                }
                this.setRequestListener();
                this.isProxyConnectRequest = false;
                if (this.isHttps()) {
                    this.isSSL = true;
                }
                this.sc = obj.getSocketChannel();
                this.initConnectTime = System.currentTimeMillis();
                if (this.isConnectionOpen()) {
                    if (this.isSSL) {
                        if (obj.getSSLEngine() == null) {
                            return false;
                        }
                        this.ssl = new SSLWrapper(this.sc, obj.getSSLEngine(), this.host, this.sniServerName, true);
                        this.setHSDone();
                        this.ssl.setSSLHSComplete(true);
                    }
                    this.setSelectionKey(obj.getSelectionKey());
                    this.createRequestWrapper();
                    this.key.attach(this);
                    this.key.interestOps(5);
                    this.setConnectExpireTime(System.currentTimeMillis() + timeout);
                    NetworkEventProcessor.process(this, 1);
                    return true;
                }
                return false;
            }
            HttpKeepaliveConnection obj = ConnectionManager.getAvailableConnection(this.host, this.port);
            if (obj == null) {
                return false;
            }
            this.sc = obj.getSocketChannel();
            this.initConnectTime = System.currentTimeMillis();
            if (this.isConnectionOpen()) {
                if (this.isSSL) {
                    this.ssl = new SSLWrapper(this.sc, obj.getSSLEngine(), this.host, this.sniServerName, true);
                    this.setHSDone();
                    this.ssl.setSSLHSComplete(true);
                }
                this.setSelectionKey(obj.getSelectionKey());
                this.createRequestWrapper();
                this.key.attach(this);
                this.key.interestOps(5);
                this.setConnectExpireTime(System.currentTimeMillis() + timeout);
                NetworkEventProcessor.process(this, 1);
                this.statReports.put("inittime", System.currentTimeMillis());
                return true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception during keepalive connection checking ", e);
        }
        return false;
    }

    public void createRequestWrapper() {
        this.requestWrapper = new HttpRequestWrapper(this.host, this.port, this.reqType, this.https, this.url, (HashMap)this.headerMap.clone(), (HashMap)this.paramMap.clone());
        this.requestWrapper.setURI(this.uri);
    }

    protected boolean isHttps() {
        return this.isHttps(this.url);
    }

    protected boolean isHttps(String url) {
        if (url.startsWith("https://") || url.startsWith("wss://")) {
            this.https = true;
            return this.https;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeData() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            String fline;
            if (!this.statReports.containsKey("writeinittime") && !this.isProxyConnectRequest) {
                this.statReports.put("writeinittime", System.currentTimeMillis());
            }
            if (this.uri != null && this.uri.length() > 0) {
                this.inputdatasize += this.uri.length();
            }
            if (this.paramBuffer.length() > 0) {
                this.inputdatasize += this.paramBuffer.toString().getBytes("UTF-8").length;
            }
            this.writeBB = ByteBuffer.allocate(this.inputdatasize);
            if (this.isProxyConnectRequest) {
                fline = "CONNECT " + this.host + ":" + this.port + " " + "HTTP/1.1" + NEWLINE + "Host" + ": " + this.host + ":" + this.port + NEWLINE + "Proxy-Authorization: Basic " + new BASE64Encoder().encode((this.proxyUsername + ":" + this.proxyPassword).getBytes("UTF-8")) + NEWLINE;
                this.writeBB.put(fline.getBytes("UTF-8"));
                this.writeBB.put(NEWLINE.getBytes());
                this.writeCompleted = true;
            } else if (this.reqType.equals("GET") || this.reqType.equals("DELETE")) {
                if (this.paramBuffer.length() > 0) {
                    this.uri = this.uri + "?" + this.paramBuffer.toString();
                }
                fline = null;
                fline = this.reqType + " " + this.uri + " " + "HTTP/1.1" + NEWLINE;
                this.writeBB.put(fline.getBytes("UTF-8"));
                this.writeBB.put(this.headerbaos.toByteArray());
                this.writeBB.put(NEWLINE.getBytes());
                this.writeCompleted = true;
            } else if (this.reqType.equals("POST") || this.reqType.equals("PUT")) {
                if (this.paramBuffer.length() > 0) {
                    this.uri = this.uri + "?" + this.paramBuffer.toString();
                }
                fline = null;
                fline = this.reqType + " " + this.uri + " " + "HTTP/1.1" + NEWLINE;
                this.writeBB.put(fline.getBytes("UTF-8"));
                this.writeBB.put(this.headerbaos.toByteArray());
                this.writeBB.put(NEWLINE.getBytes("UTF-8"));
                if (!this.streamwrite) {
                    if (this.bodybaos != null) {
                        this.writeBB.put(this.bodybaos.toByteArray());
                    }
                    this.writeBB.put(NEWLINE.getBytes("UTF-8"));
                    this.writeCompleted = true;
                }
            }
            int written = 0;
            if (this.isSSL) {
                this.writeBB.flip();
                while (this.writeBB.hasRemaining()) {
                    if (this.ssl.doHandshake(this.key)) {
                        written = this.ssl.write(this.writeBB);
                    }
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.writeBB.flip();
                while (this.writeBB.hasRemaining()) {
                    written = this.sc.write(this.writeBB);
                    try {
                        Thread.sleep(1L);
                    }
                    catch (Exception exception) {}
                }
            }
            if (this.writeCompleted) {
                this.requestSubmitted = true;
                if (this.timeoutstate && !this.tmentryadded) {
                    this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                    ReadTimeOutListener.TRACKER.touch(this.readexpiretime, this);
                    this.tmentryadded = true;
                }
            }
            if (!this.isProxyConnectRequest && !this.internalRedirection) {
                this.headerbaos = null;
                this.bodybaos = null;
                this.bytesWritten += (long)written;
                this.statReports.put("byteswritten", this.bytesWritten);
                if (this.isWebsocketConnection || this.streamwrite) {
                    this.statReports.put("lastwrittentime", System.currentTimeMillis());
                } else {
                    this.statReports.put("writeendtime", System.currentTimeMillis());
                    this.statReports.put("writetime", Long.parseLong(this.statReports.get("writeendtime").toString()) - Long.parseLong(this.statReports.get("writeinittime").toString()));
                }
            }
            if (this.writeCompleted) {
                EventDispatcher.process(this, 2);
            } else if (this.streamwrite) {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.requestWrapper.setRequest(this);
                EventDispatcher.process(this, 6);
            }
            this.writeBB = null;
        }
    }

    public void writeToStream(String data, boolean isFinalChunk) throws IOException {
        this.writeToStream(data.getBytes(StandardCharsets.UTF_8), isFinalChunk);
    }

    public void writeToStream(byte[] data, boolean isFinalChunk) throws IOException {
        this.writeToStream(ByteBuffer.wrap(data), isFinalChunk);
    }

    private void writeToStream(ByteBuffer data, boolean isFinalChunk) throws IOException {
        if (this.isFinalWriteChunkSent) {
            throw new IOException("Final write chunk already sent.");
        }
        this.chunkWrite(data);
        if (isFinalChunk) {
            this.completeWriteToStream();
        } else {
            this.statReports.put("lastwrittentime", System.currentTimeMillis());
            this.statReports.put("byteswritten", this.bytesWritten);
            EventDispatcher.process(this, 6);
        }
    }

    public void completeWriteToStream() throws IOException {
        if (this.isFinalWriteChunkSent) {
            throw new IOException("Final write chunk already sent.");
        }
        this.isFinalWriteChunkSent = true;
        this.chunkWrite(ByteBuffer.allocate(0));
        this.writeCompleted = true;
        this.requestSubmitted = true;
        if (this.timeoutstate && !this.tmentryadded) {
            this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
            ReadTimeOutListener.TRACKER.touch(this.readexpiretime, this);
            this.tmentryadded = true;
        }
        this.statReports.put("lastwrittentime", System.currentTimeMillis());
        this.statReports.put("writeendtime", System.currentTimeMillis());
        this.statReports.put("writetime", Long.parseLong(this.statReports.get("writeendtime").toString()) - Long.parseLong(this.statReports.get("writeinittime").toString()));
        this.key.interestOps(1);
    }

    private void chunkWrite(ByteBuffer data) throws IOException {
        if (!this.streamwrite || this.headerMap.get("Transfer-Encoding") == null || !this.headerMap.get("Transfer-Encoding").equals("chunked")) {
            logger.log(Level.SEVERE, "Stream write not supported/registered other than a chunked encode connection.");
            throw new IOException("Stream write not supported/registered other than a chunked encode connection");
        }
        data = this.getChunkedData(data);
        int written = 0;
        while (data.hasRemaining()) {
            if (this.isSSL) {
                written += this.ssl.write(data);
                try {
                    Thread.sleep(1L);
                }
                catch (Exception exception) {}
                continue;
            }
            written += this.sc.write(data);
            try {
                Thread.sleep(1L);
            }
            catch (Exception exception) {}
        }
        this.bytesWritten += (long)written;
    }

    public ByteBuffer getChunkedData(ByteBuffer data) throws IOException {
        try {
            byte[] dat = data.array();
            byte[] hex = Integer.toHexString(dat.length).getBytes("UTF-8");
            byte[] newline = NEWLINE.getBytes("UTF-8");
            int destbuffsize = hex.length + newline.length + dat.length + newline.length;
            ByteArrayOutputStream chunkBuffer = new ByteArrayOutputStream(destbuffsize);
            chunkBuffer.write(hex);
            chunkBuffer.write(newline);
            chunkBuffer.write(dat);
            chunkBuffer.write(newline);
            return ByteBuffer.wrap(chunkBuffer.toByteArray());
        }
        catch (Exception ex) {
            logger.log(Level.INFO, " Exception ", ex);
            throw new IOException("Error forming chunked data for " + this.url + " : " + ex.getMessage());
        }
    }

    public void registerStreamWrite() throws IOException {
        if (this.reqType.equals("POST") || this.reqType.equals("PUT") || this.reqType.equals("PATCH") || this.reqType.equals("DELETE")) {
            this.streamwrite = true;
            return;
        }
        throw new IOException("Chunked stream write supported only for POST or PUT or PATCH or DELETE requests");
    }

    public long getReadExpireTime() {
        return this.readexpiretime;
    }

    public long getPingExpireTime() {
        return this.pingExpireTime;
    }

    public boolean isInvalidReadTimeoutEntry(long time) {
        return false;
    }

    public boolean isInvalidPingTimeoutEntry(long time) {
        return false;
    }

    public boolean isConnectionOpen() {
        try {
            return this.sc.isOpen();
        }
        catch (Exception ex) {
            return false;
        }
    }

    public void doPing() {
    }

    public boolean doHandshake(SelectionKey key) throws IOException {
        if (this.key == null) {
            this.key = key;
        }
        boolean status = this.ssl.doHandshake(key);
        if (this.isSSL) {
            for (Map.Entry pair : this.ssl.handshakeReports().entrySet()) {
                this.statReports.put(pair.getKey(), pair.getValue());
            }
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void readData(SelectionKey key) throws IOException, CancelledKeyException {
        Object object = this.lock;
        synchronized (object) {
            block59: {
                block55: {
                    int count;
                    block57: {
                        block58: {
                            if (this.isClosed()) {
                                return;
                            }
                            if (!this.statReports.containsKey("readinittime") && !this.isProxyConnectRequest) {
                                this.statReports.put("readinittime", System.currentTimeMillis());
                            }
                            if (this.key == null) {
                                this.key = key;
                            }
                            count = -1;
                            if (this.isSSL) {
                                if (!this.ssl.doHandshake(key)) return;
                                if (!this.requestSubmitted) return;
                                count = this.ssl.read();
                                this.byteBuffer = this.ssl.getDataBuffer();
                            } else {
                                count = ((SocketChannel)key.channel()).read(this.byteBuffer);
                            }
                            if (!this.isProxyConnectRequest) {
                                this.bytesRead += (long)count;
                            }
                            if (count <= 0) break block57;
                            this.zeroReadCount = 0;
                            this.pendingcount = count;
                            if (!this.isHeaderComplete(this.byteBuffer)) break block58;
                            if (this.timeoutstate && !this.closed) {
                                long oldTime = this.readexpiretime;
                                this.readexpiretime = System.currentTimeMillis() + (long)this.readtimeout;
                                ReadTimeOutListener.TRACKER.update(oldTime, this.readexpiretime, this);
                            }
                            if (this.requestComplete) {
                                key.interestOps(1);
                                this.clearBuffer(this.byteBuffer);
                                return;
                            }
                            if (this.response.isChunked()) break block59;
                            if (!this.byteBuffer.hasRemaining()) {
                                key.interestOps(1);
                                this.clearBuffer(this.byteBuffer);
                                return;
                            }
                            if (this.bodyBuffer != null) {
                                if (this.bodyBuffer.limit() - this.bodyBuffer.position() <= this.byteBuffer.remaining()) {
                                    byte[] data = new byte[this.bodyBuffer.limit() - this.bodyBuffer.position()];
                                    this.byteBuffer.get(data);
                                    if (this.streammode) {
                                        this.response.addChunk(data);
                                        data = null;
                                        EventDispatcher.process(this, 5);
                                    } else {
                                        this.bodyBuffer.put(data);
                                        byte[] responseData = new byte[this.bodyBuffer.limit()];
                                        this.bodyBuffer.flip();
                                        this.bodyBuffer.get(responseData);
                                        this.response.setBody(responseData);
                                        data = null;
                                        responseData = null;
                                        EventDispatcher.process(this, 3);
                                    }
                                    this.close();
                                    this.requestComplete = true;
                                    this.bodyBuffer = null;
                                } else {
                                    byte[] data = new byte[this.pendingcount];
                                    this.byteBuffer.get(data);
                                    this.bodyBuffer.put(data);
                                    if (this.streammode) {
                                        this.response.addChunk(data);
                                        EventDispatcher.process(this, 4);
                                    }
                                    data = null;
                                    key.interestOps(1);
                                }
                            } else if (this.streamBuffer != null) {
                                byte[] data = new byte[this.pendingcount];
                                this.byteBuffer.get(data);
                                this.streamBuffer.write(data);
                                if (this.streammode) {
                                    this.response.addChunk(data);
                                    EventDispatcher.process(this, 4);
                                }
                                data = null;
                                key.interestOps(1);
                            }
                            this.clearBuffer(this.byteBuffer);
                            break block55;
                        }
                        if (this.closeConnection) {
                            this.clearBuffer(this.byteBuffer);
                            EventDispatcher.process(this, 3);
                            this.readEndTime();
                            this.close();
                            break block55;
                        } else {
                            key.interestOps(1);
                        }
                        break block55;
                    }
                    if (count < 0) {
                        this.readEndTime();
                        throw new IOException("Read -1");
                    }
                    if (count != 0) return;
                    ++this.zeroReadCount;
                    key.interestOps(1);
                    if (this.zeroReadCount <= this.maxZeroReadCount) return;
                    this.readEndTime();
                    throw new IOException("Key Read Count = 0 : Max Crossed");
                }
                return;
            }
            while (true) {
                if (this.chunkBuffer == null) {
                    int chunklength;
                    if (this.byteBuffer.remaining() >= 2 && this.pendingnlcut == 2) {
                        this.byteBuffer.position(this.byteBuffer.position() + 2);
                        this.pendingnlcut = 0;
                    }
                    if ((chunklength = this.getChunkLength(this.byteBuffer)) == -1) {
                        key.interestOps(1);
                        this.copyPending(this.byteBuffer);
                        return;
                    }
                    if (chunklength == 0) {
                        if (this.bufferingConnection && this.streamBuffer != null && this.streamBuffer.size() > 0) {
                            this.response.addChunk(this.streamBuffer.toByteArray());
                            EventDispatcher.process(this, 3);
                            this.clearEOFBuffer();
                        }
                        this.clearBuffer(this.byteBuffer);
                        if (this.response.isChunked() && !ConnectionManager.isKeepaliveEnabled()) {
                            EventDispatcher.process(this, -5);
                        }
                        this.readEndTime();
                        this.close();
                        return;
                    }
                    this.chunkBuffer = ByteBuffer.allocate(chunklength);
                    int clen = chunklength;
                    if (this.byteBuffer.remaining() < chunklength) {
                        clen = this.byteBuffer.remaining();
                    }
                    if (clen > 0) {
                        byte[] chunk = new byte[clen];
                        this.byteBuffer.get(chunk);
                        this.chunkBuffer.put(chunk);
                        if (clen == chunklength) {
                            if (this.bufferingConnection) {
                                try {
                                    this.streamBuffer.write(chunk);
                                    this.chunkBuffer = null;
                                }
                                catch (Exception ee) {
                                    logger.log(Level.INFO, "Exception - readData : ", ee);
                                }
                            } else {
                                if (!this.delimited) {
                                    this.response.addChunk(chunk);
                                    this.dispatch();
                                } else {
                                    this.doDelimitedCheck(chunk);
                                }
                                this.chunkBuffer = null;
                            }
                            key.interestOps(1);
                            if (this.byteBuffer.remaining() >= 2) {
                                this.byteBuffer.position(this.byteBuffer.position() + 2);
                            } else {
                                this.pendingnlcut = 2;
                            }
                            int chunkDatalen = chunk.length;
                            this.pendingcount -= chunkDatalen;
                            chunk = null;
                            if (this.byteBuffer.hasRemaining()) {
                                continue;
                            }
                        } else {
                            key.interestOps(1);
                        }
                    } else {
                        key.interestOps(1);
                    }
                }
                if (!this.byteBuffer.hasRemaining()) {
                    key.interestOps(1);
                    this.clearBuffer(this.byteBuffer);
                    return;
                }
                if (this.chunkBuffer.limit() - this.chunkBuffer.position() > this.pendingcount) {
                    byte[] data = new byte[this.pendingcount];
                    this.byteBuffer.get(data);
                    this.chunkBuffer.put(data);
                    data = null;
                    this.clearBuffer(this.byteBuffer);
                    key.interestOps(1);
                    return;
                }
                byte[] data = new byte[this.chunkBuffer.limit() - this.chunkBuffer.position()];
                this.byteBuffer.get(data);
                this.chunkBuffer.put(data);
                int dataLen = data.length;
                byte[] chunkData = new byte[this.chunkBuffer.limit()];
                this.chunkBuffer.flip();
                this.chunkBuffer.get(chunkData);
                if (this.bufferingConnection) {
                    try {
                        this.streamBuffer.write(chunkData);
                        this.chunkBuffer = null;
                        chunkData = null;
                    }
                    catch (Exception eee) {
                        logger.log(Level.INFO, "Exception - readData : ", eee);
                    }
                } else {
                    if (!this.delimited) {
                        this.response.addChunk(chunkData);
                        this.dispatch();
                    } else {
                        this.doDelimitedCheck(chunkData);
                    }
                    chunkData = null;
                    this.chunkBuffer = null;
                }
                key.interestOps(1);
                if (this.byteBuffer.remaining() >= 2) {
                    this.byteBuffer.position(this.byteBuffer.position() + 2);
                } else {
                    this.pendingnlcut = 2;
                }
                this.pendingcount -= dataLen;
                data = null;
            }
        }
    }

    private void readEndTime() {
        if (!this.isProxyConnectRequest) {
            this.statReports.put("readendtime", System.currentTimeMillis());
            this.statReports.put("bytesread", this.bytesRead);
            this.statReports.put("readtime", Long.parseLong(this.statReports.get("readendtime").toString()) - Long.parseLong(this.statReports.get("readinittime").toString()));
        }
    }

    private void doDelimitedCheck(byte[] data) throws IOException {
        this.delimbaos.write(data);
        this.doDelimitedCheck();
    }

    private void doDelimitedCheck() throws IOException {
        byte[] chunk = this.delimbaos.toByteArray();
        if (this.delimitedBuffer == null) {
            boolean chunkpresent = false;
            for (int i = 0; i < chunk.length - 1 && !chunkpresent; ++i) {
                if (chunk[i] != 13 || chunk[i + 1] != 10) continue;
                try {
                    int delimlength = Integer.parseInt(new String(chunk, 0, i));
                    this.delimitedBuffer = ByteBuffer.allocate(delimlength);
                    this.delimbaos = new ByteArrayOutputStream();
                    if (chunk.length >= i + 2) {
                        this.delimbaos.write(chunk, i + 2, chunk.length - (i + 2));
                        this.doDelimitedCheck();
                    }
                    chunkpresent = true;
                    continue;
                }
                catch (NumberFormatException ex) {
                    this.delimbaos = new ByteArrayOutputStream();
                    if (chunk.length < i + 2) continue;
                    this.delimbaos.write(chunk, i + 2, chunk.length - (i + 2));
                    this.doDelimitedCheck();
                }
            }
        } else {
            int remdatalength = this.delimitedBuffer.limit() - this.delimitedBuffer.position();
            if (chunk.length < remdatalength) {
                this.delimitedBuffer.put(chunk);
                this.delimbaos = new ByteArrayOutputStream();
            } else if (chunk.length == remdatalength) {
                this.delimitedBuffer.put(chunk, 0, remdatalength);
                byte[] result = new byte[this.delimitedBuffer.limit()];
                this.delimitedBuffer.flip();
                this.delimitedBuffer.get(result, 0, result.length);
                this.delimitedBuffer = null;
                this.response.addChunk(result);
                this.dispatch();
                this.delimbaos = new ByteArrayOutputStream();
            } else {
                this.delimitedBuffer.put(chunk, 0, remdatalength);
                byte[] result = new byte[this.delimitedBuffer.limit()];
                this.delimitedBuffer.flip();
                this.delimitedBuffer.get(result, 0, result.length);
                this.delimitedBuffer = null;
                this.response.addChunk(result);
                this.dispatch();
                this.delimbaos = new ByteArrayOutputStream();
                this.delimbaos.write(chunk, remdatalength, chunk.length - remdatalength);
                this.doDelimitedCheck();
            }
        }
    }

    private void copyPending(ByteBuffer bb) {
        int rem = bb.remaining();
        if (rem == 0) {
            bb.clear();
            return;
        }
        byte[] remdata = new byte[rem];
        bb.get(remdata);
        bb.clear();
        bb.put(remdata);
        remdata = null;
    }

    protected void clearBuffer(ByteBuffer bb) {
        if (this.isSSL) {
            this.ssl.clearDataBuffer();
        }
        bb.clear();
    }

    private void clearEOFBuffer() {
        try {
            if (this.streamBuffer != null) {
                this.streamBuffer.reset();
                this.streamBuffer.close();
                this.streamBuffer = null;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception - clearEOFBuffer : ", e);
        }
    }

    protected boolean isHeaderComplete(ByteBuffer bb) throws IOException {
        if (this.headerComplete && this.headerread) {
            bb.flip();
            return true;
        }
        if (!this.headerComplete && !this.isProperHttpResponse(bb)) {
            this.closeConnection = true;
            this.response = new HttpResponse();
            this.response.setResponseCode("403");
            this.requestWrapper.setResponse(this.response);
            return this.headerComplete;
        }
        for (int i = 0; i <= bb.position() - 4 && !this.headerComplete; ++i) {
            if (bb.get(i) != 13 || bb.get(i + 1) != 10 || bb.get(i + 2) != 13 || bb.get(i + 3) != 10) continue;
            this.headerComplete = true;
            this.headerLength = i + 4;
        }
        if (this.headerComplete) {
            this.response = new HttpResponse();
            this.response.setResponseChunkQueueLimit(this.MAX_RESP_CHUNK_QUEUE_LIMIT);
            this.requestWrapper.setResponse(this.response);
            this.parseResponse(bb);
        }
        return this.headerComplete;
    }

    protected boolean isProperHttpResponse(ByteBuffer tempbb) {
        boolean validResponse = false;
        try {
            if (tempbb.get(0) == 72 && tempbb.get(1) == 84 && tempbb.get(2) == 84 && tempbb.get(3) == 80) {
                validResponse = true;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception - isProperHttpResponse : ", e);
        }
        return validResponse;
    }

    protected int getChunkLength(ByteBuffer bb) throws IOException {
        int chunkcharcount = -1;
        boolean chunklengthpresent = false;
        int cntcharcount = 0;
        int remaining = bb.remaining();
        int i = bb.position();
        int counter = 2;
        while (counter < remaining && !chunklengthpresent) {
            if (bb.get(i) == 13 && bb.get(i + 1) == 10) {
                chunklengthpresent = true;
                chunkcharcount = cntcharcount;
            }
            counter += 2;
            ++i;
            ++cntcharcount;
        }
        if (chunklengthpresent) {
            byte[] lendata = new byte[chunkcharcount];
            bb.get(lendata);
            bb.get(new byte[2]);
            String chunklen = new String(lendata);
            int chunklength = Integer.parseInt(chunklen.trim(), 16);
            if (chunklength == 0 && this.streammode && this.isLastChunk(bb)) {
                EventDispatcher.process(this, 5);
            }
            return chunklength;
        }
        return -1;
    }

    private boolean isLastChunk(ByteBuffer bb) {
        try {
            int i = bb.position() - 2;
            if (bb.get(i) == 13 && bb.get(i + 1) == 10 && bb.get(i + 2) == 13 && bb.get(i + 3) == 10) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void parseResponse(ByteBuffer bb) throws IOException {
        if (!this.headerread) {
            bb.flip();
            byte[] headerData = new byte[this.headerLength];
            bb.get(headerData);
            this.pendingcount -= headerData.length;
            BufferedReader br = new BufferedReader(new StringReader(new String(headerData)));
            String line = br.readLine();
            String[] tokens = line.split(" ");
            String version = tokens[0];
            String responsecode = tokens[1];
            String responsestatusmsg = "";
            if (tokens.length >= 3) {
                responsestatusmsg = line.substring(version.length() + responsecode.length() + 2, line.length());
            } else if (!Character.isSpace(line.charAt(line.length() - 1))) {
                throw new IOException("Invalid HTTP status line in response " + line);
            }
            this.response.setResponseCode(responsecode);
            this.response.setResponseMessage(responsestatusmsg);
            String rawUrl = tokens[1];
            while ((line = br.readLine()) != null && !line.equals("")) {
                tokens = line.split(": ", 2);
                if (tokens.length == 2) {
                    this.response.addHeader(tokens[0].toLowerCase(), tokens[1]);
                    continue;
                }
                logger.log(Level.INFO, "MALFORMWRONGHEADER {0}", new Object[]{line});
            }
            headerData = null;
        }
        this.headerread = true;
        this.keepalive = this.response.isKeepAliveEnabled();
        int code = this.response.getResponseCode();
        String location = this.response.getResponseHeader("location");
        String orgHost = this.requestWrapper.getCompleteHost();
        if ((code == 301 || code == 302) && location != null && this.internalRedirection) {
            this.doInternalRedirection();
        }
        if (this.response.isChunked() && this.bufferingConnection && this.streamBuffer == null) {
            this.streamBuffer = new ByteArrayOutputStream();
        }
        if (this.isProxyConnectRequest) {
            this.requestComplete = true;
            EventDispatcher.process(this, 3);
            if (this.isHttps()) {
                this.isSSL = true;
                this.ssl = new SSLWrapper(this.sc, this.getHost(), this.sniServerName);
            }
            this.isProxyConnectRequest = false;
        } else if (this.response.getResponseHeader("content-length") != null) {
            byte[] data;
            String respLength = this.response.getResponseHeader("content-length");
            int length = Integer.parseInt(respLength.trim());
            if (length == 0) {
                this.requestComplete = true;
                this.dispatch(true);
                this.readEndTime();
                this.close();
                return;
            }
            if (bb.remaining() == 0) {
                this.bodyBuffer = ByteBuffer.allocate(length);
                return;
            }
            if (length > 0 && bb.remaining() >= length) {
                data = new byte[length];
                bb.get(data);
                this.pendingcount -= data.length;
                if (this.response.isMultipart()) {
                    this.parseMultipart(data);
                } else {
                    this.response.setBody(data);
                }
                data = null;
                this.requestComplete = true;
                this.dispatch(true);
                this.readEndTime();
                this.close();
            } else if (bb.remaining() > 0 && bb.remaining() < length) {
                data = new byte[bb.remaining()];
                bb.get(data);
                this.pendingcount -= data.length;
                if (this.response.isMultipart()) {
                    this.parseMultipart(data);
                } else {
                    this.bodyBuffer = ByteBuffer.allocate(length);
                    this.bodyBuffer.put(data);
                }
                if (this.streammode) {
                    this.response.setStreamMode();
                    this.response.addChunk(data);
                    EventDispatcher.process(this, 4);
                }
                data = null;
            }
        } else {
            if (this.response.isChunked()) {
                return;
            }
            this.response.setAsyncMode();
            this.streamBuffer = new ByteArrayOutputStream();
            byte[] data = new byte[bb.remaining()];
            bb.get(data);
            this.pendingcount -= data.length;
            this.streamBuffer.write(data);
            if (this.streammode) {
                this.response.setStreamMode();
                this.response.addChunk(data);
                EventDispatcher.process(this, 4);
            }
            data = null;
        }
    }

    private void parseMultipart(byte[] data) {
        block6: {
            try {
                String contenttype = this.response.getResponseHeader("content-type");
                String boundary = this.getHeaderParameter(contenttype, "boundary");
                String charset = this.getHeaderParameter(contenttype, "charset");
                if (boundary == null) {
                    throw new IOException("Invalid MIME Header : " + contenttype);
                }
                if (charset == null) {
                    charset = "ISO-8859-1";
                }
                this.multipart = new Multipart(contenttype, boundary, charset);
                String[] parts = new String(data, charset).trim().split("--" + boundary);
                for (int i = 1; i < parts.length - 1; ++i) {
                    Part part = new Part(parts[i], charset);
                    this.multipart.addPart(part);
                }
                this.response.setMultipartData(this.multipart);
                this.multipart.setPreambleContent(parts[0].replace("\r\n", ""));
                if (parts[parts.length - 1].equals("--")) break block6;
                if (parts[parts.length - 1].startsWith("--")) {
                    this.multipart.setEpilogueContent(parts[parts.length - 1].replace("--\r\n", ""));
                    break block6;
                }
                throw new IOException("Invalid MIME content closure " + parts[parts.length - 1]);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Exception during Multipart parsing : ", ex);
            }
        }
    }

    private String getHeaderParameter(String headerValue, String parameter) {
        String[] parameters = headerValue.split(";");
        for (int i = 1; i < parameters.length; ++i) {
            if (!parameters[i].contains(parameter)) continue;
            String[] keyValue = parameters[i].split("=");
            if (keyValue.length == 2) {
                return keyValue[1].trim().replace("\"", "");
            }
            logger.log(Level.INFO, "UNDEFINED HEADER PARAM : {0}", new Object[]{parameters[i]});
        }
        return null;
    }

    private void doInternalRedirection() {
        try {
            String location = this.response.getResponseHeader("location");
            String newhost = this.getHost(location);
            String newuri = this.getURI(location);
            String newurl = "";
            logger.log(Level.INFO, "[Internal Redirection] [CURRENT URL] {0} [NEW LOCATION] ", new Object[]{this.url, location});
            if (location.startsWith("http")) {
                newurl = location.replaceAll("/.*", "") + "//" + location.replaceAll("http://|https://", "").replaceAll("/.*", "");
            } else if (newhost.length() != 0) {
                newurl = this.isHttps() ? "https://" + newhost : "http://" + newhost;
            } else {
                newhost = this.host;
                newurl = this.url;
            }
            if (this.host.equals(newhost) && this.uri.equals(newuri) && this.port == this.getPort(location) && this.isHttps() == this.isHttps(location)) {
                throw new Exception("Circular Redirection");
            }
            this.url = newurl;
            this.port = this.getPort(location);
            this.setRequestURI(newuri);
            if (location.contains("?")) {
                String[] params = location.split("\\?")[1].split("&");
                for (int i = 0; i < params.length; ++i) {
                    String[] paramSplit = params[i].split("=");
                    if (this.paramMap.containsKey(paramSplit[0])) continue;
                    throw new Exception("Undefined params on Redirection");
                }
            }
            this.resetDefaults();
            this.intializeDefaultParams();
            if (!this.connecthost.equals(this.host)) {
                this.setProxy(this.connecthost, this.connectport, this.proxyUsername, this.proxyPassword);
            } else if (!this.getHost().isEmpty()) {
                this.connecthost = this.getHost();
            }
            if (!this.getHost().isEmpty()) {
                this.host = this.getHost();
            }
            if (!this.isValidDomain(this.host) && this.isHttps()) {
                this.updateValidDomain(this.host);
            }
            if (!this.isPortInitiated(this.port)) {
                this.initializeSelectorpool(this.port);
            }
            this.hsdone = false;
            this.redirect = true;
            this.byteBuffer = ByteBuffer.allocate(3072);
            this.connect();
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception during internal redirection : ", e);
        }
    }

    public HttpResponse getResponse() {
        return this.response;
    }

    public HttpResponse getProxyErrorResponse(String message) {
        HttpResponse response = new HttpResponse();
        response.setResponseCode("502");
        response.setResponseMessage("Bad Gateway");
        try {
            response.setBody(message.getBytes("UTF-8"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return response;
    }

    public boolean isValidDomain(String domain) {
        return SSLManager.getExternalDomains().contains(domain);
    }

    public void updateValidDomain(String domain) {
        SSLManager.updateExternalDomains(domain);
    }

    public boolean isPortInitiated(int port) {
        return SelectorPoolFactory.getInstance(port) != null;
    }

    public void initializeSelectorpool(int port) {
        try {
            SelectorPoolFactory.init(port, 2);
        }
        catch (Exception ex) {
            logger.log(Level.INFO, "Exception - init selectorpool : ", ex);
        }
    }

    public void setSelectionKey(SelectionKey key) {
        this.key = key;
        if (this.isSSL()) {
            this.ssl.setSelectionKey(key);
        }
    }

    public SelectionKey getSelectionKey() {
        return this.key;
    }

    public long getInitConnectTime() {
        return this.initConnectTime;
    }

    public void setConnectExpireTime(long time) {
        this.connectexpiretime = time;
    }

    public long getConnectExpireTime() {
        return this.connectexpiretime;
    }

    public boolean isConnectExpired() {
        return System.currentTimeMillis() >= this.connectexpiretime;
    }

    public boolean isInvalidConnectExpireTime(long time) {
        return time != this.connectexpiretime;
    }

    private void update() {
        try {
            if (!this.isWebsocketConnection) {
                if (this.isSSL) {
                    if (this.proxyEnabled) {
                        ConnectionManager.updateConnectionInfo(this.connecthost, this.connectport, this.host, this.port, this.proxyUsername, this.proxyPassword, this.sc, this.key, this.ssl.getSSLEngine());
                    } else {
                        ConnectionManager.updateConnectionInfo(this.host, this.port, this.sc, this.key, this.ssl.getSSLEngine());
                    }
                } else if (this.proxyEnabled) {
                    ConnectionManager.updateConnectionInfo(this.connecthost, this.connectport, this.host, this.port, this.proxyUsername, this.proxyPassword, this.sc, this.key, null);
                } else {
                    ConnectionManager.updateConnectionInfo(this.host, this.port, this.sc, this.key, null);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in update : ", e);
        }
    }

    private boolean isConnectionAlive() {
        try {
            int count = -1;
            if (this.isSSL) {
                count = this.ssl.read();
            } else {
                ByteBuffer bf = ByteBuffer.allocate(0);
                count = this.sc.read(bf);
            }
            return count != -1;
        }
        catch (Exception e) {
            return false;
        }
    }

    private boolean isCloseable() {
        try {
            if (this.keepalive && this.isConnectionOpen() && this.isConnectionAlive()) {
                this.update();
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (!this.isWebsocketConnection && ConnectionManager.isKeepaliveEnabled() && !this.isCloseable()) {
                    ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
                    if (this.isSSL) {
                        this.ssl.clearDataBuffer();
                    }
                    this.closed = true;
                    this.statReports.put("closetime", System.currentTimeMillis());
                    return;
                }
            }
            catch (Exception e) {
                logger.log(Level.INFO, "Exception in keepalive close : ", e);
            }
            try {
                if (this.streamBuffer != null && !this.streammode) {
                    this.response.addChunk(this.streamBuffer.toByteArray());
                    EventDispatcher.process(this, 3);
                    this.clearEOFBuffer();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in streamBuffer close : ", ex);
            }
            try {
                ReadTimeOutListener.TRACKER.remove(this.readexpiretime, this);
            }
            catch (Exception ex) {
                // empty catch block
            }
            try {
                if (this.isSSL) {
                    this.ssl.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in ssl close : ", ex);
            }
            SocketChannel ch = null;
            try {
                ch = (SocketChannel)this.key.channel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel : ", ex);
            }
            try {
                this.key.cancel();
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key cancel : ", ex);
            }
            try {
                if (ch.isOpen()) {
                    ch.close();
                }
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "Exception in key channel close : ", ex);
            }
            this.closed = true;
            this.statReports.put("closetime", System.currentTimeMillis());
        }
    }

    public boolean isClosed() {
        return this.closed;
    }

    public Object getLockObject() {
        return this.lock;
    }

    public void notifyListener(int event) throws Exception {
        this.notifyListener(event, null);
    }

    public void notifyListener(int event, byte[] data) throws Exception {
        if (!this.streammode || this.isProxyConnectRequest) {
            this.notifyListener(event, this.requestWrapper, data);
        } else if (this.streamListener != null) {
            this.notifyStreamListener(event, this.requestWrapper);
        } else if (this.listener != null) {
            this.notifyListener(event, this.requestWrapper, data);
        }
    }

    private void notifyListener(int event, HttpRequestWrapper requestWrapper, byte[] data) throws Exception {
        switch (event) {
            case -1: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.listener.onConnectError(requestWrapper);
                return;
            }
            case -2: {
                this.listener.onReadTimeout(requestWrapper);
                return;
            }
            case 1: {
                this.listener.onConnect(requestWrapper);
                return;
            }
            case 2: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                if (!this.redirect) {
                    this.listener.onSubmit(requestWrapper);
                }
                return;
            }
            case -3: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.listener.onSubmitError(requestWrapper);
                return;
            }
            case 3: {
                int code = this.response.getResponseCode();
                if (code >= 400) {
                    this.listener.onResponseError(requestWrapper);
                    return;
                }
                try {
                    this.listener.onResponse(requestWrapper);
                }
                catch (Exception ex) {
                    logger.log(Level.INFO, "Exception in notifyListener : ", ex);
                }
                return;
            }
            case -4: {
                try {
                    this.listener.onResponseError(requestWrapper);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case 6: {
                try {
                    this.listener.onWriteRefill(requestWrapper);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case -5: {
                this.listener.onDisconnect(requestWrapper);
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                return;
            }
            case 8: {
                this.listener.onPingSent(requestWrapper);
                return;
            }
            case 9: {
                this.listener.onPongReceived(requestWrapper, data);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyStreamListener(int event, HttpRequestWrapper requestWrapper) throws Exception {
        switch (event) {
            case -1: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.streamListener.onConnectError(requestWrapper);
                return;
            }
            case -2: {
                this.streamListener.onReadTimeout(requestWrapper);
                return;
            }
            case 2: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                if (!this.redirect) {
                    this.streamListener.onSubmit(requestWrapper);
                }
                return;
            }
            case -3: {
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                this.streamListener.onSubmitError(requestWrapper);
                return;
            }
            case -4: {
                try {
                    this.streamListener.onResponseError(requestWrapper);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            case -5: {
                this.streamListener.onDisconnect(requestWrapper);
                ConnectTimeOutListener.TRACKER.remove(this.connectexpiretime, this.key);
                return;
            }
            case 4: {
                Object object = this.getDispatcherLock();
                synchronized (object) {
                    if (this.response.isChunkAvailable()) {
                        this.streamListener.onData(requestWrapper);
                    } else if (!this.response.isBodyEmpty()) {
                        this.streamListener.onData(requestWrapper);
                    }
                }
                return;
            }
            case 5: {
                Object object = this.getDispatcherLock();
                synchronized (object) {
                    this.streamListener.onData(requestWrapper);
                    this.streamListener.onComplete(requestWrapper);
                }
                return;
            }
            case 6: {
                try {
                    this.streamListener.onWriteRefill(requestWrapper);
                    return;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private synchronized Object getDispatcherLock() {
        if (this.dispatcherthreadsafe) {
            return this.streamlock;
        }
        return new Object();
    }

    public void setDispatcherThreadSafe(boolean status) {
        this.dispatcherthreadsafe = status;
    }

    private void dispatch() {
        this.dispatch(false);
    }

    private void dispatch(boolean isFinalChunk) {
        if (this.streammode) {
            if (!isFinalChunk) {
                EventDispatcher.process(this, 4);
            } else {
                EventDispatcher.process(this, 5);
            }
        } else {
            EventDispatcher.process(this, 3);
        }
    }

    public void setInternalRedirection(boolean internalRedirection) {
        this.internalRedirection = internalRedirection;
    }

    public void setInterestOps(int op) {
        this.key.interestOps(op);
    }

    public boolean getInternalRedirection() {
        return this.internalRedirection;
    }

    public HashMap getReports(boolean humanReadable) {
        LinkedHashMap humanReadableStats = new LinkedHashMap();
        if (humanReadable) {
            for (Map.Entry pair : this.statReports.entrySet()) {
                if (pair.getKey() == "bytesread" || pair.getKey() == "byteswritten" || pair.getKey() == "readtime" || pair.getKey() == "writetime" || pair.getKey() == "handshaketime") {
                    humanReadableStats.put(pair.getKey(), pair.getValue());
                    continue;
                }
                humanReadableStats.put(pair.getKey(), new Date(Long.parseLong(pair.getValue().toString())));
            }
            return humanReadableStats;
        }
        return this.statReports;
    }

    class ProxyImpl
    implements HttpRequestEventListener {
        private HttpRequest request;

        ProxyImpl() {
        }

        public void setRequest(HttpRequest request) {
            this.request = request;
        }

        @Override
        public void onConnectError(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON CONNECT ERROR {0}", new Object[]{req});
            this.request.setRequestListener();
            req.setResponse(this.request.getProxyErrorResponse("Proxy connect failure"));
            try {
                this.request.notifyListener(-1);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "FAILURE TO NOTIFY REQUEST LISTENER ON CONNECT ERROR :: {0} Exception {1}", new Object[]{req, ex});
            }
        }

        @Override
        public void onReadTimeout(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON READ TIMEOUT {0}", new Object[]{req});
            this.request.setRequestListener();
            req.setResponse(this.request.getProxyErrorResponse("Proxy read timeout"));
            try {
                this.request.notifyListener(-2);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "FAILURE TO NOTIFY REQUEST LISTENER ON READ TIMEOUT ERROR :: {0} Exception {1}", new Object[]{req, ex});
            }
        }

        @Override
        public void onConnect(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON CONNECT {0}", new Object[]{req});
        }

        @Override
        public void onSubmit(HttpRequestWrapper req) {
            HttpRequest.this.statReports.put("proxyinittime", System.currentTimeMillis());
            logger.log(Level.INFO, "PROXY LISTENER :: ON SUBMIT ", new Object[]{req});
        }

        @Override
        public void onSubmitError(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON SUBMIT ERROR ", new Object[]{req});
            this.request.setRequestListener();
            req.setResponse(this.request.getProxyErrorResponse("Proxy request submit failure"));
            try {
                this.request.notifyListener(-3);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "FAILURE TO NOTIFY REQUEST LISTENER ON SUBMIT ERROR :: {0} Exception {1}", new Object[]{req, ex});
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onResponse(HttpRequestWrapper req) {
            block10: {
                logger.log(Level.INFO, "PROXY LISTENER :: ON RESPONSE {0}, RESPONSE CODE : {1}", new Object[]{req, req.getResponse().getResponseCode()});
                if (req.getResponse().getResponseCode() >= 200 && req.getResponse().getResponseCode() <= 208) {
                    try {
                        this.request.setRequestListener();
                        this.request.resetDefaults();
                        HttpRequest.this.byteBuffer = ByteBuffer.allocate(3072);
                        if (!HttpRequest.this.isSSL()) {
                            this.request.writeData();
                            break block10;
                        }
                        Object object = HttpRequest.this.lock;
                        synchronized (object) {
                            this.request.key.interestOps(5);
                        }
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "Exception in proxyListener's onResponse : ", ex);
                    }
                } else {
                    this.request.setRequestListener();
                    try {
                        this.request.notifyListener(3);
                    }
                    catch (Exception ex) {
                        logger.log(Level.INFO, "FAILURE TO NOTIFY REQUEST LISTENER ON RESPONSE :: {0} Exception ", new Object[]{req, ex});
                    }
                }
            }
            HttpRequest.this.statReports.put("proxytunnelconnecttime", System.currentTimeMillis());
        }

        @Override
        public void onResponseError(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON RESPONSE ERROR {0}, ", new Object[]{req, req.getResponse().getResponseCode()});
            this.request.setRequestListener();
            try {
                this.request.notifyListener(-4);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "FAILURE TO NOTIFY REQUEST LISTENER ON RESPONSE ERROR :: {0} Exception {1}", new Object[]{req, ex});
            }
        }

        @Override
        public void onWriteRefill(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON WRITE REFILL {0}", new Object[]{req});
        }

        @Override
        public void onDisconnect(HttpRequestWrapper req) {
            logger.log(Level.INFO, "PROXY LISTENER :: ON DISCONNECT {0}", new Object[]{req});
            this.request.setRequestListener();
            try {
                this.request.notifyListener(-5);
            }
            catch (Exception ex) {
                logger.log(Level.INFO, "FAILURE TO NOTIFY REQUEST LISTENER ON DISCONNECT :: {0} Exception {1}", new Object[]{req, ex});
            }
        }

        @Override
        public void onPingSent(HttpRequestWrapper req) {
        }

        @Override
        public void onPongReceived(HttpRequestWrapper req, byte[] data) {
        }
    }
}

