/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.http;

import com.adventnet.wms.nioclient.http.HttpKeepaliveConnection;
import com.adventnet.wms.nioclient.http.HttpProxyKeepaliveConnection;
import com.adventnet.wms.nioclient.http.KeepaliveTimeOutListener;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLEngine;

public class ConnectionManager {
    private static Logger logger = Logger.getLogger(ConnectionManager.class.getName());
    private static ConcurrentHashMap<String, ConcurrentLinkedQueue<HttpKeepaliveConnection>> connection = new ConcurrentHashMap();
    private static ConcurrentHashMap<String, HttpProxyKeepaliveConnection> proxyConnection = new ConcurrentHashMap();
    private static HashSet<String> excludedomains = new HashSet();
    private static int keepaliveThreshold = -1;
    private static int keepaliveTimeout = -1;
    private static boolean keepalive = false;
    private static boolean initialized = false;

    public static void init(int threshold, int timeout) {
        if (!initialized) {
            initialized = true;
            keepaliveThreshold = threshold;
            keepaliveTimeout = timeout;
            keepalive = true;
        }
    }

    public static void setExcludeKeepaliveDomains(String domains) {
        if (initialized && domains.length() > 0) {
            excludedomains = ConnectionManager.getHashSet(domains);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void updateConnectionInfo(String host, int port, SocketChannel sc, SelectionKey key, SSLEngine engine) {
        try {
            if (excludedomains != null && !excludedomains.isEmpty() && excludedomains.contains(host)) {
                return;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!ConnectionManager.isChannelOpen(sc)) return;
        try {
            if (connection.containsKey(ConnectionManager.getHost(host, port))) {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = connection.get(ConnectionManager.getHost(host, port));
                if (queue.size() >= keepaliveThreshold) return;
                ConnectionManager.update(sc, key, engine, ConnectionManager.getHost(host, port), queue);
                return;
            } else {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = new ConcurrentLinkedQueue<HttpKeepaliveConnection>();
                ConnectionManager.update(sc, key, engine, ConnectionManager.getHost(host, port), queue);
            }
            return;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in Update Connection Info : ", e);
        }
    }

    public static void updateConnectionInfo(String proxyhost, int proxyport, String host, int port, String proxyUsername, String proxyPassword, SocketChannel sc, SelectionKey key, SSLEngine engine) {
        block9: {
            try {
                if (excludedomains != null && !excludedomains.isEmpty() && excludedomains.contains(host)) {
                    return;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (ConnectionManager.isChannelOpen(sc)) {
                try {
                    if (proxyConnection.containsKey(ConnectionManager.getHost(proxyhost, proxyport))) {
                        long connectionExpireTime = System.currentTimeMillis() + (long)keepaliveTimeout;
                        HttpProxyKeepaliveConnection obj = proxyConnection.get(ConnectionManager.getHost(proxyhost, proxyport));
                        if (obj.getProxyUsername().equals(proxyUsername) && obj.getProxyPassword().equals(proxyPassword)) {
                            obj.addConnection(ConnectionManager.getHost(host, port), sc, key, engine, connectionExpireTime);
                        }
                        break block9;
                    }
                    long connectionExpireTime = System.currentTimeMillis() + (long)keepaliveTimeout;
                    HttpProxyKeepaliveConnection obj = new HttpProxyKeepaliveConnection(ConnectionManager.getHost(proxyhost, proxyport), proxyUsername, proxyPassword, keepaliveThreshold);
                    proxyConnection.put(ConnectionManager.getHost(proxyhost, proxyport), obj);
                    obj.addConnection(ConnectionManager.getHost(host, port), sc, key, engine, connectionExpireTime);
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception in update Connection Info : ", e);
                }
            } else {
                logger.log(Level.INFO, "Channel is closed before update channel information");
            }
        }
    }

    public static synchronized HttpKeepaliveConnection getAvailableConnection(String domain, int port) {
        try {
            ConcurrentLinkedQueue<HttpKeepaliveConnection> queue;
            String host = ConnectionManager.getHost(domain, port);
            if (connection.containsKey(host) && !(queue = connection.get(host)).isEmpty()) {
                HttpKeepaliveConnection obj = queue.poll();
                KeepaliveTimeOutListener.TRACKER.remove(obj.getConnectionExpireTime(), obj);
                return obj;
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in getConnection : ", e);
        }
        return null;
    }

    public static synchronized HttpKeepaliveConnection getAvailableConnection(String proxyHost, int proxyPort, String domain, int port, String proxyUsername, String proxyPassword) {
        try {
            HttpProxyKeepaliveConnection obj;
            if (proxyConnection.containsKey(ConnectionManager.getHost(proxyHost, proxyPort)) && proxyUsername.equals((obj = proxyConnection.get(ConnectionManager.getHost(proxyHost, proxyPort))).getProxyUsername()) && proxyPassword.equals(obj.getProxyPassword()) && obj.isConnectedHost(ConnectionManager.getHost(domain, port), proxyUsername, proxyPassword)) {
                return obj.getConnection(ConnectionManager.getHost(domain, port), proxyUsername, proxyPassword);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in getConnection : ", e);
        }
        return null;
    }

    public static boolean isExpired(HttpKeepaliveConnection obj) {
        try {
            if (ConnectionManager.isChannelOpen(obj.getSocketChannel()) && System.currentTimeMillis() <= obj.getConnectionExpireTime()) {
                return false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return true;
    }

    public static boolean isExpired(Hashtable<String, Object> ht) {
        try {
            return ConnectionManager.isExpired((HttpKeepaliveConnection)ht.get("connectioninfo"));
        }
        catch (Exception e) {
            return true;
        }
    }

    public static void handleExpired(HttpKeepaliveConnection obj) {
        try {
            String host = obj.getHost();
            if (connection.containsKey(host)) {
                ConcurrentLinkedQueue<HttpKeepaliveConnection> queue = connection.get(host);
                if (queue.contains(obj)) {
                    ConnectionManager.handleClose(obj.getSocketChannel(), obj.getSelectionKey());
                    queue.remove(obj);
                    KeepaliveTimeOutListener.TRACKER.remove(obj.getConnectionExpireTime(), obj);
                }
                if (ConnectionManager.isQueueEmpty(host) && connection.containsKey(host)) {
                    ConnectionManager.removeHost(host);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in removeFromQueue : ", e);
        }
    }

    public static void handleExpired(Hashtable<String, Object> ht) {
        try {
            HttpProxyKeepaliveConnection proxy = (HttpProxyKeepaliveConnection)ht.get("proxyinfo");
            HttpKeepaliveConnection keepaliveconnection = (HttpKeepaliveConnection)ht.get("connectioninfo");
            proxy.handleExpired(keepaliveconnection);
            if (proxy.isEmpty()) {
                proxyConnection.remove(proxy.getProxyHostName());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static boolean isKeepaliveEnabled() {
        return keepalive;
    }

    private static void update(SocketChannel sc, SelectionKey key, SSLEngine engine, String host, ConcurrentLinkedQueue<HttpKeepaliveConnection> queue) {
        try {
            if (ConnectionManager.isChannelOpen(sc)) {
                long connectionExpireTime = System.currentTimeMillis() + (long)keepaliveTimeout;
                HttpKeepaliveConnection keepalive = new HttpKeepaliveConnection(host, sc, key, engine, connectionExpireTime);
                queue.add(keepalive);
                connection.put(host, queue);
                KeepaliveTimeOutListener.TRACKER.touch(connectionExpireTime, keepalive);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in updation : ", e);
        }
    }

    private static void removeHost(String host) {
        try {
            if (connection.containsKey(host)) {
                connection.remove(host);
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in remove host : ", e);
        }
    }

    private static boolean isQueueEmpty(String host) {
        try {
            if (connection.containsKey(host)) {
                if (connection.get(host).isEmpty()) {
                    ConnectionManager.removeHost(host);
                    return true;
                }
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return true;
        }
    }

    private static boolean isChannelOpen(SocketChannel sc) {
        try {
            return sc.isOpen();
        }
        catch (Exception e) {
            return false;
        }
    }

    private static HashSet<String> getHashSet(String domains) {
        try {
            if (domains.length() == 0) {
                return null;
            }
            HashSet<String> set = new HashSet<String>();
            StringTokenizer st = new StringTokenizer(domains, ",");
            while (st.hasMoreTokens()) {
                set.add(st.nextToken().trim());
            }
            return set;
        }
        catch (Exception e) {
            return new HashSet<String>();
        }
    }

    private static void handleClose(SocketChannel sc, SelectionKey key) {
        try {
            key.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            if (sc.isOpen()) {
                sc.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static String getHost(String host, int port) {
        return host + ":" + port;
    }
}

