/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.exception;

import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.CertificateParsingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NIOSSLCertificateException
extends CertificateException {
    private int errorCode = -1;
    private String errorMsg = null;
    private static Logger logger = Logger.getLogger(NIOSSLCertificateException.class.getName());

    public NIOSSLCertificateException(String msg) {
        super(msg);
        this.updateErrorCode(msg, null);
    }

    public NIOSSLCertificateException(String msg, Exception ex) {
        super(msg, ex.getCause());
        this.updateErrorCode(msg, ex);
    }

    public NIOSSLCertificateException(Exception ex) {
        super(ex.getCause());
        this.updateErrorCode(null, ex);
    }

    private void updateErrorCode(String msg, Exception ex) {
        try {
            if (ex != null) {
                if (ex instanceof CertificateException) {
                    this.errorCode = this.getErrorCodeFromMsg(msg);
                    if (this.errorCode == -1) {
                        this.errorCode = 1;
                    }
                } else if (ex instanceof CertificateEncodingException) {
                    this.errorCode = 2;
                } else if (ex instanceof CertificateExpiredException) {
                    this.errorCode = 3;
                } else if (ex instanceof CertificateNotYetValidException) {
                    this.errorCode = 4;
                } else if (ex instanceof CertificateParsingException) {
                    this.errorCode = 5;
                }
            }
            if (this.errorCode == -1 && msg != null) {
                this.errorCode = this.getErrorCodeFromMsg(msg);
            }
            this.errorMsg = msg;
        }
        catch (Exception e) {
            logger.log(Level.INFO, "Exception in update Error code ", e);
        }
    }

    private int getErrorCodeFromMsg(String msg) {
        int code = -1;
        if (msg != null) {
            if (msg.equals("Certificate Expired")) {
                code = 3;
            } else if (msg.equals("Subject DN not present")) {
                code = 6;
            } else if (msg.equals("Subject DN Mismatch")) {
                code = 7;
            } else if (msg.equals("signature verification failed")) {
                code = 8;
            } else if (msg.equals("subject/issuer verification failed of")) {
                code = 9;
            } else if (msg.equals("Unknown issue")) {
                code = 1;
            }
        }
        return code;
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }
}

