/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.wms.nioclient.apns;

import org.json.JSONException;
import org.json.JSONObject;

public class APNSPayload {
    private final String APS = "aps";
    private final String BADGE = "badge";
    private final String ALERT = "alert";
    private final String SOUND = "sound";
    private String charset = "UTF-8";
    private int osVersion = 7;
    private JSONObject payload = new JSONObject();
    private JSONObject apsObject = new JSONObject();
    private int expiry = 86400;

    public APNSPayload() throws JSONException {
        this.payload.put("aps", (Object)this.apsObject);
    }

    public JSONObject getAPSObject() {
        return this.apsObject;
    }

    public void addCustomData(String name, Object value, boolean check) throws JSONException {
        if (check) {
            this.payload.putOpt(name, value);
        } else {
            this.payload.put(name, value);
        }
    }

    private void addAPSData(String name, int data, boolean check) throws JSONException {
        if (check) {
            this.apsObject.putOpt(name, (Object)data);
        } else {
            this.apsObject.put(name, data);
        }
    }

    private void addAPSData(String name, String data, boolean check) throws JSONException {
        if (check) {
            this.apsObject.putOpt(name, (Object)data);
        } else {
            this.apsObject.put(name, (Object)data);
        }
    }

    private void addAPSData(String name, Object data, boolean check) throws JSONException {
        if (check) {
            this.apsObject.putOpt(name, data);
        } else {
            this.apsObject.put(name, data);
        }
    }

    public void addBadge(int badge) throws JSONException {
        this.addAPSData("badge", badge, true);
    }

    public void addAlert(String alert) throws JSONException {
        this.addAPSData("alert", alert, true);
    }

    public void addAlert(Object alert) throws JSONException {
        this.addAPSData("alert", alert, true);
    }

    public void addSound() throws JSONException {
        this.addSound("default");
    }

    public void addSound(String sound) throws JSONException {
        this.addAPSData("sound", sound, true);
    }

    public void setExpiry(int sec) {
        this.expiry = sec;
    }

    public int getExpiry() {
        return this.expiry;
    }

    public void setEncoding(String charset) {
        this.charset = charset;
    }

    public void setOSVersion(int osVersion) {
        if (osVersion < 1 || osVersion > 9) {
            return;
        }
        this.osVersion = osVersion;
    }

    public int getOSVersion() {
        return this.osVersion;
    }

    public byte[] getBytes() throws Exception {
        return this.toString().getBytes(this.charset);
    }

    public String toString() {
        return this.payload.toString();
    }
}

